/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkflowmonitor.NetworkFlowMonitorClient;
import software.amazon.awssdk.services.networkflowmonitor.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsRequest;
import software.amazon.awssdk.services.networkflowmonitor.model.GetQueryResultsWorkloadInsightsTopContributorsResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.WorkloadInsightsTopContributorsRow;

public class GetQueryResultsWorkloadInsightsTopContributorsIterable
implements SdkIterable<GetQueryResultsWorkloadInsightsTopContributorsResponse> {
    private final NetworkFlowMonitorClient client;
    private final GetQueryResultsWorkloadInsightsTopContributorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetQueryResultsWorkloadInsightsTopContributorsIterable(NetworkFlowMonitorClient client, GetQueryResultsWorkloadInsightsTopContributorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetQueryResultsWorkloadInsightsTopContributorsResponseFetcher();
    }

    public Iterator<GetQueryResultsWorkloadInsightsTopContributorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkloadInsightsTopContributorsRow> topContributors() {
        Function<GetQueryResultsWorkloadInsightsTopContributorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topContributors() != null) {
                return response.topContributors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetQueryResultsWorkloadInsightsTopContributorsResponseFetcher
    implements SyncPageFetcher<GetQueryResultsWorkloadInsightsTopContributorsResponse> {
        private GetQueryResultsWorkloadInsightsTopContributorsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsWorkloadInsightsTopContributorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetQueryResultsWorkloadInsightsTopContributorsResponse nextPage(GetQueryResultsWorkloadInsightsTopContributorsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsWorkloadInsightsTopContributorsIterable.this.client.getQueryResultsWorkloadInsightsTopContributors(GetQueryResultsWorkloadInsightsTopContributorsIterable.this.firstRequest);
            }
            return GetQueryResultsWorkloadInsightsTopContributorsIterable.this.client.getQueryResultsWorkloadInsightsTopContributors((GetQueryResultsWorkloadInsightsTopContributorsRequest)((Object)GetQueryResultsWorkloadInsightsTopContributorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

