/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkflowmonitor.model.MonitorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitorSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitorSummary> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorArn").getter(MonitorSummary.getter(MonitorSummary::monitorArn)).setter(MonitorSummary.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorArn").build()}).build();
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(MonitorSummary.getter(MonitorSummary::monitorName)).setter(MonitorSummary.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()}).build();
    private static final SdkField<String> MONITOR_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorStatus").getter(MonitorSummary.getter(MonitorSummary::monitorStatusAsString)).setter(MonitorSummary.setter(Builder::monitorStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD, MONITOR_NAME_FIELD, MONITOR_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("monitorArn", MONITOR_ARN_FIELD);
            this.put("monitorName", MONITOR_NAME_FIELD);
            this.put("monitorStatus", MONITOR_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String monitorArn;
    private final String monitorName;
    private final String monitorStatus;

    private MonitorSummary(BuilderImpl builder) {
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.monitorStatus = builder.monitorStatus;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final MonitorStatus monitorStatus() {
        return MonitorStatus.fromValue(this.monitorStatus);
    }

    public final String monitorStatusAsString() {
        return this.monitorStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorSummary)) {
            return false;
        }
        MonitorSummary other = (MonitorSummary)obj;
        return Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.monitorStatusAsString(), other.monitorStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MonitorSummary").add("MonitorArn", (Object)this.monitorArn()).add("MonitorName", (Object)this.monitorName()).add("MonitorStatus", (Object)this.monitorStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "monitorStatus": {
                return Optional.ofNullable(clazz.cast(this.monitorStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitorSummary, T> g) {
        return obj -> g.apply((MonitorSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitorArn;
        private String monitorName;
        private String monitorStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorSummary model) {
            this.monitorArn(model.monitorArn);
            this.monitorName(model.monitorName);
            this.monitorStatus(model.monitorStatus);
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorStatus() {
            return this.monitorStatus;
        }

        public final void setMonitorStatus(String monitorStatus) {
            this.monitorStatus = monitorStatus;
        }

        @Override
        public final Builder monitorStatus(String monitorStatus) {
            this.monitorStatus = monitorStatus;
            return this;
        }

        @Override
        public final Builder monitorStatus(MonitorStatus monitorStatus) {
            this.monitorStatus(monitorStatus == null ? null : monitorStatus.toString());
            return this;
        }

        public MonitorSummary build() {
            return new MonitorSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitorSummary> {
        public Builder monitorArn(String var1);

        public Builder monitorName(String var1);

        public Builder monitorStatus(String var1);

        public Builder monitorStatus(MonitorStatus var1);
    }
}

