/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkflowmonitor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkflowmonitor.model.NetworkFlowMonitorResponse;
import software.amazon.awssdk.services.networkflowmonitor.model.ScopeStatus;
import software.amazon.awssdk.services.networkflowmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScopeResponse
extends NetworkFlowMonitorResponse
implements ToCopyableBuilder<Builder, UpdateScopeResponse> {
    private static final SdkField<String> SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeId").getter(UpdateScopeResponse.getter(UpdateScopeResponse::scopeId)).setter(UpdateScopeResponse.setter(Builder::scopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateScopeResponse.getter(UpdateScopeResponse::statusAsString)).setter(UpdateScopeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SCOPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopeArn").getter(UpdateScopeResponse.getter(UpdateScopeResponse::scopeArn)).setter(UpdateScopeResponse.setter(Builder::scopeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(UpdateScopeResponse.getter(UpdateScopeResponse::tags)).setter(UpdateScopeResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_ID_FIELD, STATUS_FIELD, SCOPE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("scopeId", SCOPE_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("scopeArn", SCOPE_ARN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String scopeId;
    private final String status;
    private final String scopeArn;
    private final Map<String, String> tags;

    private UpdateScopeResponse(BuilderImpl builder) {
        super(builder);
        this.scopeId = builder.scopeId;
        this.status = builder.status;
        this.scopeArn = builder.scopeArn;
        this.tags = builder.tags;
    }

    public final String scopeId() {
        return this.scopeId;
    }

    public final ScopeStatus status() {
        return ScopeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String scopeArn() {
        return this.scopeArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScopeResponse)) {
            return false;
        }
        UpdateScopeResponse other = (UpdateScopeResponse)((Object)obj);
        return Objects.equals(this.scopeId(), other.scopeId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.scopeArn(), other.scopeArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateScopeResponse").add("ScopeId", (Object)this.scopeId()).add("Status", (Object)this.statusAsString()).add("ScopeArn", (Object)this.scopeArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scopeId": {
                return Optional.ofNullable(clazz.cast(this.scopeId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "scopeArn": {
                return Optional.ofNullable(clazz.cast(this.scopeArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScopeResponse, T> g) {
        return obj -> g.apply((UpdateScopeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFlowMonitorResponse.BuilderImpl
    implements Builder {
        private String scopeId;
        private String status;
        private String scopeArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScopeResponse model) {
            super(model);
            this.scopeId(model.scopeId);
            this.status(model.status);
            this.scopeArn(model.scopeArn);
            this.tags(model.tags);
        }

        public final String getScopeId() {
            return this.scopeId;
        }

        public final void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public final Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScopeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getScopeArn() {
            return this.scopeArn;
        }

        public final void setScopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
        }

        @Override
        public final Builder scopeArn(String scopeArn) {
            this.scopeArn = scopeArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateScopeResponse build() {
            return new UpdateScopeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFlowMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScopeResponse> {
        public Builder scopeId(String var1);

        public Builder status(String var1);

        public Builder status(ScopeStatus var1);

        public Builder scopeArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

