/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRulePriority;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRulePriorityListCopier;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupRequestPhase;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProxyRulePrioritiesRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, UpdateProxyRulePrioritiesRequest> {
    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleGroupName").getter(UpdateProxyRulePrioritiesRequest.getter(UpdateProxyRulePrioritiesRequest::proxyRuleGroupName)).setter(UpdateProxyRulePrioritiesRequest.setter(Builder::proxyRuleGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build()}).build();
    private static final SdkField<String> PROXY_RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyRuleGroupArn").getter(UpdateProxyRulePrioritiesRequest.getter(UpdateProxyRulePrioritiesRequest::proxyRuleGroupArn)).setter(UpdateProxyRulePrioritiesRequest.setter(Builder::proxyRuleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupArn").build()}).build();
    private static final SdkField<String> RULE_GROUP_REQUEST_PHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupRequestPhase").getter(UpdateProxyRulePrioritiesRequest.getter(UpdateProxyRulePrioritiesRequest::ruleGroupRequestPhaseAsString)).setter(UpdateProxyRulePrioritiesRequest.setter(Builder::ruleGroupRequestPhase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupRequestPhase").build()}).build();
    private static final SdkField<List<ProxyRulePriority>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(UpdateProxyRulePrioritiesRequest.getter(UpdateProxyRulePrioritiesRequest::rules)).setter(UpdateProxyRulePrioritiesRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRulePriority::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateProxyRulePrioritiesRequest.getter(UpdateProxyRulePrioritiesRequest::updateToken)).setter(UpdateProxyRulePrioritiesRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_NAME_FIELD, PROXY_RULE_GROUP_ARN_FIELD, RULE_GROUP_REQUEST_PHASE_FIELD, RULES_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProxyRulePrioritiesRequest.memberNameToFieldInitializer();
    private final String proxyRuleGroupName;
    private final String proxyRuleGroupArn;
    private final String ruleGroupRequestPhase;
    private final List<ProxyRulePriority> rules;
    private final String updateToken;

    private UpdateProxyRulePrioritiesRequest(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.proxyRuleGroupArn = builder.proxyRuleGroupArn;
        this.ruleGroupRequestPhase = builder.ruleGroupRequestPhase;
        this.rules = builder.rules;
        this.updateToken = builder.updateToken;
    }

    public final String proxyRuleGroupName() {
        return this.proxyRuleGroupName;
    }

    public final String proxyRuleGroupArn() {
        return this.proxyRuleGroupArn;
    }

    public final RuleGroupRequestPhase ruleGroupRequestPhase() {
        return RuleGroupRequestPhase.fromValue(this.ruleGroupRequestPhase);
    }

    public final String ruleGroupRequestPhaseAsString() {
        return this.ruleGroupRequestPhase;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<ProxyRulePriority> rules() {
        return this.rules;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupRequestPhaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRulePrioritiesRequest)) {
            return false;
        }
        UpdateProxyRulePrioritiesRequest other = (UpdateProxyRulePrioritiesRequest)((Object)obj);
        return Objects.equals(this.proxyRuleGroupName(), other.proxyRuleGroupName()) && Objects.equals(this.proxyRuleGroupArn(), other.proxyRuleGroupArn()) && Objects.equals(this.ruleGroupRequestPhaseAsString(), other.ruleGroupRequestPhaseAsString()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProxyRulePrioritiesRequest").add("ProxyRuleGroupName", (Object)this.proxyRuleGroupName()).add("ProxyRuleGroupArn", (Object)this.proxyRuleGroupArn()).add("RuleGroupRequestPhase", (Object)this.ruleGroupRequestPhaseAsString()).add("Rules", this.hasRules() ? this.rules() : null).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyRuleGroupName": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroupName()));
            }
            case "ProxyRuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroupArn()));
            }
            case "RuleGroupRequestPhase": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupRequestPhaseAsString()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("ProxyRuleGroupArn", PROXY_RULE_GROUP_ARN_FIELD);
        map.put("RuleGroupRequestPhase", RULE_GROUP_REQUEST_PHASE_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRulePrioritiesRequest, T> g) {
        return obj -> g.apply((UpdateProxyRulePrioritiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyRuleGroupName;
        private String proxyRuleGroupArn;
        private String ruleGroupRequestPhase;
        private List<ProxyRulePriority> rules = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRulePrioritiesRequest model) {
            super(model);
            this.proxyRuleGroupName(model.proxyRuleGroupName);
            this.proxyRuleGroupArn(model.proxyRuleGroupArn);
            this.ruleGroupRequestPhase(model.ruleGroupRequestPhase);
            this.rules(model.rules);
            this.updateToken(model.updateToken);
        }

        public final String getProxyRuleGroupName() {
            return this.proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final String getProxyRuleGroupArn() {
            return this.proxyRuleGroupArn;
        }

        public final void setProxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
        }

        @Override
        public final Builder proxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
            return this;
        }

        public final String getRuleGroupRequestPhase() {
            return this.ruleGroupRequestPhase;
        }

        public final void setRuleGroupRequestPhase(String ruleGroupRequestPhase) {
            this.ruleGroupRequestPhase = ruleGroupRequestPhase;
        }

        @Override
        public final Builder ruleGroupRequestPhase(String ruleGroupRequestPhase) {
            this.ruleGroupRequestPhase = ruleGroupRequestPhase;
            return this;
        }

        @Override
        public final Builder ruleGroupRequestPhase(RuleGroupRequestPhase ruleGroupRequestPhase) {
            this.ruleGroupRequestPhase(ruleGroupRequestPhase == null ? null : ruleGroupRequestPhase.toString());
            return this;
        }

        public final List<ProxyRulePriority.Builder> getRules() {
            List<ProxyRulePriority.Builder> result = ProxyRulePriorityListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<ProxyRulePriority.BuilderImpl> rules) {
            this.rules = ProxyRulePriorityListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<ProxyRulePriority> rules) {
            this.rules = ProxyRulePriorityListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ProxyRulePriority ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ProxyRulePriority.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (ProxyRulePriority)((ProxyRulePriority.Builder)ProxyRulePriority.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxyRulePrioritiesRequest build() {
            return new UpdateProxyRulePrioritiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProxyRulePrioritiesRequest> {
        public Builder proxyRuleGroupName(String var1);

        public Builder proxyRuleGroupArn(String var1);

        public Builder ruleGroupRequestPhase(String var1);

        public Builder ruleGroupRequestPhase(RuleGroupRequestPhase var1);

        public Builder rules(Collection<ProxyRulePriority> var1);

        public Builder rules(ProxyRulePriority ... var1);

        public Builder rules(Consumer<ProxyRulePriority.Builder> ... var1);

        public Builder updateToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

