/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ListenerPropertiesCopier;
import software.amazon.awssdk.services.networkfirewall.model.ListenerProperty;
import software.amazon.awssdk.services.networkfirewall.model.ProxyModifyState;
import software.amazon.awssdk.services.networkfirewall.model.ProxyState;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.services.networkfirewall.model.TlsInterceptProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProxyResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeProxyResource> {
    private static final SdkField<String> PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyName").getter(DescribeProxyResource.getter(DescribeProxyResource::proxyName)).setter(DescribeProxyResource.setter(Builder::proxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyName").build()}).build();
    private static final SdkField<String> PROXY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyArn").getter(DescribeProxyResource.getter(DescribeProxyResource::proxyArn)).setter(DescribeProxyResource.setter(Builder::proxyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyArn").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationName").getter(DescribeProxyResource.getter(DescribeProxyResource::proxyConfigurationName)).setter(DescribeProxyResource.setter(Builder::proxyConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationArn").getter(DescribeProxyResource.getter(DescribeProxyResource::proxyConfigurationArn)).setter(DescribeProxyResource.setter(Builder::proxyConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build()}).build();
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(DescribeProxyResource.getter(DescribeProxyResource::natGatewayId)).setter(DescribeProxyResource.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").build()}).build();
    private static final SdkField<String> PROXY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyState").getter(DescribeProxyResource.getter(DescribeProxyResource::proxyStateAsString)).setter(DescribeProxyResource.setter(Builder::proxyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyState").build()}).build();
    private static final SdkField<String> PROXY_MODIFY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyModifyState").getter(DescribeProxyResource.getter(DescribeProxyResource::proxyModifyStateAsString)).setter(DescribeProxyResource.setter(Builder::proxyModifyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyModifyState").build()}).build();
    private static final SdkField<List<ListenerProperty>> LISTENER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ListenerProperties").getter(DescribeProxyResource.getter(DescribeProxyResource::listenerProperties)).setter(DescribeProxyResource.setter(Builder::listenerProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListenerProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TlsInterceptProperties> TLS_INTERCEPT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TlsInterceptProperties").getter(DescribeProxyResource.getter(DescribeProxyResource::tlsInterceptProperties)).setter(DescribeProxyResource.setter(Builder::tlsInterceptProperties)).constructor(TlsInterceptProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsInterceptProperties").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointServiceName").getter(DescribeProxyResource.getter(DescribeProxyResource::vpcEndpointServiceName)).setter(DescribeProxyResource.setter(Builder::vpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointServiceName").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDNSName").getter(DescribeProxyResource.getter(DescribeProxyResource::privateDNSName)).setter(DescribeProxyResource.setter(Builder::privateDNSName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDNSName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DescribeProxyResource.getter(DescribeProxyResource::createTime)).setter(DescribeProxyResource.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> DELETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeleteTime").getter(DescribeProxyResource.getter(DescribeProxyResource::deleteTime)).setter(DescribeProxyResource.setter(Builder::deleteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(DescribeProxyResource.getter(DescribeProxyResource::updateTime)).setter(DescribeProxyResource.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(DescribeProxyResource.getter(DescribeProxyResource::failureCode)).setter(DescribeProxyResource.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(DescribeProxyResource.getter(DescribeProxyResource::failureMessage)).setter(DescribeProxyResource.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribeProxyResource.getter(DescribeProxyResource::tags)).setter(DescribeProxyResource.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_NAME_FIELD, PROXY_ARN_FIELD, PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, NAT_GATEWAY_ID_FIELD, PROXY_STATE_FIELD, PROXY_MODIFY_STATE_FIELD, LISTENER_PROPERTIES_FIELD, TLS_INTERCEPT_PROPERTIES_FIELD, VPC_ENDPOINT_SERVICE_NAME_FIELD, PRIVATE_DNS_NAME_FIELD, CREATE_TIME_FIELD, DELETE_TIME_FIELD, UPDATE_TIME_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeProxyResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String proxyName;
    private final String proxyArn;
    private final String proxyConfigurationName;
    private final String proxyConfigurationArn;
    private final String natGatewayId;
    private final String proxyState;
    private final String proxyModifyState;
    private final List<ListenerProperty> listenerProperties;
    private final TlsInterceptProperties tlsInterceptProperties;
    private final String vpcEndpointServiceName;
    private final String privateDNSName;
    private final Instant createTime;
    private final Instant deleteTime;
    private final Instant updateTime;
    private final String failureCode;
    private final String failureMessage;
    private final List<Tag> tags;

    private DescribeProxyResource(BuilderImpl builder) {
        this.proxyName = builder.proxyName;
        this.proxyArn = builder.proxyArn;
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.natGatewayId = builder.natGatewayId;
        this.proxyState = builder.proxyState;
        this.proxyModifyState = builder.proxyModifyState;
        this.listenerProperties = builder.listenerProperties;
        this.tlsInterceptProperties = builder.tlsInterceptProperties;
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.privateDNSName = builder.privateDNSName;
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.updateTime = builder.updateTime;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.tags = builder.tags;
    }

    public final String proxyName() {
        return this.proxyName;
    }

    public final String proxyArn() {
        return this.proxyArn;
    }

    public final String proxyConfigurationName() {
        return this.proxyConfigurationName;
    }

    public final String proxyConfigurationArn() {
        return this.proxyConfigurationArn;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final ProxyState proxyState() {
        return ProxyState.fromValue(this.proxyState);
    }

    public final String proxyStateAsString() {
        return this.proxyState;
    }

    public final ProxyModifyState proxyModifyState() {
        return ProxyModifyState.fromValue(this.proxyModifyState);
    }

    public final String proxyModifyStateAsString() {
        return this.proxyModifyState;
    }

    public final boolean hasListenerProperties() {
        return this.listenerProperties != null && !(this.listenerProperties instanceof SdkAutoConstructList);
    }

    public final List<ListenerProperty> listenerProperties() {
        return this.listenerProperties;
    }

    public final TlsInterceptProperties tlsInterceptProperties() {
        return this.tlsInterceptProperties;
    }

    public final String vpcEndpointServiceName() {
        return this.vpcEndpointServiceName;
    }

    public final String privateDNSName() {
        return this.privateDNSName;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant deleteTime() {
        return this.deleteTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyModifyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListenerProperties() ? this.listenerProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInterceptProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProxyResource)) {
            return false;
        }
        DescribeProxyResource other = (DescribeProxyResource)obj;
        return Objects.equals(this.proxyName(), other.proxyName()) && Objects.equals(this.proxyArn(), other.proxyArn()) && Objects.equals(this.proxyConfigurationName(), other.proxyConfigurationName()) && Objects.equals(this.proxyConfigurationArn(), other.proxyConfigurationArn()) && Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.proxyStateAsString(), other.proxyStateAsString()) && Objects.equals(this.proxyModifyStateAsString(), other.proxyModifyStateAsString()) && this.hasListenerProperties() == other.hasListenerProperties() && Objects.equals(this.listenerProperties(), other.listenerProperties()) && Objects.equals(this.tlsInterceptProperties(), other.tlsInterceptProperties()) && Objects.equals(this.vpcEndpointServiceName(), other.vpcEndpointServiceName()) && Objects.equals(this.privateDNSName(), other.privateDNSName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.deleteTime(), other.deleteTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureMessage(), other.failureMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProxyResource").add("ProxyName", (Object)this.proxyName()).add("ProxyArn", (Object)this.proxyArn()).add("ProxyConfigurationName", (Object)this.proxyConfigurationName()).add("ProxyConfigurationArn", (Object)this.proxyConfigurationArn()).add("NatGatewayId", (Object)this.natGatewayId()).add("ProxyState", (Object)this.proxyStateAsString()).add("ProxyModifyState", (Object)this.proxyModifyStateAsString()).add("ListenerProperties", this.hasListenerProperties() ? this.listenerProperties() : null).add("TlsInterceptProperties", (Object)this.tlsInterceptProperties()).add("VpcEndpointServiceName", (Object)this.vpcEndpointServiceName()).add("PrivateDNSName", (Object)this.privateDNSName()).add("CreateTime", (Object)this.createTime()).add("DeleteTime", (Object)this.deleteTime()).add("UpdateTime", (Object)this.updateTime()).add("FailureCode", (Object)this.failureCode()).add("FailureMessage", (Object)this.failureMessage()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyName": {
                return Optional.ofNullable(clazz.cast(this.proxyName()));
            }
            case "ProxyArn": {
                return Optional.ofNullable(clazz.cast(this.proxyArn()));
            }
            case "ProxyConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationName()));
            }
            case "ProxyConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationArn()));
            }
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "ProxyState": {
                return Optional.ofNullable(clazz.cast(this.proxyStateAsString()));
            }
            case "ProxyModifyState": {
                return Optional.ofNullable(clazz.cast(this.proxyModifyStateAsString()));
            }
            case "ListenerProperties": {
                return Optional.ofNullable(clazz.cast(this.listenerProperties()));
            }
            case "TlsInterceptProperties": {
                return Optional.ofNullable(clazz.cast(this.tlsInterceptProperties()));
            }
            case "VpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointServiceName()));
            }
            case "PrivateDNSName": {
                return Optional.ofNullable(clazz.cast(this.privateDNSName()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DeleteTime": {
                return Optional.ofNullable(clazz.cast(this.deleteTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyName", PROXY_NAME_FIELD);
        map.put("ProxyArn", PROXY_ARN_FIELD);
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("ProxyState", PROXY_STATE_FIELD);
        map.put("ProxyModifyState", PROXY_MODIFY_STATE_FIELD);
        map.put("ListenerProperties", LISTENER_PROPERTIES_FIELD);
        map.put("TlsInterceptProperties", TLS_INTERCEPT_PROPERTIES_FIELD);
        map.put("VpcEndpointServiceName", VPC_ENDPOINT_SERVICE_NAME_FIELD);
        map.put("PrivateDNSName", PRIVATE_DNS_NAME_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("DeleteTime", DELETE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProxyResource, T> g) {
        return obj -> g.apply((DescribeProxyResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String proxyName;
        private String proxyArn;
        private String proxyConfigurationName;
        private String proxyConfigurationArn;
        private String natGatewayId;
        private String proxyState;
        private String proxyModifyState;
        private List<ListenerProperty> listenerProperties = DefaultSdkAutoConstructList.getInstance();
        private TlsInterceptProperties tlsInterceptProperties;
        private String vpcEndpointServiceName;
        private String privateDNSName;
        private Instant createTime;
        private Instant deleteTime;
        private Instant updateTime;
        private String failureCode;
        private String failureMessage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProxyResource model) {
            this.proxyName(model.proxyName);
            this.proxyArn(model.proxyArn);
            this.proxyConfigurationName(model.proxyConfigurationName);
            this.proxyConfigurationArn(model.proxyConfigurationArn);
            this.natGatewayId(model.natGatewayId);
            this.proxyState(model.proxyState);
            this.proxyModifyState(model.proxyModifyState);
            this.listenerProperties(model.listenerProperties);
            this.tlsInterceptProperties(model.tlsInterceptProperties);
            this.vpcEndpointServiceName(model.vpcEndpointServiceName);
            this.privateDNSName(model.privateDNSName);
            this.createTime(model.createTime);
            this.deleteTime(model.deleteTime);
            this.updateTime(model.updateTime);
            this.failureCode(model.failureCode);
            this.failureMessage(model.failureMessage);
            this.tags(model.tags);
        }

        public final String getProxyName() {
            return this.proxyName;
        }

        public final void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        @Override
        public final Builder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        public final String getProxyArn() {
            return this.proxyArn;
        }

        public final void setProxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
        }

        @Override
        public final Builder proxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
            return this;
        }

        public final String getProxyConfigurationName() {
            return this.proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return this.proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getProxyState() {
            return this.proxyState;
        }

        public final void setProxyState(String proxyState) {
            this.proxyState = proxyState;
        }

        @Override
        public final Builder proxyState(String proxyState) {
            this.proxyState = proxyState;
            return this;
        }

        @Override
        public final Builder proxyState(ProxyState proxyState) {
            this.proxyState(proxyState == null ? null : proxyState.toString());
            return this;
        }

        public final String getProxyModifyState() {
            return this.proxyModifyState;
        }

        public final void setProxyModifyState(String proxyModifyState) {
            this.proxyModifyState = proxyModifyState;
        }

        @Override
        public final Builder proxyModifyState(String proxyModifyState) {
            this.proxyModifyState = proxyModifyState;
            return this;
        }

        @Override
        public final Builder proxyModifyState(ProxyModifyState proxyModifyState) {
            this.proxyModifyState(proxyModifyState == null ? null : proxyModifyState.toString());
            return this;
        }

        public final List<ListenerProperty.Builder> getListenerProperties() {
            List<ListenerProperty.Builder> result = ListenerPropertiesCopier.copyToBuilder(this.listenerProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerProperties(Collection<ListenerProperty.BuilderImpl> listenerProperties) {
            this.listenerProperties = ListenerPropertiesCopier.copyFromBuilder(listenerProperties);
        }

        @Override
        public final Builder listenerProperties(Collection<ListenerProperty> listenerProperties) {
            this.listenerProperties = ListenerPropertiesCopier.copy(listenerProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerProperties(ListenerProperty ... listenerProperties) {
            this.listenerProperties(Arrays.asList(listenerProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerProperties(Consumer<ListenerProperty.Builder> ... listenerProperties) {
            this.listenerProperties(Stream.of(listenerProperties).map(c -> (ListenerProperty)((ListenerProperty.Builder)ListenerProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TlsInterceptProperties.Builder getTlsInterceptProperties() {
            return this.tlsInterceptProperties != null ? this.tlsInterceptProperties.toBuilder() : null;
        }

        public final void setTlsInterceptProperties(TlsInterceptProperties.BuilderImpl tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties != null ? tlsInterceptProperties.build() : null;
        }

        @Override
        public final Builder tlsInterceptProperties(TlsInterceptProperties tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties;
            return this;
        }

        public final String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final String getPrivateDNSName() {
            return this.privateDNSName;
        }

        public final void setPrivateDNSName(String privateDNSName) {
            this.privateDNSName = privateDNSName;
        }

        @Override
        public final Builder privateDNSName(String privateDNSName) {
            this.privateDNSName = privateDNSName;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getDeleteTime() {
            return this.deleteTime;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DescribeProxyResource build() {
            return new DescribeProxyResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeProxyResource> {
        public Builder proxyName(String var1);

        public Builder proxyArn(String var1);

        public Builder proxyConfigurationName(String var1);

        public Builder proxyConfigurationArn(String var1);

        public Builder natGatewayId(String var1);

        public Builder proxyState(String var1);

        public Builder proxyState(ProxyState var1);

        public Builder proxyModifyState(String var1);

        public Builder proxyModifyState(ProxyModifyState var1);

        public Builder listenerProperties(Collection<ListenerProperty> var1);

        public Builder listenerProperties(ListenerProperty ... var1);

        public Builder listenerProperties(Consumer<ListenerProperty.Builder> ... var1);

        public Builder tlsInterceptProperties(TlsInterceptProperties var1);

        default public Builder tlsInterceptProperties(Consumer<TlsInterceptProperties.Builder> tlsInterceptProperties) {
            return this.tlsInterceptProperties((TlsInterceptProperties)((TlsInterceptProperties.Builder)TlsInterceptProperties.builder().applyMutation(tlsInterceptProperties)).build());
        }

        public Builder vpcEndpointServiceName(String var1);

        public Builder privateDNSName(String var1);

        public Builder createTime(Instant var1);

        public Builder deleteTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

