/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupAttachment;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachRuleGroupsToProxyConfigurationRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, AttachRuleGroupsToProxyConfigurationRequest> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationName").getter(AttachRuleGroupsToProxyConfigurationRequest.getter(AttachRuleGroupsToProxyConfigurationRequest::proxyConfigurationName)).setter(AttachRuleGroupsToProxyConfigurationRequest.setter(Builder::proxyConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationArn").getter(AttachRuleGroupsToProxyConfigurationRequest.getter(AttachRuleGroupsToProxyConfigurationRequest::proxyConfigurationArn)).setter(AttachRuleGroupsToProxyConfigurationRequest.setter(Builder::proxyConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build()}).build();
    private static final SdkField<List<ProxyRuleGroupAttachment>> RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroups").getter(AttachRuleGroupsToProxyConfigurationRequest.getter(AttachRuleGroupsToProxyConfigurationRequest::ruleGroups)).setter(AttachRuleGroupsToProxyConfigurationRequest.setter(Builder::ruleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRuleGroupAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(AttachRuleGroupsToProxyConfigurationRequest.getter(AttachRuleGroupsToProxyConfigurationRequest::updateToken)).setter(AttachRuleGroupsToProxyConfigurationRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, RULE_GROUPS_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttachRuleGroupsToProxyConfigurationRequest.memberNameToFieldInitializer();
    private final String proxyConfigurationName;
    private final String proxyConfigurationArn;
    private final List<ProxyRuleGroupAttachment> ruleGroups;
    private final String updateToken;

    private AttachRuleGroupsToProxyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.ruleGroups = builder.ruleGroups;
        this.updateToken = builder.updateToken;
    }

    public final String proxyConfigurationName() {
        return this.proxyConfigurationName;
    }

    public final String proxyConfigurationArn() {
        return this.proxyConfigurationArn;
    }

    public final boolean hasRuleGroups() {
        return this.ruleGroups != null && !(this.ruleGroups instanceof SdkAutoConstructList);
    }

    public final List<ProxyRuleGroupAttachment> ruleGroups() {
        return this.ruleGroups;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroups() ? this.ruleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachRuleGroupsToProxyConfigurationRequest)) {
            return false;
        }
        AttachRuleGroupsToProxyConfigurationRequest other = (AttachRuleGroupsToProxyConfigurationRequest)((Object)obj);
        return Objects.equals(this.proxyConfigurationName(), other.proxyConfigurationName()) && Objects.equals(this.proxyConfigurationArn(), other.proxyConfigurationArn()) && this.hasRuleGroups() == other.hasRuleGroups() && Objects.equals(this.ruleGroups(), other.ruleGroups()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"AttachRuleGroupsToProxyConfigurationRequest").add("ProxyConfigurationName", (Object)this.proxyConfigurationName()).add("ProxyConfigurationArn", (Object)this.proxyConfigurationArn()).add("RuleGroups", this.hasRuleGroups() ? this.ruleGroups() : null).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationName()));
            }
            case "ProxyConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationArn()));
            }
            case "RuleGroups": {
                return Optional.ofNullable(clazz.cast(this.ruleGroups()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("RuleGroups", RULE_GROUPS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachRuleGroupsToProxyConfigurationRequest, T> g) {
        return obj -> g.apply((AttachRuleGroupsToProxyConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyConfigurationName;
        private String proxyConfigurationArn;
        private List<ProxyRuleGroupAttachment> ruleGroups = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachRuleGroupsToProxyConfigurationRequest model) {
            super(model);
            this.proxyConfigurationName(model.proxyConfigurationName);
            this.proxyConfigurationArn(model.proxyConfigurationArn);
            this.ruleGroups(model.ruleGroups);
            this.updateToken(model.updateToken);
        }

        public final String getProxyConfigurationName() {
            return this.proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return this.proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final List<ProxyRuleGroupAttachment.Builder> getRuleGroups() {
            List<ProxyRuleGroupAttachment.Builder> result = ProxyRuleGroupAttachmentListCopier.copyToBuilder(this.ruleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroups(Collection<ProxyRuleGroupAttachment.BuilderImpl> ruleGroups) {
            this.ruleGroups = ProxyRuleGroupAttachmentListCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public final Builder ruleGroups(Collection<ProxyRuleGroupAttachment> ruleGroups) {
            this.ruleGroups = ProxyRuleGroupAttachmentListCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(ProxyRuleGroupAttachment ... ruleGroups) {
            this.ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<ProxyRuleGroupAttachment.Builder> ... ruleGroups) {
            this.ruleGroups(Stream.of(ruleGroups).map(c -> (ProxyRuleGroupAttachment)((ProxyRuleGroupAttachment.Builder)ProxyRuleGroupAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachRuleGroupsToProxyConfigurationRequest build() {
            return new AttachRuleGroupsToProxyConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachRuleGroupsToProxyConfigurationRequest> {
        public Builder proxyConfigurationName(String var1);

        public Builder proxyConfigurationArn(String var1);

        public Builder ruleGroups(Collection<ProxyRuleGroupAttachment> var1);

        public Builder ruleGroups(ProxyRuleGroupAttachment ... var1);

        public Builder ruleGroups(Consumer<ProxyRuleGroupAttachment.Builder> ... var1);

        public Builder updateToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

