/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.IPSetMetadata;
import software.amazon.awssdk.services.networkfirewall.model.IPSetMetadataMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CIDRSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CIDRSummary> {
    private static final SdkField<Integer> AVAILABLE_CIDR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableCIDRCount").getter(CIDRSummary.getter(CIDRSummary::availableCIDRCount)).setter(CIDRSummary.setter(Builder::availableCIDRCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableCIDRCount").build()}).build();
    private static final SdkField<Integer> UTILIZED_CIDR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UtilizedCIDRCount").getter(CIDRSummary.getter(CIDRSummary::utilizedCIDRCount)).setter(CIDRSummary.setter(Builder::utilizedCIDRCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizedCIDRCount").build()}).build();
    private static final SdkField<Map<String, IPSetMetadata>> IP_SET_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("IPSetReferences").getter(CIDRSummary.getter(CIDRSummary::ipSetReferences)).setter(CIDRSummary.setter(Builder::ipSetReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetReferences").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IPSetMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_CIDR_COUNT_FIELD, UTILIZED_CIDR_COUNT_FIELD, IP_SET_REFERENCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer availableCIDRCount;
    private final Integer utilizedCIDRCount;
    private final Map<String, IPSetMetadata> ipSetReferences;

    private CIDRSummary(BuilderImpl builder) {
        this.availableCIDRCount = builder.availableCIDRCount;
        this.utilizedCIDRCount = builder.utilizedCIDRCount;
        this.ipSetReferences = builder.ipSetReferences;
    }

    public final Integer availableCIDRCount() {
        return this.availableCIDRCount;
    }

    public final Integer utilizedCIDRCount() {
        return this.utilizedCIDRCount;
    }

    public final boolean hasIpSetReferences() {
        return this.ipSetReferences != null && !(this.ipSetReferences instanceof SdkAutoConstructMap);
    }

    public final Map<String, IPSetMetadata> ipSetReferences() {
        return this.ipSetReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availableCIDRCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizedCIDRCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpSetReferences() ? this.ipSetReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CIDRSummary)) {
            return false;
        }
        CIDRSummary other = (CIDRSummary)obj;
        return Objects.equals(this.availableCIDRCount(), other.availableCIDRCount()) && Objects.equals(this.utilizedCIDRCount(), other.utilizedCIDRCount()) && this.hasIpSetReferences() == other.hasIpSetReferences() && Objects.equals(this.ipSetReferences(), other.ipSetReferences());
    }

    public final String toString() {
        return ToString.builder((String)"CIDRSummary").add("AvailableCIDRCount", (Object)this.availableCIDRCount()).add("UtilizedCIDRCount", (Object)this.utilizedCIDRCount()).add("IPSetReferences", this.hasIpSetReferences() ? this.ipSetReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailableCIDRCount": {
                return Optional.ofNullable(clazz.cast(this.availableCIDRCount()));
            }
            case "UtilizedCIDRCount": {
                return Optional.ofNullable(clazz.cast(this.utilizedCIDRCount()));
            }
            case "IPSetReferences": {
                return Optional.ofNullable(clazz.cast(this.ipSetReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CIDRSummary, T> g) {
        return obj -> g.apply((CIDRSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer availableCIDRCount;
        private Integer utilizedCIDRCount;
        private Map<String, IPSetMetadata> ipSetReferences = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CIDRSummary model) {
            this.availableCIDRCount(model.availableCIDRCount);
            this.utilizedCIDRCount(model.utilizedCIDRCount);
            this.ipSetReferences(model.ipSetReferences);
        }

        public final Integer getAvailableCIDRCount() {
            return this.availableCIDRCount;
        }

        public final void setAvailableCIDRCount(Integer availableCIDRCount) {
            this.availableCIDRCount = availableCIDRCount;
        }

        @Override
        public final Builder availableCIDRCount(Integer availableCIDRCount) {
            this.availableCIDRCount = availableCIDRCount;
            return this;
        }

        public final Integer getUtilizedCIDRCount() {
            return this.utilizedCIDRCount;
        }

        public final void setUtilizedCIDRCount(Integer utilizedCIDRCount) {
            this.utilizedCIDRCount = utilizedCIDRCount;
        }

        @Override
        public final Builder utilizedCIDRCount(Integer utilizedCIDRCount) {
            this.utilizedCIDRCount = utilizedCIDRCount;
            return this;
        }

        public final Map<String, IPSetMetadata.Builder> getIpSetReferences() {
            Map<String, IPSetMetadata.Builder> result = IPSetMetadataMapCopier.copyToBuilder(this.ipSetReferences);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setIpSetReferences(Map<String, IPSetMetadata.BuilderImpl> ipSetReferences) {
            this.ipSetReferences = IPSetMetadataMapCopier.copyFromBuilder(ipSetReferences);
        }

        @Override
        public final Builder ipSetReferences(Map<String, IPSetMetadata> ipSetReferences) {
            this.ipSetReferences = IPSetMetadataMapCopier.copy(ipSetReferences);
            return this;
        }

        public CIDRSummary build() {
            return new CIDRSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CIDRSummary> {
        public Builder availableCIDRCount(Integer var1);

        public Builder utilizedCIDRCount(Integer var1);

        public Builder ipSetReferences(Map<String, IPSetMetadata> var1);
    }
}

