/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSubnetChangeProtectionResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<UpdateSubnetChangeProtectionResponse.Builder, UpdateSubnetChangeProtectionResponse> {
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateSubnetChangeProtectionResponse::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(UpdateSubnetChangeProtectionResponse::firewallArn))
            .setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallName").getter(getter(UpdateSubnetChangeProtectionResponse::firewallName))
            .setter(setter(Builder::firewallName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()).build();

    private static final SdkField<Boolean> SUBNET_CHANGE_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SubnetChangeProtection").getter(getter(UpdateSubnetChangeProtectionResponse::subnetChangeProtection))
            .setter(setter(Builder::subnetChangeProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetChangeProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TOKEN_FIELD,
            FIREWALL_ARN_FIELD, FIREWALL_NAME_FIELD, SUBNET_CHANGE_PROTECTION_FIELD));

    private final String updateToken;

    private final String firewallArn;

    private final String firewallName;

    private final Boolean subnetChangeProtection;

    private UpdateSubnetChangeProtectionResponse(BuilderImpl builder) {
        super(builder);
        this.updateToken = builder.updateToken;
        this.firewallArn = builder.firewallArn;
        this.firewallName = builder.firewallName;
        this.subnetChangeProtection = builder.subnetChangeProtection;
    }

    /**
     * <p>
     * An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that
     * access the firewall. The token marks the state of the firewall resource at the time of the request.
     * </p>
     * <p>
     * To make an unconditional change to the firewall, omit the token in your update request. Without the token,
     * Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved
     * it.
     * </p>
     * <p>
     * To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the
     * token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation
     * fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current
     * copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return An optional token that you can use for optimistic locking. Network Firewall returns a token to your
     *         requests that access the firewall. The token marks the state of the firewall resource at the time of the
     *         request. </p>
     *         <p>
     *         To make an unconditional change to the firewall, omit the token in your update request. Without the
     *         token, Network Firewall performs your updates regardless of whether the firewall has changed since you
     *         last retrieved it.
     *         </p>
     *         <p>
     *         To make a conditional change to the firewall, provide the token in your update request. Network Firewall
     *         uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed,
     *         the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall
     *         again to get a current copy of it with a new token. Reapply your changes as needed, then try the
     *         operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     * </p>
     * 
     * @return The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     */
    public final String firewallName() {
        return firewallName;
    }

    /**
     * <p>
     * A setting indicating whether the firewall is protected against changes to the subnet associations. Use this
     * setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you
     * create a firewall, the operation initializes this setting to <code>TRUE</code>.
     * </p>
     * 
     * @return A setting indicating whether the firewall is protected against changes to the subnet associations. Use
     *         this setting to protect against accidentally modifying the subnet associations for a firewall that is in
     *         use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.
     */
    public final Boolean subnetChangeProtection() {
        return subnetChangeProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(subnetChangeProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubnetChangeProtectionResponse)) {
            return false;
        }
        UpdateSubnetChangeProtectionResponse other = (UpdateSubnetChangeProtectionResponse) obj;
        return Objects.equals(updateToken(), other.updateToken()) && Objects.equals(firewallArn(), other.firewallArn())
                && Objects.equals(firewallName(), other.firewallName())
                && Objects.equals(subnetChangeProtection(), other.subnetChangeProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSubnetChangeProtectionResponse").add("UpdateToken", updateToken())
                .add("FirewallArn", firewallArn()).add("FirewallName", firewallName())
                .add("SubnetChangeProtection", subnetChangeProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "FirewallName":
            return Optional.ofNullable(clazz.cast(firewallName()));
        case "SubnetChangeProtection":
            return Optional.ofNullable(clazz.cast(subnetChangeProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubnetChangeProtectionResponse, T> g) {
        return obj -> g.apply((UpdateSubnetChangeProtectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSubnetChangeProtectionResponse> {
        /**
         * <p>
         * An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests
         * that access the firewall. The token marks the state of the firewall resource at the time of the request.
         * </p>
         * <p>
         * To make an unconditional change to the firewall, omit the token in your update request. Without the token,
         * Network Firewall performs your updates regardless of whether the firewall has changed since you last
         * retrieved it.
         * </p>
         * <p>
         * To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses
         * the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the
         * operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to
         * get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using
         * the new token.
         * </p>
         * 
         * @param updateToken
         *        An optional token that you can use for optimistic locking. Network Firewall returns a token to your
         *        requests that access the firewall. The token marks the state of the firewall resource at the time of
         *        the request. </p>
         *        <p>
         *        To make an unconditional change to the firewall, omit the token in your update request. Without the
         *        token, Network Firewall performs your updates regardless of whether the firewall has changed since you
         *        last retrieved it.
         *        </p>
         *        <p>
         *        To make a conditional change to the firewall, provide the token in your update request. Network
         *        Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it
         *        has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve
         *        the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then
         *        try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         * </p>
         * 
         * @param firewallName
         *        The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallName(String firewallName);

        /**
         * <p>
         * A setting indicating whether the firewall is protected against changes to the subnet associations. Use this
         * setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When
         * you create a firewall, the operation initializes this setting to <code>TRUE</code>.
         * </p>
         * 
         * @param subnetChangeProtection
         *        A setting indicating whether the firewall is protected against changes to the subnet associations. Use
         *        this setting to protect against accidentally modifying the subnet associations for a firewall that is
         *        in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetChangeProtection(Boolean subnetChangeProtection);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String updateToken;

        private String firewallArn;

        private String firewallName;

        private Boolean subnetChangeProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubnetChangeProtectionResponse model) {
            super(model);
            updateToken(model.updateToken);
            firewallArn(model.firewallArn);
            firewallName(model.firewallName);
            subnetChangeProtection(model.subnetChangeProtection);
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        public final String getFirewallName() {
            return firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        public final Boolean getSubnetChangeProtection() {
            return subnetChangeProtection;
        }

        @Override
        public final Builder subnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        public final void setSubnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
        }

        @Override
        public UpdateSubnetChangeProtectionResponse build() {
            return new UpdateSubnetChangeProtectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
