/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stateless inspection criteria. Each stateless rule group uses exactly one of these data types to define its stateless
 * rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatelessRulesAndCustomActions implements SdkPojo, Serializable,
        ToCopyableBuilder<StatelessRulesAndCustomActions.Builder, StatelessRulesAndCustomActions> {
    private static final SdkField<List<StatelessRule>> STATELESS_RULES_FIELD = SdkField
            .<List<StatelessRule>> builder(MarshallingType.LIST)
            .memberName("StatelessRules")
            .getter(getter(StatelessRulesAndCustomActions::statelessRules))
            .setter(setter(Builder::statelessRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatelessRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatelessRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CustomAction>> CUSTOM_ACTIONS_FIELD = SdkField
            .<List<CustomAction>> builder(MarshallingType.LIST)
            .memberName("CustomActions")
            .getter(getter(StatelessRulesAndCustomActions::customActions))
            .setter(setter(Builder::customActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATELESS_RULES_FIELD,
            CUSTOM_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StatelessRule> statelessRules;

    private final List<CustomAction> customActions;

    private StatelessRulesAndCustomActions(BuilderImpl builder) {
        this.statelessRules = builder.statelessRules;
        this.customActions = builder.customActions;
    }

    /**
     * Returns true if the StatelessRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStatelessRules() {
        return statelessRules != null && !(statelessRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the set of stateless rules for use in a stateless rule group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatelessRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Defines the set of stateless rules for use in a stateless rule group.
     */
    public final List<StatelessRule> statelessRules() {
        return statelessRules;
    }

    /**
     * Returns true if the CustomActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCustomActions() {
        return customActions != null && !(customActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines an array of individual custom action definitions that are available for use by the stateless rules in
     * this <code>StatelessRulesAndCustomActions</code> specification. You name each custom action that you define, and
     * then you can use it by name in your <a>StatelessRule</a> <a>RuleDefinition</a> <code>Actions</code>
     * specification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Defines an array of individual custom action definitions that are available for use by the stateless
     *         rules in this <code>StatelessRulesAndCustomActions</code> specification. You name each custom action that
     *         you define, and then you can use it by name in your <a>StatelessRule</a> <a>RuleDefinition</a>
     *         <code>Actions</code> specification.
     */
    public final List<CustomAction> customActions() {
        return customActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessRules() ? statelessRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomActions() ? customActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatelessRulesAndCustomActions)) {
            return false;
        }
        StatelessRulesAndCustomActions other = (StatelessRulesAndCustomActions) obj;
        return hasStatelessRules() == other.hasStatelessRules() && Objects.equals(statelessRules(), other.statelessRules())
                && hasCustomActions() == other.hasCustomActions() && Objects.equals(customActions(), other.customActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatelessRulesAndCustomActions")
                .add("StatelessRules", hasStatelessRules() ? statelessRules() : null)
                .add("CustomActions", hasCustomActions() ? customActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatelessRules":
            return Optional.ofNullable(clazz.cast(statelessRules()));
        case "CustomActions":
            return Optional.ofNullable(clazz.cast(customActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatelessRulesAndCustomActions, T> g) {
        return obj -> g.apply((StatelessRulesAndCustomActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatelessRulesAndCustomActions> {
        /**
         * <p>
         * Defines the set of stateless rules for use in a stateless rule group.
         * </p>
         * 
         * @param statelessRules
         *        Defines the set of stateless rules for use in a stateless rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRules(Collection<StatelessRule> statelessRules);

        /**
         * <p>
         * Defines the set of stateless rules for use in a stateless rule group.
         * </p>
         * 
         * @param statelessRules
         *        Defines the set of stateless rules for use in a stateless rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRules(StatelessRule... statelessRules);

        /**
         * <p>
         * Defines the set of stateless rules for use in a stateless rule group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StatelessRule>.Builder} avoiding the need
         * to create one manually via {@link List<StatelessRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatelessRule>.Builder#build()} is called immediately and
         * its result is passed to {@link #statelessRules(List<StatelessRule>)}.
         * 
         * @param statelessRules
         *        a consumer that will call methods on {@link List<StatelessRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessRules(List<StatelessRule>)
         */
        Builder statelessRules(Consumer<StatelessRule.Builder>... statelessRules);

        /**
         * <p>
         * Defines an array of individual custom action definitions that are available for use by the stateless rules in
         * this <code>StatelessRulesAndCustomActions</code> specification. You name each custom action that you define,
         * and then you can use it by name in your <a>StatelessRule</a> <a>RuleDefinition</a> <code>Actions</code>
         * specification.
         * </p>
         * 
         * @param customActions
         *        Defines an array of individual custom action definitions that are available for use by the stateless
         *        rules in this <code>StatelessRulesAndCustomActions</code> specification. You name each custom action
         *        that you define, and then you can use it by name in your <a>StatelessRule</a> <a>RuleDefinition</a>
         *        <code>Actions</code> specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActions(Collection<CustomAction> customActions);

        /**
         * <p>
         * Defines an array of individual custom action definitions that are available for use by the stateless rules in
         * this <code>StatelessRulesAndCustomActions</code> specification. You name each custom action that you define,
         * and then you can use it by name in your <a>StatelessRule</a> <a>RuleDefinition</a> <code>Actions</code>
         * specification.
         * </p>
         * 
         * @param customActions
         *        Defines an array of individual custom action definitions that are available for use by the stateless
         *        rules in this <code>StatelessRulesAndCustomActions</code> specification. You name each custom action
         *        that you define, and then you can use it by name in your <a>StatelessRule</a> <a>RuleDefinition</a>
         *        <code>Actions</code> specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActions(CustomAction... customActions);

        /**
         * <p>
         * Defines an array of individual custom action definitions that are available for use by the stateless rules in
         * this <code>StatelessRulesAndCustomActions</code> specification. You name each custom action that you define,
         * and then you can use it by name in your <a>StatelessRule</a> <a>RuleDefinition</a> <code>Actions</code>
         * specification.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomAction>.Builder} avoiding the need to
         * create one manually via {@link List<CustomAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomAction>.Builder#build()} is called immediately and its
         * result is passed to {@link #customActions(List<CustomAction>)}.
         * 
         * @param customActions
         *        a consumer that will call methods on {@link List<CustomAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customActions(List<CustomAction>)
         */
        Builder customActions(Consumer<CustomAction.Builder>... customActions);
    }

    static final class BuilderImpl implements Builder {
        private List<StatelessRule> statelessRules = DefaultSdkAutoConstructList.getInstance();

        private List<CustomAction> customActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatelessRulesAndCustomActions model) {
            statelessRules(model.statelessRules);
            customActions(model.customActions);
        }

        public final Collection<StatelessRule.Builder> getStatelessRules() {
            if (statelessRules instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessRules != null ? statelessRules.stream().map(StatelessRule::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder statelessRules(Collection<StatelessRule> statelessRules) {
            this.statelessRules = StatelessRulesCopier.copy(statelessRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRules(StatelessRule... statelessRules) {
            statelessRules(Arrays.asList(statelessRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRules(Consumer<StatelessRule.Builder>... statelessRules) {
            statelessRules(Stream.of(statelessRules).map(c -> StatelessRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatelessRules(Collection<StatelessRule.BuilderImpl> statelessRules) {
            this.statelessRules = StatelessRulesCopier.copyFromBuilder(statelessRules);
        }

        public final Collection<CustomAction.Builder> getCustomActions() {
            if (customActions instanceof SdkAutoConstructList) {
                return null;
            }
            return customActions != null ? customActions.stream().map(CustomAction::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder customActions(Collection<CustomAction> customActions) {
            this.customActions = CustomActionsCopier.copy(customActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customActions(CustomAction... customActions) {
            customActions(Arrays.asList(customActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customActions(Consumer<CustomAction.Builder>... customActions) {
            customActions(Stream.of(customActions).map(c -> CustomAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCustomActions(Collection<CustomAction.BuilderImpl> customActions) {
            this.customActions = CustomActionsCopier.copyFromBuilder(customActions);
        }

        @Override
        public StatelessRulesAndCustomActions build() {
            return new StatelessRulesAndCustomActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
