/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can
 * retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupResponse.Builder, RuleGroupResponse> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupArn").getter(getter(RuleGroupResponse::ruleGroupArn)).setter(setter(Builder::ruleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()).build();

    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupName").getter(getter(RuleGroupResponse::ruleGroupName)).setter(setter(Builder::ruleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()).build();

    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupId").getter(getter(RuleGroupResponse::ruleGroupId)).setter(setter(Builder::ruleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RuleGroupResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RuleGroupResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Capacity").getter(getter(RuleGroupResponse::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<String> RULE_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupStatus").getter(getter(RuleGroupResponse::ruleGroupStatusAsString))
            .setter(setter(Builder::ruleGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupStatus").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RuleGroupResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD,
            RULE_GROUP_NAME_FIELD, RULE_GROUP_ID_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, CAPACITY_FIELD, RULE_GROUP_STATUS_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleGroupArn;

    private final String ruleGroupName;

    private final String ruleGroupId;

    private final String description;

    private final String type;

    private final Integer capacity;

    private final String ruleGroupStatus;

    private final List<Tag> tags;

    private RuleGroupResponse(BuilderImpl builder) {
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleGroupName = builder.ruleGroupName;
        this.ruleGroupId = builder.ruleGroupId;
        this.description = builder.description;
        this.type = builder.type;
        this.capacity = builder.capacity;
        this.ruleGroupStatus = builder.ruleGroupStatus;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule group.
     * </p>
     * <note>
     * <p>
     * If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then this ARN is
     * a placeholder that isn't attached to a valid resource.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the rule group.</p> <note>
     *         <p>
     *         If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then this
     *         ARN is a placeholder that isn't attached to a valid resource.
     *         </p>
     */
    public final String ruleGroupArn() {
        return ruleGroupArn;
    }

    /**
     * <p>
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     * </p>
     * 
     * @return The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     */
    public final String ruleGroupName() {
        return ruleGroupName;
    }

    /**
     * <p>
     * The unique identifier for the rule group.
     * </p>
     * 
     * @return The unique identifier for the rule group.
     */
    public final String ruleGroupId() {
        return ruleGroupId;
    }

    /**
     * <p>
     * A description of the rule group.
     * </p>
     * 
     * @return A description of the rule group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless
     * rules. If it is stateful, it contains stateful rules.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
     *         stateless rules. If it is stateful, it contains stateful rules.
     * @see RuleGroupType
     */
    public final RuleGroupType type() {
        return RuleGroupType.fromValue(type);
    }

    /**
     * <p>
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless
     * rules. If it is stateful, it contains stateful rules.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
     *         stateless rules. If it is stateful, it contains stateful rules.
     * @see RuleGroupType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you
     * update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy,
     * Network Firewall reserves this capacity for the rule group.
     * </p>
     * <p>
     * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling
     * <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
     * </p>
     * 
     * @return The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation.
     *         When you update a rule group, you are limited to this capacity. When you reference a rule group from a
     *         firewall policy, Network Firewall reserves this capacity for the rule group. </p>
     *         <p>
     *         You can retrieve the capacity that would be required for a rule group before you create the rule group by
     *         calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
     */
    public final Integer capacity() {
        return capacity;
    }

    /**
     * <p>
     * Detailed information about the current status of a rule group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleGroupStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleGroupStatusAsString}.
     * </p>
     * 
     * @return Detailed information about the current status of a rule group.
     * @see ResourceStatus
     */
    public final ResourceStatus ruleGroupStatus() {
        return ResourceStatus.fromValue(ruleGroupStatus);
    }

    /**
     * <p>
     * Detailed information about the current status of a rule group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleGroupStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleGroupStatusAsString}.
     * </p>
     * 
     * @return Detailed information about the current status of a rule group.
     * @see ResourceStatus
     */
    public final String ruleGroupStatusAsString() {
        return ruleGroupStatus;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupResponse)) {
            return false;
        }
        RuleGroupResponse other = (RuleGroupResponse) obj;
        return Objects.equals(ruleGroupArn(), other.ruleGroupArn()) && Objects.equals(ruleGroupName(), other.ruleGroupName())
                && Objects.equals(ruleGroupId(), other.ruleGroupId()) && Objects.equals(description(), other.description())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(capacity(), other.capacity())
                && Objects.equals(ruleGroupStatusAsString(), other.ruleGroupStatusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupResponse").add("RuleGroupArn", ruleGroupArn()).add("RuleGroupName", ruleGroupName())
                .add("RuleGroupId", ruleGroupId()).add("Description", description()).add("Type", typeAsString())
                .add("Capacity", capacity()).add("RuleGroupStatus", ruleGroupStatusAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupArn":
            return Optional.ofNullable(clazz.cast(ruleGroupArn()));
        case "RuleGroupName":
            return Optional.ofNullable(clazz.cast(ruleGroupName()));
        case "RuleGroupId":
            return Optional.ofNullable(clazz.cast(ruleGroupId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "RuleGroupStatus":
            return Optional.ofNullable(clazz.cast(ruleGroupStatusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupResponse, T> g) {
        return obj -> g.apply((RuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule group.
         * </p>
         * <note>
         * <p>
         * If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then this ARN
         * is a placeholder that isn't attached to a valid resource.
         * </p>
         * </note>
         * 
         * @param ruleGroupArn
         *        The Amazon Resource Name (ARN) of the rule group.</p> <note>
         *        <p>
         *        If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then
         *        this ARN is a placeholder that isn't attached to a valid resource.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArn(String ruleGroupArn);

        /**
         * <p>
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * </p>
         * 
         * @param ruleGroupName
         *        The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupName(String ruleGroupName);

        /**
         * <p>
         * The unique identifier for the rule group.
         * </p>
         * 
         * @param ruleGroupId
         *        The unique identifier for the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupId(String ruleGroupId);

        /**
         * <p>
         * A description of the rule group.
         * </p>
         * 
         * @param description
         *        A description of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * </p>
         * 
         * @param type
         *        Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         *        stateless rules. If it is stateful, it contains stateful rules.
         * @see RuleGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         * stateless rules. If it is stateful, it contains stateful rules.
         * </p>
         * 
         * @param type
         *        Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains
         *        stateless rules. If it is stateful, it contains stateful rules.
         * @see RuleGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupType
         */
        Builder type(RuleGroupType type);

        /**
         * <p>
         * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When
         * you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall
         * policy, Network Firewall reserves this capacity for the rule group.
         * </p>
         * <p>
         * You can retrieve the capacity that would be required for a rule group before you create the rule group by
         * calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
         * </p>
         * 
         * @param capacity
         *        The maximum operating resources that this rule group can use. Rule group capacity is fixed at
         *        creation. When you update a rule group, you are limited to this capacity. When you reference a rule
         *        group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p>
         *        <p>
         *        You can retrieve the capacity that would be required for a rule group before you create the rule group
         *        by calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Integer capacity);

        /**
         * <p>
         * Detailed information about the current status of a rule group.
         * </p>
         * 
         * @param ruleGroupStatus
         *        Detailed information about the current status of a rule group.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder ruleGroupStatus(String ruleGroupStatus);

        /**
         * <p>
         * Detailed information about the current status of a rule group.
         * </p>
         * 
         * @param ruleGroupStatus
         *        Detailed information about the current status of a rule group.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder ruleGroupStatus(ResourceStatus ruleGroupStatus);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String ruleGroupArn;

        private String ruleGroupName;

        private String ruleGroupId;

        private String description;

        private String type;

        private Integer capacity;

        private String ruleGroupStatus;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupResponse model) {
            ruleGroupArn(model.ruleGroupArn);
            ruleGroupName(model.ruleGroupName);
            ruleGroupId(model.ruleGroupId);
            description(model.description);
            type(model.type);
            capacity(model.capacity);
            ruleGroupStatus(model.ruleGroupStatus);
            tags(model.tags);
        }

        public final String getRuleGroupArn() {
            return ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        public final String getRuleGroupName() {
            return ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        public final String getRuleGroupId() {
            return ruleGroupId;
        }

        @Override
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getCapacity() {
            return capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        public final String getRuleGroupStatus() {
            return ruleGroupStatus;
        }

        @Override
        public final Builder ruleGroupStatus(String ruleGroupStatus) {
            this.ruleGroupStatus = ruleGroupStatus;
            return this;
        }

        @Override
        public final Builder ruleGroupStatus(ResourceStatus ruleGroupStatus) {
            this.ruleGroupStatus(ruleGroupStatus == null ? null : ruleGroupStatus.toString());
            return this;
        }

        public final void setRuleGroupStatus(String ruleGroupStatus) {
            this.ruleGroupStatus = ruleGroupStatus;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public RuleGroupResponse build() {
            return new RuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
