/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You
 * can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallPolicyResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallPolicyResponse.Builder, FirewallPolicyResponse> {
    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyName").getter(getter(FirewallPolicyResponse::firewallPolicyName))
            .setter(setter(Builder::firewallPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build())
            .build();

    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyArn").getter(getter(FirewallPolicyResponse::firewallPolicyArn))
            .setter(setter(Builder::firewallPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyId").getter(getter(FirewallPolicyResponse::firewallPolicyId))
            .setter(setter(Builder::firewallPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(FirewallPolicyResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyStatus").getter(getter(FirewallPolicyResponse::firewallPolicyStatusAsString))
            .setter(setter(Builder::firewallPolicyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyStatus").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(FirewallPolicyResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_POLICY_NAME_FIELD,
            FIREWALL_POLICY_ARN_FIELD, FIREWALL_POLICY_ID_FIELD, DESCRIPTION_FIELD, FIREWALL_POLICY_STATUS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String firewallPolicyName;

    private final String firewallPolicyArn;

    private final String firewallPolicyId;

    private final String description;

    private final String firewallPolicyStatus;

    private final List<Tag> tags;

    private FirewallPolicyResponse(BuilderImpl builder) {
        this.firewallPolicyName = builder.firewallPolicyName;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.firewallPolicyId = builder.firewallPolicyId;
        this.description = builder.description;
        this.firewallPolicyStatus = builder.firewallPolicyStatus;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
     * </p>
     * 
     * @return The descriptive name of the firewall policy. You can't change the name of a firewall policy after you
     *         create it.
     */
    public final String firewallPolicyName() {
        return firewallPolicyName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall policy.
     * </p>
     * <note>
     * <p>
     * If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then this ARN is
     * a placeholder that isn't attached to a valid resource.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall policy.</p> <note>
     *         <p>
     *         If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then this
     *         ARN is a placeholder that isn't attached to a valid resource.
     *         </p>
     */
    public final String firewallPolicyArn() {
        return firewallPolicyArn;
    }

    /**
     * <p>
     * The unique identifier for the firewall policy.
     * </p>
     * 
     * @return The unique identifier for the firewall policy.
     */
    public final String firewallPolicyId() {
        return firewallPolicyId;
    }

    /**
     * <p>
     * A description of the firewall policy.
     * </p>
     * 
     * @return A description of the firewall policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the firewall policy. You can retrieve this for a firewall policy by calling
     * <a>DescribeFirewallPolicy</a> and providing the firewall policy's name or ARN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallPolicyStatus} will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #firewallPolicyStatusAsString}.
     * </p>
     * 
     * @return The current status of the firewall policy. You can retrieve this for a firewall policy by calling
     *         <a>DescribeFirewallPolicy</a> and providing the firewall policy's name or ARN.
     * @see ResourceStatus
     */
    public final ResourceStatus firewallPolicyStatus() {
        return ResourceStatus.fromValue(firewallPolicyStatus);
    }

    /**
     * <p>
     * The current status of the firewall policy. You can retrieve this for a firewall policy by calling
     * <a>DescribeFirewallPolicy</a> and providing the firewall policy's name or ARN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallPolicyStatus} will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #firewallPolicyStatusAsString}.
     * </p>
     * 
     * @return The current status of the firewall policy. You can retrieve this for a firewall policy by calling
     *         <a>DescribeFirewallPolicy</a> and providing the firewall policy's name or ARN.
     * @see ResourceStatus
     */
    public final String firewallPolicyStatusAsString() {
        return firewallPolicyStatus;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallPolicyResponse)) {
            return false;
        }
        FirewallPolicyResponse other = (FirewallPolicyResponse) obj;
        return Objects.equals(firewallPolicyName(), other.firewallPolicyName())
                && Objects.equals(firewallPolicyArn(), other.firewallPolicyArn())
                && Objects.equals(firewallPolicyId(), other.firewallPolicyId())
                && Objects.equals(description(), other.description())
                && Objects.equals(firewallPolicyStatusAsString(), other.firewallPolicyStatusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallPolicyResponse").add("FirewallPolicyName", firewallPolicyName())
                .add("FirewallPolicyArn", firewallPolicyArn()).add("FirewallPolicyId", firewallPolicyId())
                .add("Description", description()).add("FirewallPolicyStatus", firewallPolicyStatusAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallPolicyName":
            return Optional.ofNullable(clazz.cast(firewallPolicyName()));
        case "FirewallPolicyArn":
            return Optional.ofNullable(clazz.cast(firewallPolicyArn()));
        case "FirewallPolicyId":
            return Optional.ofNullable(clazz.cast(firewallPolicyId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FirewallPolicyStatus":
            return Optional.ofNullable(clazz.cast(firewallPolicyStatusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallPolicyResponse, T> g) {
        return obj -> g.apply((FirewallPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallPolicyResponse> {
        /**
         * <p>
         * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create
         * it.
         * </p>
         * 
         * @param firewallPolicyName
         *        The descriptive name of the firewall policy. You can't change the name of a firewall policy after you
         *        create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyName(String firewallPolicyName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall policy.
         * </p>
         * <note>
         * <p>
         * If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then this ARN
         * is a placeholder that isn't attached to a valid resource.
         * </p>
         * </note>
         * 
         * @param firewallPolicyArn
         *        The Amazon Resource Name (ARN) of the firewall policy.</p> <note>
         *        <p>
         *        If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then
         *        this ARN is a placeholder that isn't attached to a valid resource.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyArn(String firewallPolicyArn);

        /**
         * <p>
         * The unique identifier for the firewall policy.
         * </p>
         * 
         * @param firewallPolicyId
         *        The unique identifier for the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyId(String firewallPolicyId);

        /**
         * <p>
         * A description of the firewall policy.
         * </p>
         * 
         * @param description
         *        A description of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the firewall policy. You can retrieve this for a firewall policy by calling
         * <a>DescribeFirewallPolicy</a> and providing the firewall policy's name or ARN.
         * </p>
         * 
         * @param firewallPolicyStatus
         *        The current status of the firewall policy. You can retrieve this for a firewall policy by calling
         *        <a>DescribeFirewallPolicy</a> and providing the firewall policy's name or ARN.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder firewallPolicyStatus(String firewallPolicyStatus);

        /**
         * <p>
         * The current status of the firewall policy. You can retrieve this for a firewall policy by calling
         * <a>DescribeFirewallPolicy</a> and providing the firewall policy's name or ARN.
         * </p>
         * 
         * @param firewallPolicyStatus
         *        The current status of the firewall policy. You can retrieve this for a firewall policy by calling
         *        <a>DescribeFirewallPolicy</a> and providing the firewall policy's name or ARN.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder firewallPolicyStatus(ResourceStatus firewallPolicyStatus);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String firewallPolicyName;

        private String firewallPolicyArn;

        private String firewallPolicyId;

        private String description;

        private String firewallPolicyStatus;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallPolicyResponse model) {
            firewallPolicyName(model.firewallPolicyName);
            firewallPolicyArn(model.firewallPolicyArn);
            firewallPolicyId(model.firewallPolicyId);
            description(model.description);
            firewallPolicyStatus(model.firewallPolicyStatus);
            tags(model.tags);
        }

        public final String getFirewallPolicyName() {
            return firewallPolicyName;
        }

        @Override
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        public final String getFirewallPolicyArn() {
            return firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        public final String getFirewallPolicyId() {
            return firewallPolicyId;
        }

        @Override
        public final Builder firewallPolicyId(String firewallPolicyId) {
            this.firewallPolicyId = firewallPolicyId;
            return this;
        }

        public final void setFirewallPolicyId(String firewallPolicyId) {
            this.firewallPolicyId = firewallPolicyId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFirewallPolicyStatus() {
            return firewallPolicyStatus;
        }

        @Override
        public final Builder firewallPolicyStatus(String firewallPolicyStatus) {
            this.firewallPolicyStatus = firewallPolicyStatus;
            return this;
        }

        @Override
        public final Builder firewallPolicyStatus(ResourceStatus firewallPolicyStatus) {
            this.firewallPolicyStatus(firewallPolicyStatus == null ? null : firewallPolicyStatus.toString());
            return this;
        }

        public final void setFirewallPolicyStatus(String firewallPolicyStatus) {
            this.firewallPolicyStatus = firewallPolicyStatus;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public FirewallPolicyResponse build() {
            return new FirewallPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
