/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ProxyTunnelInitHandler;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public class Http1TunnelConnectionPool
implements ChannelPool {
    static final AttributeKey<Boolean> TUNNEL_ESTABLISHED_KEY = AttributeKey.newInstance((String)"aws.http.nio.netty.async.Http1TunnelConnectionPool.tunnelEstablished");
    private static final Logger log = Logger.loggerFor(Http1TunnelConnectionPool.class);
    private final EventLoop eventLoop;
    private final ChannelPool delegate;
    private final SslContext sslContext;
    private final URI proxyAddress;
    private final URI remoteAddress;
    private final ChannelPoolHandler handler;
    private final InitHandlerSupplier initHandlerSupplier;

    public Http1TunnelConnectionPool(EventLoop eventLoop, ChannelPool delegate, SslContext sslContext, URI proxyAddress, URI remoteAddress, ChannelPoolHandler handler) {
        this(eventLoop, delegate, sslContext, proxyAddress, remoteAddress, handler, ProxyTunnelInitHandler::new);
    }

    @SdkTestInternalApi
    Http1TunnelConnectionPool(EventLoop eventLoop, ChannelPool delegate, SslContext sslContext, URI proxyAddress, URI remoteAddress, ChannelPoolHandler handler, InitHandlerSupplier initHandlerSupplier) {
        this.eventLoop = eventLoop;
        this.delegate = delegate;
        this.sslContext = sslContext;
        this.proxyAddress = proxyAddress;
        this.remoteAddress = remoteAddress;
        this.handler = handler;
        this.initHandlerSupplier = initHandlerSupplier;
    }

    public Future<Channel> acquire() {
        return this.acquire((Promise<Channel>)this.eventLoop.newPromise());
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        this.delegate.acquire(this.eventLoop.newPromise()).addListener(f -> {
            if (f.isSuccess()) {
                this.setupChannel((Channel)f.getNow(), promise);
            } else {
                promise.setFailure(f.cause());
            }
        });
        return promise;
    }

    public Future<Void> release(Channel channel) {
        return this.release(channel, (Promise<Void>)this.eventLoop.newPromise());
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        return this.delegate.release(channel, promise);
    }

    public void close() {
        this.delegate.close();
    }

    private void setupChannel(Channel ch, Promise<Channel> acquirePromise) {
        if (Http1TunnelConnectionPool.isTunnelEstablished(ch)) {
            log.debug(() -> String.format("Tunnel already established for %s", ch.id().asShortText()));
            acquirePromise.setSuccess((Object)ch);
            return;
        }
        log.debug(() -> String.format("Tunnel not yet established for channel %s. Establishing tunnel now.", ch.id().asShortText()));
        Promise tunnelEstablishedPromise = this.eventLoop.newPromise();
        SslHandler sslHandler = this.createSslHandlerIfNeeded(ch.alloc());
        if (sslHandler != null) {
            ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
        }
        ch.pipeline().addLast(new ChannelHandler[]{this.initHandlerSupplier.newInitHandler(this.delegate, this.remoteAddress, (Promise<Channel>)tunnelEstablishedPromise)});
        tunnelEstablishedPromise.addListener(f -> {
            if (f.isSuccess()) {
                Channel tunnel = (Channel)f.getNow();
                this.handler.channelCreated(tunnel);
                tunnel.attr(TUNNEL_ESTABLISHED_KEY).set((Object)true);
                acquirePromise.setSuccess((Object)tunnel);
            } else {
                ch.close();
                this.delegate.release(ch);
                Throwable cause = f.cause();
                log.error(() -> String.format("Unable to establish tunnel for channel %s", ch.id().asShortText()), cause);
                acquirePromise.setFailure(cause);
            }
        });
    }

    private SslHandler createSslHandlerIfNeeded(ByteBufAllocator alloc) {
        if (this.sslContext == null) {
            return null;
        }
        String scheme = this.proxyAddress.getScheme();
        if (!"https".equals(StringUtils.lowerCase((String)scheme))) {
            return null;
        }
        return this.sslContext.newHandler(alloc, this.proxyAddress.getHost(), this.proxyAddress.getPort());
    }

    private static boolean isTunnelEstablished(Channel ch) {
        Boolean established = (Boolean)ch.attr(TUNNEL_ESTABLISHED_KEY).get();
        return Boolean.TRUE.equals(established);
    }

    @FunctionalInterface
    @SdkTestInternalApi
    static interface InitHandlerSupplier {
        public ChannelHandler newInitHandler(ChannelPool var1, URI var2, Promise<Channel> var3);
    }
}

