/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2PingFrame;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.utils.ChannelUtils;
import software.amazon.awssdk.utils.Logger;

@ChannelHandler.Sharable
@SdkInternalApi
public final class Http2PingFrameHandler
extends SimpleChannelInboundHandler<Http2PingFrame> {
    private static final Logger log = Logger.loggerFor(Http2PingFrameHandler.class);
    private static final Http2PingFrameHandler INSTANCE = new Http2PingFrameHandler();

    private Http2PingFrameHandler() {
    }

    public static Http2PingFrameHandler create() {
        return INSTANCE;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Http2PingFrame frame) {
        if (frame.ack()) {
            Channel channel = ctx.channel();
            log.debug(() -> "Received PING ACK from channel " + channel);
            ChannelUtils.getAttribute(channel, ChannelAttributeKey.PING_TRACKER).ifPresent(tracker -> {
                tracker.cancel();
                channel.attr(ChannelAttributeKey.PING_TRACKER).set(null);
            });
        } else {
            ctx.fireChannelRead((Object)frame);
        }
    }
}

