/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.concurrent.EventExecutor;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.async.AbortableRunnable;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKeys;
import software.amazon.awssdk.http.nio.netty.internal.CompletingHandlerPublisher;
import software.amazon.awssdk.http.nio.netty.internal.NettyHttpContentSubscriber;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;

public final class RunnableRequest
implements AbortableRunnable {
    private static final Logger log = LoggerFactory.getLogger(RunnableRequest.class);
    private final RequestContext context;
    private volatile Channel channel;

    public RunnableRequest(RequestContext context) {
        this.context = context;
    }

    public void run() {
        this.context.channelPool().acquire().addListener(channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.channel = (Channel)channelFuture.getNow();
                this.channel.attr(ChannelAttributeKeys.REQUEST_CONTEXT_KEY).set((Object)this.context);
                this.channel.attr(ChannelAttributeKeys.HAS_CALLED_ON_STREAM).set((Object)Boolean.FALSE);
                Subscriber<ByteBuffer> adaptedSubscriber = this.addBackpressureHandlers();
                this.makeRequest(this.context.nettyRequest(), adaptedSubscriber);
            } else {
                this.handleFailure(() -> "Failed to create connection to " + this.endpoint(), channelFuture.cause());
            }
        });
    }

    public void abort() {
        if (this.channel != null) {
            this.channel.disconnect().addListener(ignored -> this.context.channelPool().release(this.channel));
        }
    }

    private Subscriber<ByteBuffer> addBackpressureHandlers() {
        NettyHttpContentSubscriber httpContentSubscriber = new NettyHttpContentSubscriber(this.channel);
        Subscriber<ByteBuffer> byteBufferSubscriber = httpContentSubscriber.adapt();
        CompletingHandlerPublisher publisher = new CompletingHandlerPublisher((EventExecutor)this.channel.eventLoop(), this.context.handler());
        this.channel.pipeline().addLast(new ChannelHandler[]{publisher, httpContentSubscriber});
        this.channel.attr(ChannelAttributeKeys.PUBLISHER_KEY).set((Object)publisher);
        return byteBufferSubscriber;
    }

    private void makeRequest(HttpRequest request, Subscriber<ByteBuffer> subscriber) {
        log.debug("Writing request: {}", (Object)request);
        this.channel.write((Object)request).addListener(wireCall -> {
            if (!wireCall.isSuccess()) {
                this.handleFailure(() -> "Failed to make request to " + this.endpoint(), wireCall.cause());
            }
        });
        this.context.sdkRequestProvider().subscribe(subscriber);
    }

    private URI endpoint() {
        return this.context.sdkRequest().getEndpoint();
    }

    private void handleFailure(Supplier<String> msg, Throwable cause) {
        log.error(msg.get(), cause);
        this.context.handler().exceptionOccurred(cause);
        if (this.channel != null) {
            this.context.channelPool().release(this.channel);
        }
    }
}

