/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import com.typesafe.netty.HandlerPublisher;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKeys;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;

@ChannelHandler.Sharable
class ResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger log = LoggerFactory.getLogger(ResponseHandler.class);

    ResponseHandler() {
    }

    protected void channelRead0(ChannelHandlerContext channelContext, HttpObject msg) throws Exception {
        RequestContext requestContext = (RequestContext)channelContext.channel().attr(ChannelAttributeKeys.REQUEST_CONTEXT_KEY).get();
        HandlerPublisher publisher = (HandlerPublisher)channelContext.channel().attr(ChannelAttributeKeys.PUBLISHER_KEY).get();
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            SdkHttpFullResponse sdkResponse = SdkHttpFullResponse.builder().headers(ResponseHandler.fromNettyHeaders(response.headers())).statusCode(response.status().code()).statusText(response.status().reasonPhrase()).build();
            requestContext.handler().headersReceived((SdkHttpResponse)sdkResponse);
        }
        if (msg instanceof HttpContent) {
            HttpContent content;
            Boolean hasCalledOnStream = (Boolean)channelContext.channel().attr(ChannelAttributeKeys.HAS_CALLED_ON_STREAM).get();
            if (!Boolean.TRUE.equals(hasCalledOnStream)) {
                requestContext.handler().onStream((Publisher)publisher);
                channelContext.channel().attr(ChannelAttributeKeys.HAS_CALLED_ON_STREAM).set((Object)Boolean.TRUE);
            }
            if ((content = (HttpContent)msg).content().readableBytes() > 0) {
                channelContext.fireChannelRead((Object)content.content().nioBuffer());
            }
            if (msg instanceof LastHttpContent) {
                channelContext.pipeline().remove((ChannelHandler)publisher);
                requestContext.channelPool().release(channelContext.channel());
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        RequestContext requestContext = (RequestContext)ctx.channel().attr(ChannelAttributeKeys.REQUEST_CONTEXT_KEY).get();
        log.error("Exception processing request: {}", (Object)requestContext.sdkRequest(), (Object)cause);
        requestContext.handler().exceptionOccurred(cause);
        requestContext.channelPool().release(ctx.channel());
        ctx.fireExceptionCaught(cause);
    }

    private static Map<String, List<String>> fromNettyHeaders(HttpHeaders headers) {
        return headers.entries().stream().collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }
}

