/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.ArrayList;
import software.amazon.awssdk.http.nio.netty.internal.ResponseHandler;
import software.amazon.awssdk.http.nio.netty.internal.utils.LoggingHandler;
import software.amazon.awssdk.utils.Logger;

public class ChannelPipelineInitializer
extends AbstractChannelPoolHandler {
    private static final Logger log = Logger.loggerFor(ChannelPipelineInitializer.class);
    private final SslContext sslContext;
    private final ChannelHandler[] handlers;

    public ChannelPipelineInitializer(SslContext sslContext) {
        this.sslContext = sslContext;
        ArrayList<Object> tmpHandlers = new ArrayList<Object>();
        if (log.isLoggingLevelEnabled("debug")) {
            tmpHandlers.add((Object)new LoggingHandler(arg_0 -> ((Logger)log).debug(arg_0)));
        }
        tmpHandlers.add((Object)new ResponseHandler());
        this.handlers = tmpHandlers.toArray(new ChannelHandler[0]);
    }

    public void channelCreated(Channel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        if (this.sslContext != null) {
            SslHandler handler = this.sslContext.newHandler(ch.alloc());
            p.addLast(new ChannelHandler[]{handler});
            handler.handshakeFuture().addListener(future -> {
                if (!future.isSuccess()) {
                    log.error(() -> "SSL handshake failed.", future.cause());
                }
            });
        }
        p.addLast(new ChannelHandler[]{new HttpClientCodec()});
        p.addLast(this.handlers);
        ch.config().setOption(ChannelOption.AUTO_READ, (Object)false);
    }
}

