/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.http.async.AbortableRunnable;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.ChannelPipelineInitializer;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.http.nio.netty.internal.NonManagedEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.RequestAdapter;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.RunnableRequest;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelPoolMap;
import software.amazon.awssdk.http.nio.netty.internal.SharedSdkEventLoopGroup;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class NettyNioAsyncHttpClient
implements SdkAsyncHttpClient {
    private static final Logger log = Logger.loggerFor(NettyNioAsyncHttpClient.class);
    private final RequestAdapter requestAdapter = new RequestAdapter();
    private final ChannelPoolMap<URI, ChannelPool> pools;
    private final NettyConfiguration configuration;
    private final SdkEventLoopGroup sdkEventLoopGroup;

    private NettyNioAsyncHttpClient(DefaultBuilder builder, AttributeMap configuration) {
        this.configuration = new NettyConfiguration(configuration);
        this.sdkEventLoopGroup = this.resolveSdkEventLoopGroup(builder);
        this.pools = this.createChannelPoolMap();
    }

    private SdkEventLoopGroup resolveSdkEventLoopGroup(DefaultBuilder builder) {
        Validate.isTrue((builder.eventLoopGroup == null || builder.eventLoopGroupBuilder == null ? 1 : 0) != 0, (String)"The sdkEventLoopGroup and the eventLoopGroupBuilder can't both be configured.", (Object[])new Object[0]);
        return Either.fromNullable((Object)builder.eventLoopGroup, (Object)builder.eventLoopGroupBuilder).map(either -> (SdkEventLoopGroup)either.map(this::nonManagedEventLoopGroup, SdkEventLoopGroup.Builder::build)).orElseGet(SharedSdkEventLoopGroup::get);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private ChannelPoolMap<URI, ChannelPool> createChannelPoolMap() {
        return new SdkChannelPoolMap<URI, ChannelPool>(){

            @Override
            protected ChannelPool newPool(URI key) {
                Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(NettyNioAsyncHttpClient.this.sdkEventLoopGroup.eventLoopGroup())).channelFactory(NettyNioAsyncHttpClient.this.sdkEventLoopGroup.channelFactory())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)NettyNioAsyncHttpClient.this.configuration.connectTimeoutMillis())).option(ChannelOption.TCP_NODELAY, (Object)true)).remoteAddress(key.getHost(), key.getPort());
                SslContext sslContext = NettyNioAsyncHttpClient.this.sslContext(key.getScheme());
                return new FixedChannelPool(bootstrap, (ChannelPoolHandler)new ChannelPipelineInitializer(sslContext), ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, (long)NettyNioAsyncHttpClient.this.configuration.connectionAcquireTimeoutMillis(), NettyNioAsyncHttpClient.this.configuration.maxConnections(), NettyNioAsyncHttpClient.this.configuration.maxPendingConnectionAcquires());
            }
        };
    }

    private SdkEventLoopGroup nonManagedEventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
        return SdkEventLoopGroup.create(new NonManagedEventLoopGroup(eventLoopGroup.eventLoopGroup()), eventLoopGroup.channelFactory());
    }

    public AbortableRunnable prepareRequest(SdkHttpRequest sdkRequest, SdkRequestContext requestContext, SdkHttpRequestProvider requestProvider, SdkHttpResponseHandler handler) {
        RequestContext context = new RequestContext(this.pools.get((Object)NettyNioAsyncHttpClient.poolKey(sdkRequest)), sdkRequest, requestProvider, this.requestAdapter.adapt(sdkRequest), handler, this.configuration);
        return new RunnableRequest(context);
    }

    public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
        return Optional.ofNullable(this.configuration.attribute(key));
    }

    public void close() {
        this.sdkEventLoopGroup.eventLoopGroup().shutdownGracefully();
    }

    private static URI poolKey(SdkHttpRequest sdkRequest) {
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(sdkRequest.protocol(), null, sdkRequest.host(), sdkRequest.port(), null, null, null));
    }

    private SslContext sslContext(String scheme) {
        if (scheme.equalsIgnoreCase("https")) {
            SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(SslContext.defaultClientProvider());
            if (this.configuration.trustAllCertificates()) {
                log.warn(() -> "SSL Certificate verification is disabled. This is not a safe setting and should only be used for testing.");
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            return (SslContext)FunctionalUtils.invokeSafely(() -> ((SslContextBuilder)builder).build());
        }
        return null;
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();
        private SdkEventLoopGroup eventLoopGroup;
        private SdkEventLoopGroup.Builder eventLoopGroupBuilder;

        private DefaultBuilder() {
        }

        @Override
        public Builder maxConnectionsPerEndpoint(Integer maxConnectionsPerEndpoint) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConnectionsPerEndpoint);
            return this;
        }

        public void setMaxConnectionsPerEndpoint(Integer maxConnectionsPerEndpoint) {
            this.maxConnectionsPerEndpoint(maxConnectionsPerEndpoint);
        }

        @Override
        public Builder maxPendingConnectionAcquires(Integer maxPendingAcquires) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_PENDING_CONNECTION_ACQUIRES, (Object)maxPendingAcquires);
            return this;
        }

        public void setMaxPendingConnectionAcquires(Integer maxPendingAcquires) {
            this.maxPendingConnectionAcquires(maxPendingAcquires);
        }

        @Override
        public Builder readTimeout(Duration readTimeout) {
            Validate.isPositive((Duration)readTimeout, (String)"readTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)readTimeout);
            return this;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout(readTimeout);
        }

        @Override
        public Builder writeTimeout(Duration writeTimeout) {
            Validate.isPositive((Duration)writeTimeout, (String)"connectionAcquisitionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.WRITE_TIMEOUT, (Object)writeTimeout);
            return this;
        }

        public void setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout(writeTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration timeout) {
            Validate.isPositive((Duration)timeout, (String)"connectionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)timeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder connectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            Validate.isPositive((Duration)connectionAcquisitionTimeout, (String)"connectionAcquisitionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT, (Object)connectionAcquisitionTimeout);
            return this;
        }

        public void setConnectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            this.connectionAcquisitionTimeout(connectionAcquisitionTimeout);
        }

        @Override
        public Builder eventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public void setEventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
            this.eventLoopGroup(eventLoopGroup);
        }

        @Override
        public Builder eventLoopGroupBuilder(SdkEventLoopGroup.Builder eventLoopGroupBuilder) {
            this.eventLoopGroupBuilder = eventLoopGroupBuilder;
            return this;
        }

        public void setEventLoopGroupBuilder(SdkEventLoopGroup.Builder eventLoopGroupBuilder) {
            this.eventLoopGroupBuilder(eventLoopGroupBuilder);
        }

        public SdkAsyncHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new NettyNioAsyncHttpClient(this, this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }
    }

    public static interface Builder
    extends SdkAsyncHttpClient.Builder<Builder> {
        public Builder maxConnectionsPerEndpoint(Integer var1);

        public Builder maxPendingConnectionAcquires(Integer var1);

        public Builder readTimeout(Duration var1);

        public Builder writeTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder connectionAcquisitionTimeout(Duration var1);

        public Builder eventLoopGroup(SdkEventLoopGroup var1);

        public Builder eventLoopGroupBuilder(SdkEventLoopGroup.Builder var1);
    }
}

