/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.http.nio.netty.DefaultEventLoopGroupFactory;
import software.amazon.awssdk.http.nio.netty.internal.DelegatingEventLoopGroup;

public final class SharedEventLoopGroup {
    private static EventLoopGroup sharedEventLoopGroup;
    private static int referenceCount;

    private SharedEventLoopGroup() {
    }

    @SdkInternalApi
    public static synchronized EventLoopGroup get() {
        if (sharedEventLoopGroup == null) {
            sharedEventLoopGroup = ((DefaultEventLoopGroupFactory)DefaultEventLoopGroupFactory.builder().build()).create();
        }
        ++referenceCount;
        return new ReferenceCountingEventLoopGroup(sharedEventLoopGroup);
    }

    private static synchronized void decrementReference() {
        if (--referenceCount == 0) {
            sharedEventLoopGroup.shutdownGracefully();
            sharedEventLoopGroup = null;
        }
    }

    @SdkTestInternalApi
    static synchronized int referenceCount() {
        return referenceCount;
    }

    static {
        referenceCount = 0;
    }

    private static class ReferenceCountingEventLoopGroup
    extends DelegatingEventLoopGroup {
        private final AtomicBoolean hasBeenClosed = new AtomicBoolean(false);

        private ReferenceCountingEventLoopGroup(EventLoopGroup delegate) {
            super(delegate);
        }

        @Override
        public Future<?> shutdownGracefully() {
            if (this.hasBeenClosed.compareAndSet(false, true)) {
                SharedEventLoopGroup.decrementReference();
            }
            return null;
        }
    }
}

