/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NeptuneImportOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NeptuneImportOptions> {
    private static final SdkField<String> S3_EXPORT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3ExportPath").getter(NeptuneImportOptions.getter(NeptuneImportOptions::s3ExportPath)).setter(NeptuneImportOptions.setter(Builder::s3ExportPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ExportPath").build()}).build();
    private static final SdkField<String> S3_EXPORT_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3ExportKmsKeyId").getter(NeptuneImportOptions.getter(NeptuneImportOptions::s3ExportKmsKeyId)).setter(NeptuneImportOptions.setter(Builder::s3ExportKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ExportKmsKeyId").build()}).build();
    private static final SdkField<Boolean> PRESERVE_DEFAULT_VERTEX_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("preserveDefaultVertexLabels").getter(NeptuneImportOptions.getter(NeptuneImportOptions::preserveDefaultVertexLabels)).setter(NeptuneImportOptions.setter(Builder::preserveDefaultVertexLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preserveDefaultVertexLabels").build()}).build();
    private static final SdkField<Boolean> PRESERVE_EDGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("preserveEdgeIds").getter(NeptuneImportOptions.getter(NeptuneImportOptions::preserveEdgeIds)).setter(NeptuneImportOptions.setter(Builder::preserveEdgeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preserveEdgeIds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_EXPORT_PATH_FIELD, S3_EXPORT_KMS_KEY_ID_FIELD, PRESERVE_DEFAULT_VERTEX_LABELS_FIELD, PRESERVE_EDGE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NeptuneImportOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3ExportPath;
    private final String s3ExportKmsKeyId;
    private final Boolean preserveDefaultVertexLabels;
    private final Boolean preserveEdgeIds;

    private NeptuneImportOptions(BuilderImpl builder) {
        this.s3ExportPath = builder.s3ExportPath;
        this.s3ExportKmsKeyId = builder.s3ExportKmsKeyId;
        this.preserveDefaultVertexLabels = builder.preserveDefaultVertexLabels;
        this.preserveEdgeIds = builder.preserveEdgeIds;
    }

    public final String s3ExportPath() {
        return this.s3ExportPath;
    }

    public final String s3ExportKmsKeyId() {
        return this.s3ExportKmsKeyId;
    }

    public final Boolean preserveDefaultVertexLabels() {
        return this.preserveDefaultVertexLabels;
    }

    public final Boolean preserveEdgeIds() {
        return this.preserveEdgeIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveDefaultVertexLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveEdgeIds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeptuneImportOptions)) {
            return false;
        }
        NeptuneImportOptions other = (NeptuneImportOptions)obj;
        return Objects.equals(this.s3ExportPath(), other.s3ExportPath()) && Objects.equals(this.s3ExportKmsKeyId(), other.s3ExportKmsKeyId()) && Objects.equals(this.preserveDefaultVertexLabels(), other.preserveDefaultVertexLabels()) && Objects.equals(this.preserveEdgeIds(), other.preserveEdgeIds());
    }

    public final String toString() {
        return ToString.builder((String)"NeptuneImportOptions").add("S3ExportPath", (Object)this.s3ExportPath()).add("S3ExportKmsKeyId", (Object)this.s3ExportKmsKeyId()).add("PreserveDefaultVertexLabels", (Object)this.preserveDefaultVertexLabels()).add("PreserveEdgeIds", (Object)this.preserveEdgeIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3ExportPath": {
                return Optional.ofNullable(clazz.cast(this.s3ExportPath()));
            }
            case "s3ExportKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.s3ExportKmsKeyId()));
            }
            case "preserveDefaultVertexLabels": {
                return Optional.ofNullable(clazz.cast(this.preserveDefaultVertexLabels()));
            }
            case "preserveEdgeIds": {
                return Optional.ofNullable(clazz.cast(this.preserveEdgeIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3ExportPath", S3_EXPORT_PATH_FIELD);
        map.put("s3ExportKmsKeyId", S3_EXPORT_KMS_KEY_ID_FIELD);
        map.put("preserveDefaultVertexLabels", PRESERVE_DEFAULT_VERTEX_LABELS_FIELD);
        map.put("preserveEdgeIds", PRESERVE_EDGE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NeptuneImportOptions, T> g) {
        return obj -> g.apply((NeptuneImportOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3ExportPath;
        private String s3ExportKmsKeyId;
        private Boolean preserveDefaultVertexLabels;
        private Boolean preserveEdgeIds;

        private BuilderImpl() {
        }

        private BuilderImpl(NeptuneImportOptions model) {
            this.s3ExportPath(model.s3ExportPath);
            this.s3ExportKmsKeyId(model.s3ExportKmsKeyId);
            this.preserveDefaultVertexLabels(model.preserveDefaultVertexLabels);
            this.preserveEdgeIds(model.preserveEdgeIds);
        }

        public final String getS3ExportPath() {
            return this.s3ExportPath;
        }

        public final void setS3ExportPath(String s3ExportPath) {
            this.s3ExportPath = s3ExportPath;
        }

        @Override
        public final Builder s3ExportPath(String s3ExportPath) {
            this.s3ExportPath = s3ExportPath;
            return this;
        }

        public final String getS3ExportKmsKeyId() {
            return this.s3ExportKmsKeyId;
        }

        public final void setS3ExportKmsKeyId(String s3ExportKmsKeyId) {
            this.s3ExportKmsKeyId = s3ExportKmsKeyId;
        }

        @Override
        public final Builder s3ExportKmsKeyId(String s3ExportKmsKeyId) {
            this.s3ExportKmsKeyId = s3ExportKmsKeyId;
            return this;
        }

        public final Boolean getPreserveDefaultVertexLabels() {
            return this.preserveDefaultVertexLabels;
        }

        public final void setPreserveDefaultVertexLabels(Boolean preserveDefaultVertexLabels) {
            this.preserveDefaultVertexLabels = preserveDefaultVertexLabels;
        }

        @Override
        public final Builder preserveDefaultVertexLabels(Boolean preserveDefaultVertexLabels) {
            this.preserveDefaultVertexLabels = preserveDefaultVertexLabels;
            return this;
        }

        public final Boolean getPreserveEdgeIds() {
            return this.preserveEdgeIds;
        }

        public final void setPreserveEdgeIds(Boolean preserveEdgeIds) {
            this.preserveEdgeIds = preserveEdgeIds;
        }

        @Override
        public final Builder preserveEdgeIds(Boolean preserveEdgeIds) {
            this.preserveEdgeIds = preserveEdgeIds;
            return this;
        }

        public NeptuneImportOptions build() {
            return new NeptuneImportOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NeptuneImportOptions> {
        public Builder s3ExportPath(String var1);

        public Builder s3ExportKmsKeyId(String var1);

        public Builder preserveDefaultVertexLabels(Boolean var1);

        public Builder preserveEdgeIds(Boolean var1);
    }
}

