/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.ImportTaskSummary;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse;

public class ListImportTasksIterable
implements SdkIterable<ListImportTasksResponse> {
    private final NeptuneGraphClient client;
    private final ListImportTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportTasksIterable(NeptuneGraphClient client, ListImportTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImportTasksResponseFetcher();
    }

    public Iterator<ListImportTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportTaskSummary> tasks() {
        Function<ListImportTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImportTasksResponseFetcher
    implements SyncPageFetcher<ListImportTasksResponse> {
        private ListImportTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListImportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportTasksResponse nextPage(ListImportTasksResponse previousPage) {
            if (previousPage == null) {
                return ListImportTasksIterable.this.client.listImportTasks(ListImportTasksIterable.this.firstRequest);
            }
            return ListImportTasksIterable.this.client.listImportTasks((ListImportTasksRequest)((Object)ListImportTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

