/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreGraphFromSnapshotRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, RestoreGraphFromSnapshotRequest> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotIdentifier").getter(RestoreGraphFromSnapshotRequest.getter(RestoreGraphFromSnapshotRequest::snapshotIdentifier)).setter(RestoreGraphFromSnapshotRequest.setter(Builder::snapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotIdentifier").build()}).build();
    private static final SdkField<String> GRAPH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphName").getter(RestoreGraphFromSnapshotRequest.getter(RestoreGraphFromSnapshotRequest::graphName)).setter(RestoreGraphFromSnapshotRequest.setter(Builder::graphName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphName").build()}).build();
    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("provisionedMemory").getter(RestoreGraphFromSnapshotRequest.getter(RestoreGraphFromSnapshotRequest::provisionedMemory)).setter(RestoreGraphFromSnapshotRequest.setter(Builder::provisionedMemory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtection").getter(RestoreGraphFromSnapshotRequest.getter(RestoreGraphFromSnapshotRequest::deletionProtection)).setter(RestoreGraphFromSnapshotRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(RestoreGraphFromSnapshotRequest.getter(RestoreGraphFromSnapshotRequest::tags)).setter(RestoreGraphFromSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("replicaCount").getter(RestoreGraphFromSnapshotRequest.getter(RestoreGraphFromSnapshotRequest::replicaCount)).setter(RestoreGraphFromSnapshotRequest.setter(Builder::replicaCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()}).build();
    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publicConnectivity").getter(RestoreGraphFromSnapshotRequest.getter(RestoreGraphFromSnapshotRequest::publicConnectivity)).setter(RestoreGraphFromSnapshotRequest.setter(Builder::publicConnectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD, GRAPH_NAME_FIELD, PROVISIONED_MEMORY_FIELD, DELETION_PROTECTION_FIELD, TAGS_FIELD, REPLICA_COUNT_FIELD, PUBLIC_CONNECTIVITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreGraphFromSnapshotRequest.memberNameToFieldInitializer();
    private final String snapshotIdentifier;
    private final String graphName;
    private final Integer provisionedMemory;
    private final Boolean deletionProtection;
    private final Map<String, String> tags;
    private final Integer replicaCount;
    private final Boolean publicConnectivity;

    private RestoreGraphFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.graphName = builder.graphName;
        this.provisionedMemory = builder.provisionedMemory;
        this.deletionProtection = builder.deletionProtection;
        this.tags = builder.tags;
        this.replicaCount = builder.replicaCount;
        this.publicConnectivity = builder.publicConnectivity;
    }

    public final String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public final String graphName() {
        return this.graphName;
    }

    public final Integer provisionedMemory() {
        return this.provisionedMemory;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer replicaCount() {
        return this.replicaCount;
    }

    public final Boolean publicConnectivity() {
        return this.publicConnectivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.graphName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicConnectivity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreGraphFromSnapshotRequest)) {
            return false;
        }
        RestoreGraphFromSnapshotRequest other = (RestoreGraphFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.graphName(), other.graphName()) && Objects.equals(this.provisionedMemory(), other.provisionedMemory()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.replicaCount(), other.replicaCount()) && Objects.equals(this.publicConnectivity(), other.publicConnectivity());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreGraphFromSnapshotRequest").add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("GraphName", (Object)this.graphName()).add("ProvisionedMemory", (Object)this.provisionedMemory()).add("DeletionProtection", (Object)this.deletionProtection()).add("Tags", this.hasTags() ? this.tags() : null).add("ReplicaCount", (Object)this.replicaCount()).add("PublicConnectivity", (Object)this.publicConnectivity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "snapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "graphName": {
                return Optional.ofNullable(clazz.cast(this.graphName()));
            }
            case "provisionedMemory": {
                return Optional.ofNullable(clazz.cast(this.provisionedMemory()));
            }
            case "deletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "replicaCount": {
                return Optional.ofNullable(clazz.cast(this.replicaCount()));
            }
            case "publicConnectivity": {
                return Optional.ofNullable(clazz.cast(this.publicConnectivity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("snapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
        map.put("graphName", GRAPH_NAME_FIELD);
        map.put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreGraphFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreGraphFromSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private String snapshotIdentifier;
        private String graphName;
        private Integer provisionedMemory;
        private Boolean deletionProtection;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer replicaCount;
        private Boolean publicConnectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreGraphFromSnapshotRequest model) {
            super(model);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.graphName(model.graphName);
            this.provisionedMemory(model.provisionedMemory);
            this.deletionProtection(model.deletionProtection);
            this.tags(model.tags);
            this.replicaCount(model.replicaCount);
            this.publicConnectivity(model.publicConnectivity);
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getGraphName() {
            return this.graphName;
        }

        public final void setGraphName(String graphName) {
            this.graphName = graphName;
        }

        @Override
        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Integer getProvisionedMemory() {
            return this.provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return this.publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreGraphFromSnapshotRequest build() {
            return new RestoreGraphFromSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreGraphFromSnapshotRequest> {
        public Builder snapshotIdentifier(String var1);

        public Builder graphName(String var1);

        public Builder provisionedMemory(Integer var1);

        public Builder deletionProtection(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder replicaCount(Integer var1);

        public Builder publicConnectivity(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

