/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.SnapshotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GraphSnapshotSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GraphSnapshotSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GraphSnapshotSummary.getter(GraphSnapshotSummary::id)).setter(GraphSnapshotSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GraphSnapshotSummary.getter(GraphSnapshotSummary::name)).setter(GraphSnapshotSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GraphSnapshotSummary.getter(GraphSnapshotSummary::arn)).setter(GraphSnapshotSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SOURCE_GRAPH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceGraphId").getter(GraphSnapshotSummary.getter(GraphSnapshotSummary::sourceGraphId)).setter(GraphSnapshotSummary.setter(Builder::sourceGraphId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceGraphId").build()}).build();
    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("snapshotCreateTime").getter(GraphSnapshotSummary.getter(GraphSnapshotSummary::snapshotCreateTime)).setter(GraphSnapshotSummary.setter(Builder::snapshotCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCreateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GraphSnapshotSummary.getter(GraphSnapshotSummary::statusAsString)).setter(GraphSnapshotSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(GraphSnapshotSummary.getter(GraphSnapshotSummary::kmsKeyIdentifier)).setter(GraphSnapshotSummary.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, SOURCE_GRAPH_ID_FIELD, SNAPSHOT_CREATE_TIME_FIELD, STATUS_FIELD, KMS_KEY_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("sourceGraphId", SOURCE_GRAPH_ID_FIELD);
            this.put("snapshotCreateTime", SNAPSHOT_CREATE_TIME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String arn;
    private final String sourceGraphId;
    private final Instant snapshotCreateTime;
    private final String status;
    private final String kmsKeyIdentifier;

    private GraphSnapshotSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.sourceGraphId = builder.sourceGraphId;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.status = builder.status;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String sourceGraphId() {
        return this.sourceGraphId;
    }

    public final Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public final SnapshotStatus status() {
        return SnapshotStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceGraphId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphSnapshotSummary)) {
            return false;
        }
        GraphSnapshotSummary other = (GraphSnapshotSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.sourceGraphId(), other.sourceGraphId()) && Objects.equals(this.snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GraphSnapshotSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SourceGraphId", (Object)this.sourceGraphId()).add("SnapshotCreateTime", (Object)this.snapshotCreateTime()).add("Status", (Object)this.statusAsString()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "sourceGraphId": {
                return Optional.ofNullable(clazz.cast(this.sourceGraphId()));
            }
            case "snapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GraphSnapshotSummary, T> g) {
        return obj -> g.apply((GraphSnapshotSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String sourceGraphId;
        private Instant snapshotCreateTime;
        private String status;
        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphSnapshotSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.sourceGraphId(model.sourceGraphId);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.status(model.status);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSourceGraphId() {
            return this.sourceGraphId;
        }

        public final void setSourceGraphId(String sourceGraphId) {
            this.sourceGraphId = sourceGraphId;
        }

        @Override
        public final Builder sourceGraphId(String sourceGraphId) {
            this.sourceGraphId = sourceGraphId;
            return this;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public GraphSnapshotSummary build() {
            return new GraphSnapshotSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GraphSnapshotSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder sourceGraphId(String var1);

        public Builder snapshotCreateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(SnapshotStatus var1);

        public Builder kmsKeyIdentifier(String var1);
    }
}

