/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphAsyncClient;
import software.amazon.awssdk.services.neptunegraph.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.waiters.NeptuneGraphAsyncWaiter;
import software.amazon.awssdk.services.neptunegraph.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultNeptuneGraphAsyncWaiter
implements NeptuneGraphAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final NeptuneGraphAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetGraphResponse> graphAvailableWaiter;
    private final AsyncWaiter<GetGraphResponse> graphDeletedWaiter;
    private final AsyncWaiter<GetGraphSnapshotResponse> graphSnapshotAvailableWaiter;
    private final AsyncWaiter<GetGraphSnapshotResponse> graphSnapshotDeletedWaiter;
    private final AsyncWaiter<GetImportTaskResponse> importTaskCancelledWaiter;
    private final AsyncWaiter<GetImportTaskResponse> importTaskSuccessfulWaiter;
    private final AsyncWaiter<GetPrivateGraphEndpointResponse> privateGraphEndpointAvailableWaiter;
    private final AsyncWaiter<GetPrivateGraphEndpointResponse> privateGraphEndpointDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultNeptuneGraphAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (NeptuneGraphAsyncClient)NeptuneGraphAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.graphAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetGraphResponse.class).acceptors(DefaultNeptuneGraphAsyncWaiter.graphAvailableWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphAsyncWaiter.graphAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.graphDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetGraphResponse.class).acceptors(DefaultNeptuneGraphAsyncWaiter.graphDeletedWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphAsyncWaiter.graphDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.graphSnapshotAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetGraphSnapshotResponse.class).acceptors(DefaultNeptuneGraphAsyncWaiter.graphSnapshotAvailableWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphAsyncWaiter.graphSnapshotAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.graphSnapshotDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetGraphSnapshotResponse.class).acceptors(DefaultNeptuneGraphAsyncWaiter.graphSnapshotDeletedWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphAsyncWaiter.graphSnapshotDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.importTaskCancelledWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetImportTaskResponse.class).acceptors(DefaultNeptuneGraphAsyncWaiter.importTaskCancelledWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphAsyncWaiter.importTaskCancelledWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.importTaskSuccessfulWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetImportTaskResponse.class).acceptors(DefaultNeptuneGraphAsyncWaiter.importTaskSuccessfulWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphAsyncWaiter.importTaskSuccessfulWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.privateGraphEndpointAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetPrivateGraphEndpointResponse.class).acceptors(DefaultNeptuneGraphAsyncWaiter.privateGraphEndpointAvailableWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphAsyncWaiter.privateGraphEndpointAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.privateGraphEndpointDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetPrivateGraphEndpointResponse.class).acceptors(DefaultNeptuneGraphAsyncWaiter.privateGraphEndpointDeletedWaiterAcceptors())).overrideConfiguration(DefaultNeptuneGraphAsyncWaiter.privateGraphEndpointDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphAvailable(GetGraphRequest getGraphRequest) {
        return this.graphAvailableWaiter.runAsync(() -> this.client.getGraph(this.applyWaitersUserAgent(getGraphRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphAvailable(GetGraphRequest getGraphRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.graphAvailableWaiter.runAsync(() -> this.client.getGraph(this.applyWaitersUserAgent(getGraphRequest)), DefaultNeptuneGraphAsyncWaiter.graphAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphDeleted(GetGraphRequest getGraphRequest) {
        return this.graphDeletedWaiter.runAsync(() -> this.client.getGraph(this.applyWaitersUserAgent(getGraphRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphDeleted(GetGraphRequest getGraphRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.graphDeletedWaiter.runAsync(() -> this.client.getGraph(this.applyWaitersUserAgent(getGraphRequest)), DefaultNeptuneGraphAsyncWaiter.graphDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest getGraphSnapshotRequest) {
        return this.graphSnapshotAvailableWaiter.runAsync(() -> this.client.getGraphSnapshot(this.applyWaitersUserAgent(getGraphSnapshotRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest getGraphSnapshotRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.graphSnapshotAvailableWaiter.runAsync(() -> this.client.getGraphSnapshot(this.applyWaitersUserAgent(getGraphSnapshotRequest)), DefaultNeptuneGraphAsyncWaiter.graphSnapshotAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest getGraphSnapshotRequest) {
        return this.graphSnapshotDeletedWaiter.runAsync(() -> this.client.getGraphSnapshot(this.applyWaitersUserAgent(getGraphSnapshotRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest getGraphSnapshotRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.graphSnapshotDeletedWaiter.runAsync(() -> this.client.getGraphSnapshot(this.applyWaitersUserAgent(getGraphSnapshotRequest)), DefaultNeptuneGraphAsyncWaiter.graphSnapshotDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskCancelled(GetImportTaskRequest getImportTaskRequest) {
        return this.importTaskCancelledWaiter.runAsync(() -> this.client.getImportTask(this.applyWaitersUserAgent(getImportTaskRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskCancelled(GetImportTaskRequest getImportTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.importTaskCancelledWaiter.runAsync(() -> this.client.getImportTask(this.applyWaitersUserAgent(getImportTaskRequest)), DefaultNeptuneGraphAsyncWaiter.importTaskCancelledWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskSuccessful(GetImportTaskRequest getImportTaskRequest) {
        return this.importTaskSuccessfulWaiter.runAsync(() -> this.client.getImportTask(this.applyWaitersUserAgent(getImportTaskRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskSuccessful(GetImportTaskRequest getImportTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.importTaskSuccessfulWaiter.runAsync(() -> this.client.getImportTask(this.applyWaitersUserAgent(getImportTaskRequest)), DefaultNeptuneGraphAsyncWaiter.importTaskSuccessfulWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointAvailable(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        return this.privateGraphEndpointAvailableWaiter.runAsync(() -> this.client.getPrivateGraphEndpoint(this.applyWaitersUserAgent(getPrivateGraphEndpointRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointAvailable(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.privateGraphEndpointAvailableWaiter.runAsync(() -> this.client.getPrivateGraphEndpoint(this.applyWaitersUserAgent(getPrivateGraphEndpointRequest)), DefaultNeptuneGraphAsyncWaiter.privateGraphEndpointAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointDeleted(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        return this.privateGraphEndpointDeletedWaiter.runAsync(() -> this.client.getPrivateGraphEndpoint(this.applyWaitersUserAgent(getPrivateGraphEndpointRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointDeleted(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.privateGraphEndpointDeletedWaiter.runAsync(() -> this.client.getPrivateGraphEndpoint(this.applyWaitersUserAgent(getPrivateGraphEndpointRequest)), DefaultNeptuneGraphAsyncWaiter.privateGraphEndpointDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetGraphResponse>> graphAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetGraphResponse>> result = new ArrayList<WaiterAcceptor<? super GetGraphResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "AVAILABLE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetGraphResponse>> graphDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetGraphResponse>> result = new ArrayList<WaiterAcceptor<? super GetGraphResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").compare("!=", input.constant("DELETING")).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultNeptuneGraphAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetGraphSnapshotResponse>> graphSnapshotAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetGraphSnapshotResponse>> result = new ArrayList<WaiterAcceptor<? super GetGraphSnapshotResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "AVAILABLE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetGraphSnapshotResponse>> graphSnapshotDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetGraphSnapshotResponse>> result = new ArrayList<WaiterAcceptor<? super GetGraphSnapshotResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").compare("!=", input.constant("DELETING")).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultNeptuneGraphAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetImportTaskResponse>> importTaskCancelledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetImportTaskResponse>> result = new ArrayList<WaiterAcceptor<? super GetImportTaskResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").compare("!=", input.constant("CANCELLING")).and(input.field("status").compare("!=", input.constant("CANCELLED"))).value(), true);
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetImportTaskResponse>> importTaskSuccessfulWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetImportTaskResponse>> result = new ArrayList<WaiterAcceptor<? super GetImportTaskResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ROLLING_BACK");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUCCEEDED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>> privateGraphEndpointAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "AVAILABLE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>> privateGraphEndpointDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super GetPrivateGraphEndpointResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").compare("!=", input.constant("DELETING")).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultNeptuneGraphAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration graphAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(480);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration graphDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration graphSnapshotAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration graphSnapshotDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration importTaskCancelledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration importTaskSuccessfulWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(480);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration privateGraphEndpointAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration privateGraphEndpointDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static NeptuneGraphAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends NeptuneGraphRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NeptuneGraphRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements NeptuneGraphAsyncWaiter.Builder {
        private NeptuneGraphAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public NeptuneGraphAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public NeptuneGraphAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public NeptuneGraphAsyncWaiter.Builder client(NeptuneGraphAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public NeptuneGraphAsyncWaiter build() {
            return new DefaultNeptuneGraphAsyncWaiter(this);
        }
    }
}

