/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subject structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubjectStructure implements SdkPojo, Serializable,
        ToCopyableBuilder<SubjectStructure.Builder, SubjectStructure> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(SubjectStructure::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<List<String>> PREDICATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("predicates")
            .getter(getter(SubjectStructure::predicates))
            .setter(setter(Builder::predicates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COUNT_FIELD, PREDICATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long count;

    private final List<String> predicates;

    private SubjectStructure(BuilderImpl builder) {
        this.count = builder.count;
        this.predicates = builder.predicates;
    }

    /**
     * <p>
     * Number of occurrences of this specific structure.
     * </p>
     * 
     * @return Number of occurrences of this specific structure.
     */
    public final Long count() {
        return count;
    }

    /**
     * For responses, this returns true if the service returned a value for the Predicates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPredicates() {
        return predicates != null && !(predicates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of predicates present in this specific structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredicates} method.
     * </p>
     * 
     * @return A list of predicates present in this specific structure.
     */
    public final List<String> predicates() {
        return predicates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasPredicates() ? predicates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectStructure)) {
            return false;
        }
        SubjectStructure other = (SubjectStructure) obj;
        return Objects.equals(count(), other.count()) && hasPredicates() == other.hasPredicates()
                && Objects.equals(predicates(), other.predicates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubjectStructure").add("Count", count())
                .add("Predicates", hasPredicates() ? predicates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "predicates":
            return Optional.ofNullable(clazz.cast(predicates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("count", COUNT_FIELD);
        map.put("predicates", PREDICATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubjectStructure, T> g) {
        return obj -> g.apply((SubjectStructure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubjectStructure> {
        /**
         * <p>
         * Number of occurrences of this specific structure.
         * </p>
         * 
         * @param count
         *        Number of occurrences of this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * A list of predicates present in this specific structure.
         * </p>
         * 
         * @param predicates
         *        A list of predicates present in this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicates(Collection<String> predicates);

        /**
         * <p>
         * A list of predicates present in this specific structure.
         * </p>
         * 
         * @param predicates
         *        A list of predicates present in this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicates(String... predicates);
    }

    static final class BuilderImpl implements Builder {
        private Long count;

        private List<String> predicates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubjectStructure model) {
            count(model.count);
            predicates(model.predicates);
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getPredicates() {
            if (predicates instanceof SdkAutoConstructList) {
                return null;
            }
            return predicates;
        }

        public final void setPredicates(Collection<String> predicates) {
            this.predicates = PredicatesCopier.copy(predicates);
        }

        @Override
        public final Builder predicates(Collection<String> predicates) {
            this.predicates = PredicatesCopier.copy(predicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicates(String... predicates) {
            predicates(Arrays.asList(predicates));
            return this;
        }

        @Override
        public SubjectStructure build() {
            return new SubjectStructure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
