/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics for <code>REFRESH</code> mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshStatisticsIdMap implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshStatisticsIdMap.Builder, RefreshStatisticsIdMap> {
    private static final SdkField<String> STATISTICS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statisticsId").getter(getter(RefreshStatisticsIdMap::statisticsId))
            .setter(setter(Builder::statisticsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statisticsId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String statisticsId;

    private RefreshStatisticsIdMap(BuilderImpl builder) {
        this.statisticsId = builder.statisticsId;
    }

    /**
     * <p>
     * The ID of the statistics generation run that is currently occurring.
     * </p>
     * 
     * @return The ID of the statistics generation run that is currently occurring.
     */
    public final String statisticsId() {
        return statisticsId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statisticsId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshStatisticsIdMap)) {
            return false;
        }
        RefreshStatisticsIdMap other = (RefreshStatisticsIdMap) obj;
        return Objects.equals(statisticsId(), other.statisticsId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshStatisticsIdMap").add("StatisticsId", statisticsId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statisticsId":
            return Optional.ofNullable(clazz.cast(statisticsId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("statisticsId", STATISTICS_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshStatisticsIdMap, T> g) {
        return obj -> g.apply((RefreshStatisticsIdMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshStatisticsIdMap> {
        /**
         * <p>
         * The ID of the statistics generation run that is currently occurring.
         * </p>
         * 
         * @param statisticsId
         *        The ID of the statistics generation run that is currently occurring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsId(String statisticsId);
    }

    static final class BuilderImpl implements Builder {
        private String statisticsId;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshStatisticsIdMap model) {
            statisticsId(model.statisticsId);
        }

        public final String getStatisticsId() {
            return statisticsId;
        }

        public final void setStatisticsId(String statisticsId) {
            this.statisticsId = statisticsId;
        }

        @Override
        public final Builder statisticsId(String statisticsId) {
            this.statisticsId = statisticsId;
            return this;
        }

        @Override
        public RefreshStatisticsIdMap build() {
            return new RefreshStatisticsIdMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
