/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Captures the status of a Gremlin query (see the <a
 * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a>
 * page).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GremlinQueryStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<GremlinQueryStatus.Builder, GremlinQueryStatus> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryId").getter(getter(GremlinQueryStatus::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryId").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(GremlinQueryStatus::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<QueryEvalStats> QUERY_EVAL_STATS_FIELD = SdkField
            .<QueryEvalStats> builder(MarshallingType.SDK_POJO).memberName("queryEvalStats")
            .getter(getter(GremlinQueryStatus::queryEvalStats)).setter(setter(Builder::queryEvalStats))
            .constructor(QueryEvalStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryEvalStats").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_STRING_FIELD, QUERY_EVAL_STATS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queryId;

    private final String queryString;

    private final QueryEvalStats queryEvalStats;

    private GremlinQueryStatus(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryString = builder.queryString;
        this.queryEvalStats = builder.queryEvalStats;
    }

    /**
     * <p>
     * The ID of the Gremlin query.
     * </p>
     * 
     * @return The ID of the Gremlin query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The query string of the Gremlin query.
     * </p>
     * 
     * @return The query string of the Gremlin query.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The query statistics of the Gremlin query.
     * </p>
     * 
     * @return The query statistics of the Gremlin query.
     */
    public final QueryEvalStats queryEvalStats() {
        return queryEvalStats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(queryEvalStats());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GremlinQueryStatus)) {
            return false;
        }
        GremlinQueryStatus other = (GremlinQueryStatus) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(queryEvalStats(), other.queryEvalStats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GremlinQueryStatus").add("QueryId", queryId()).add("QueryString", queryString())
                .add("QueryEvalStats", queryEvalStats()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "queryEvalStats":
            return Optional.ofNullable(clazz.cast(queryEvalStats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryId", QUERY_ID_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("queryEvalStats", QUERY_EVAL_STATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GremlinQueryStatus, T> g) {
        return obj -> g.apply((GremlinQueryStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GremlinQueryStatus> {
        /**
         * <p>
         * The ID of the Gremlin query.
         * </p>
         * 
         * @param queryId
         *        The ID of the Gremlin query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The query string of the Gremlin query.
         * </p>
         * 
         * @param queryString
         *        The query string of the Gremlin query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The query statistics of the Gremlin query.
         * </p>
         * 
         * @param queryEvalStats
         *        The query statistics of the Gremlin query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryEvalStats(QueryEvalStats queryEvalStats);

        /**
         * <p>
         * The query statistics of the Gremlin query.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryEvalStats.Builder} avoiding the need
         * to create one manually via {@link QueryEvalStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryEvalStats.Builder#build()} is called immediately and its
         * result is passed to {@link #queryEvalStats(QueryEvalStats)}.
         * 
         * @param queryEvalStats
         *        a consumer that will call methods on {@link QueryEvalStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryEvalStats(QueryEvalStats)
         */
        default Builder queryEvalStats(Consumer<QueryEvalStats.Builder> queryEvalStats) {
            return queryEvalStats(QueryEvalStats.builder().applyMutation(queryEvalStats).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String queryId;

        private String queryString;

        private QueryEvalStats queryEvalStats;

        private BuilderImpl() {
        }

        private BuilderImpl(GremlinQueryStatus model) {
            queryId(model.queryId);
            queryString(model.queryString);
            queryEvalStats(model.queryEvalStats);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final QueryEvalStats.Builder getQueryEvalStats() {
            return queryEvalStats != null ? queryEvalStats.toBuilder() : null;
        }

        public final void setQueryEvalStats(QueryEvalStats.BuilderImpl queryEvalStats) {
            this.queryEvalStats = queryEvalStats != null ? queryEvalStats.build() : null;
        }

        @Override
        public final Builder queryEvalStats(QueryEvalStats queryEvalStats) {
            this.queryEvalStats = queryEvalStats;
            return this;
        }

        @Override
        public GremlinQueryStatus build() {
            return new GremlinQueryStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
