/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSparqlStreamResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetSparqlStreamResponse.Builder, GetSparqlStreamResponse> {
    private static final SdkField<Map<String, String>> LAST_EVENT_ID_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("lastEventId")
            .getter(getter(GetSparqlStreamResponse::lastEventId))
            .setter(setter(Builder::lastEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEventId").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> LAST_TRX_TIMESTAMP_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastTrxTimestampInMillis").getter(getter(GetSparqlStreamResponse::lastTrxTimestampInMillis))
            .setter(setter(Builder::lastTrxTimestampInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTrxTimestamp").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(GetSparqlStreamResponse::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<List<SparqlRecord>> RECORDS_FIELD = SdkField
            .<List<SparqlRecord>> builder(MarshallingType.LIST)
            .memberName("records")
            .getter(getter(GetSparqlStreamResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SparqlRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(SparqlRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalRecords").getter(getter(GetSparqlStreamResponse::totalRecords))
            .setter(setter(Builder::totalRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_EVENT_ID_FIELD,
            LAST_TRX_TIMESTAMP_IN_MILLIS_FIELD, FORMAT_FIELD, RECORDS_FIELD, TOTAL_RECORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, String> lastEventId;

    private final Long lastTrxTimestampInMillis;

    private final String format;

    private final List<SparqlRecord> records;

    private final Integer totalRecords;

    private GetSparqlStreamResponse(BuilderImpl builder) {
        super(builder);
        this.lastEventId = builder.lastEventId;
        this.lastTrxTimestampInMillis = builder.lastTrxTimestampInMillis;
        this.format = builder.format;
        this.records = builder.records;
        this.totalRecords = builder.totalRecords;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastEventId property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastEventId() {
        return lastEventId != null && !(lastEventId instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Sequence identifier of the last change in the stream response.
     * </p>
     * <p>
     * An event ID is composed of two fields: a <code>commitNum</code>, which identifies a transaction that changed the
     * graph, and an <code>opNum</code>, which identifies a specific operation within that transaction:
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastEventId} method.
     * </p>
     * 
     * @return Sequence identifier of the last change in the stream response.</p>
     *         <p>
     *         An event ID is composed of two fields: a <code>commitNum</code>, which identifies a transaction that
     *         changed the graph, and an <code>opNum</code>, which identifies a specific operation within that
     *         transaction:
     */
    public final Map<String, String> lastEventId() {
        return lastEventId;
    }

    /**
     * <p>
     * The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.
     * </p>
     * 
     * @return The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.
     */
    public final Long lastTrxTimestampInMillis() {
        return lastTrxTimestampInMillis;
    }

    /**
     * <p>
     * Serialization format for the change records being returned. Currently, the only supported value is
     * <code>NQUADS</code>.
     * </p>
     * 
     * @return Serialization format for the change records being returned. Currently, the only supported value is
     *         <code>NQUADS</code>.
     */
    public final String format() {
        return format;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of serialized change-log stream records included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return An array of serialized change-log stream records included in the response.
     */
    public final List<SparqlRecord> records() {
        return records;
    }

    /**
     * <p>
     * The total number of records in the response.
     * </p>
     * 
     * @return The total number of records in the response.
     */
    public final Integer totalRecords() {
        return totalRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLastEventId() ? lastEventId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastTrxTimestampInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSparqlStreamResponse)) {
            return false;
        }
        GetSparqlStreamResponse other = (GetSparqlStreamResponse) obj;
        return hasLastEventId() == other.hasLastEventId() && Objects.equals(lastEventId(), other.lastEventId())
                && Objects.equals(lastTrxTimestampInMillis(), other.lastTrxTimestampInMillis())
                && Objects.equals(format(), other.format()) && hasRecords() == other.hasRecords()
                && Objects.equals(records(), other.records()) && Objects.equals(totalRecords(), other.totalRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSparqlStreamResponse").add("LastEventId", hasLastEventId() ? lastEventId() : null)
                .add("LastTrxTimestampInMillis", lastTrxTimestampInMillis()).add("Format", format())
                .add("Records", hasRecords() ? records() : null).add("TotalRecords", totalRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastEventId":
            return Optional.ofNullable(clazz.cast(lastEventId()));
        case "lastTrxTimestampInMillis":
            return Optional.ofNullable(clazz.cast(lastTrxTimestampInMillis()));
        case "format":
            return Optional.ofNullable(clazz.cast(format()));
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        case "totalRecords":
            return Optional.ofNullable(clazz.cast(totalRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastEventId", LAST_EVENT_ID_FIELD);
        map.put("lastTrxTimestamp", LAST_TRX_TIMESTAMP_IN_MILLIS_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("records", RECORDS_FIELD);
        map.put("totalRecords", TOTAL_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSparqlStreamResponse, T> g) {
        return obj -> g.apply((GetSparqlStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSparqlStreamResponse> {
        /**
         * <p>
         * Sequence identifier of the last change in the stream response.
         * </p>
         * <p>
         * An event ID is composed of two fields: a <code>commitNum</code>, which identifies a transaction that changed
         * the graph, and an <code>opNum</code>, which identifies a specific operation within that transaction:
         * </p>
         * 
         * @param lastEventId
         *        Sequence identifier of the last change in the stream response.</p>
         *        <p>
         *        An event ID is composed of two fields: a <code>commitNum</code>, which identifies a transaction that
         *        changed the graph, and an <code>opNum</code>, which identifies a specific operation within that
         *        transaction:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEventId(Map<String, String> lastEventId);

        /**
         * <p>
         * The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.
         * </p>
         * 
         * @param lastTrxTimestampInMillis
         *        The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastTrxTimestampInMillis(Long lastTrxTimestampInMillis);

        /**
         * <p>
         * Serialization format for the change records being returned. Currently, the only supported value is
         * <code>NQUADS</code>.
         * </p>
         * 
         * @param format
         *        Serialization format for the change records being returned. Currently, the only supported value is
         *        <code>NQUADS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * An array of serialized change-log stream records included in the response.
         * </p>
         * 
         * @param records
         *        An array of serialized change-log stream records included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<SparqlRecord> records);

        /**
         * <p>
         * An array of serialized change-log stream records included in the response.
         * </p>
         * 
         * @param records
         *        An array of serialized change-log stream records included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(SparqlRecord... records);

        /**
         * <p>
         * An array of serialized change-log stream records included in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptunedata.model.SparqlRecord.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.neptunedata.model.SparqlRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptunedata.model.SparqlRecord.Builder#build()} is called immediately
         * and its result is passed to {@link #records(List<SparqlRecord>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptunedata.model.SparqlRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<SparqlRecord>)
         */
        Builder records(Consumer<SparqlRecord.Builder>... records);

        /**
         * <p>
         * The total number of records in the response.
         * </p>
         * 
         * @param totalRecords
         *        The total number of records in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecords(Integer totalRecords);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private Map<String, String> lastEventId = DefaultSdkAutoConstructMap.getInstance();

        private Long lastTrxTimestampInMillis;

        private String format;

        private List<SparqlRecord> records = DefaultSdkAutoConstructList.getInstance();

        private Integer totalRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSparqlStreamResponse model) {
            super(model);
            lastEventId(model.lastEventId);
            lastTrxTimestampInMillis(model.lastTrxTimestampInMillis);
            format(model.format);
            records(model.records);
            totalRecords(model.totalRecords);
        }

        public final Map<String, String> getLastEventId() {
            if (lastEventId instanceof SdkAutoConstructMap) {
                return null;
            }
            return lastEventId;
        }

        public final void setLastEventId(Map<String, String> lastEventId) {
            this.lastEventId = StringValuedMapCopier.copy(lastEventId);
        }

        @Override
        public final Builder lastEventId(Map<String, String> lastEventId) {
            this.lastEventId = StringValuedMapCopier.copy(lastEventId);
            return this;
        }

        public final Long getLastTrxTimestampInMillis() {
            return lastTrxTimestampInMillis;
        }

        public final void setLastTrxTimestampInMillis(Long lastTrxTimestampInMillis) {
            this.lastTrxTimestampInMillis = lastTrxTimestampInMillis;
        }

        @Override
        public final Builder lastTrxTimestampInMillis(Long lastTrxTimestampInMillis) {
            this.lastTrxTimestampInMillis = lastTrxTimestampInMillis;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final List<SparqlRecord.Builder> getRecords() {
            List<SparqlRecord.Builder> result = SparqlRecordsListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<SparqlRecord.BuilderImpl> records) {
            this.records = SparqlRecordsListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<SparqlRecord> records) {
            this.records = SparqlRecordsListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(SparqlRecord... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<SparqlRecord.Builder>... records) {
            records(Stream.of(records).map(c -> SparqlRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalRecords() {
            return totalRecords;
        }

        public final void setTotalRecords(Integer totalRecords) {
            this.totalRecords = totalRecords;
        }

        @Override
        public final Builder totalRecords(Integer totalRecords) {
            this.totalRecords = totalRecords;
            return this;
        }

        @Override
        public GetSparqlStreamResponse build() {
            return new GetSparqlStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
