/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteOpenCypherExplainQueryRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ExecuteOpenCypherExplainQueryRequest.Builder, ExecuteOpenCypherExplainQueryRequest> {
    private static final SdkField<String> OPEN_CYPHER_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("openCypherQuery").getter(getter(ExecuteOpenCypherExplainQueryRequest::openCypherQuery))
            .setter(setter(Builder::openCypherQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameters").getter(getter(ExecuteOpenCypherExplainQueryRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final SdkField<String> EXPLAIN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("explainMode").getter(getter(ExecuteOpenCypherExplainQueryRequest::explainModeAsString))
            .setter(setter(Builder::explainMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("explain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_CYPHER_QUERY_FIELD,
            PARAMETERS_FIELD, EXPLAIN_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String openCypherQuery;

    private final String parameters;

    private final String explainMode;

    private ExecuteOpenCypherExplainQueryRequest(BuilderImpl builder) {
        super(builder);
        this.openCypherQuery = builder.openCypherQuery;
        this.parameters = builder.parameters;
        this.explainMode = builder.explainMode;
    }

    /**
     * <p>
     * The openCypher query string.
     * </p>
     * 
     * @return The openCypher query string.
     */
    public final String openCypherQuery() {
        return openCypherQuery;
    }

    /**
     * <p>
     * The openCypher query parameters.
     * </p>
     * 
     * @return The openCypher query parameters.
     */
    public final String parameters() {
        return parameters;
    }

    /**
     * <p>
     * The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or
     * <code>details</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #explainMode} will
     * return {@link OpenCypherExplainMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #explainModeAsString}.
     * </p>
     * 
     * @return The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or
     *         <code>details</code>.
     * @see OpenCypherExplainMode
     */
    public final OpenCypherExplainMode explainMode() {
        return OpenCypherExplainMode.fromValue(explainMode);
    }

    /**
     * <p>
     * The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or
     * <code>details</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #explainMode} will
     * return {@link OpenCypherExplainMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #explainModeAsString}.
     * </p>
     * 
     * @return The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or
     *         <code>details</code>.
     * @see OpenCypherExplainMode
     */
    public final String explainModeAsString() {
        return explainMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(openCypherQuery());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(explainModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteOpenCypherExplainQueryRequest)) {
            return false;
        }
        ExecuteOpenCypherExplainQueryRequest other = (ExecuteOpenCypherExplainQueryRequest) obj;
        return Objects.equals(openCypherQuery(), other.openCypherQuery()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(explainModeAsString(), other.explainModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteOpenCypherExplainQueryRequest").add("OpenCypherQuery", openCypherQuery())
                .add("Parameters", parameters()).add("ExplainMode", explainModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "openCypherQuery":
            return Optional.ofNullable(clazz.cast(openCypherQuery()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "explainMode":
            return Optional.ofNullable(clazz.cast(explainModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("query", OPEN_CYPHER_QUERY_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("explain", EXPLAIN_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteOpenCypherExplainQueryRequest, T> g) {
        return obj -> g.apply((ExecuteOpenCypherExplainQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptunedataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExecuteOpenCypherExplainQueryRequest> {
        /**
         * <p>
         * The openCypher query string.
         * </p>
         * 
         * @param openCypherQuery
         *        The openCypher query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openCypherQuery(String openCypherQuery);

        /**
         * <p>
         * The openCypher query parameters.
         * </p>
         * 
         * @param parameters
         *        The openCypher query parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or
         * <code>details</code>.
         * </p>
         * 
         * @param explainMode
         *        The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or
         *        <code>details</code>.
         * @see OpenCypherExplainMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenCypherExplainMode
         */
        Builder explainMode(String explainMode);

        /**
         * <p>
         * The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or
         * <code>details</code>.
         * </p>
         * 
         * @param explainMode
         *        The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or
         *        <code>details</code>.
         * @see OpenCypherExplainMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenCypherExplainMode
         */
        Builder explainMode(OpenCypherExplainMode explainMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String openCypherQuery;

        private String parameters;

        private String explainMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteOpenCypherExplainQueryRequest model) {
            super(model);
            openCypherQuery(model.openCypherQuery);
            parameters(model.parameters);
            explainMode(model.explainMode);
        }

        public final String getOpenCypherQuery() {
            return openCypherQuery;
        }

        public final void setOpenCypherQuery(String openCypherQuery) {
            this.openCypherQuery = openCypherQuery;
        }

        @Override
        public final Builder openCypherQuery(String openCypherQuery) {
            this.openCypherQuery = openCypherQuery;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getExplainMode() {
            return explainMode;
        }

        public final void setExplainMode(String explainMode) {
            this.explainMode = explainMode;
        }

        @Override
        public final Builder explainMode(String explainMode) {
            this.explainMode = explainMode;
            return this;
        }

        @Override
        public final Builder explainMode(OpenCypherExplainMode explainMode) {
            this.explainMode(explainMode == null ? null : explainMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteOpenCypherExplainQueryRequest build() {
            return new ExecuteOpenCypherExplainQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
