/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains custom model transform parameters. See <a
 * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained model
 * to generate new model artifacts</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomModelTransformParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomModelTransformParameters.Builder, CustomModelTransformParameters> {
    private static final SdkField<String> SOURCE_S3_DIRECTORY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceS3DirectoryPath").getter(getter(CustomModelTransformParameters::sourceS3DirectoryPath))
            .setter(setter(Builder::sourceS3DirectoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3DirectoryPath").build())
            .build();

    private static final SdkField<String> TRANSFORM_ENTRY_POINT_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformEntryPointScript").getter(getter(CustomModelTransformParameters::transformEntryPointScript))
            .setter(setter(Builder::transformEntryPointScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformEntryPointScript").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_S3_DIRECTORY_PATH_FIELD, TRANSFORM_ENTRY_POINT_SCRIPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceS3DirectoryPath;

    private final String transformEntryPointScript;

    private CustomModelTransformParameters(BuilderImpl builder) {
        this.sourceS3DirectoryPath = builder.sourceS3DirectoryPath;
        this.transformEntryPointScript = builder.transformEntryPointScript;
    }

    /**
     * <p>
     * The path to the Amazon S3 location where the Python module implementing your model is located. This must point to
     * a valid existing Amazon S3 location that contains, at a minimum, a training script, a transform script, and a
     * <code>model-hpo-configuration.json</code> file.
     * </p>
     * 
     * @return The path to the Amazon S3 location where the Python module implementing your model is located. This must
     *         point to a valid existing Amazon S3 location that contains, at a minimum, a training script, a transform
     *         script, and a <code>model-hpo-configuration.json</code> file.
     */
    public final String sourceS3DirectoryPath() {
        return sourceS3DirectoryPath;
    }

    /**
     * <p>
     * The name of the entry point in your module of a script that should be run after the best model from the
     * hyperparameter search has been identified, to compute the model artifacts necessary for model deployment. It
     * should be able to run with no command-line arguments. The default is <code>transform.py</code>.
     * </p>
     * 
     * @return The name of the entry point in your module of a script that should be run after the best model from the
     *         hyperparameter search has been identified, to compute the model artifacts necessary for model deployment.
     *         It should be able to run with no command-line arguments. The default is <code>transform.py</code>.
     */
    public final String transformEntryPointScript() {
        return transformEntryPointScript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3DirectoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(transformEntryPointScript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelTransformParameters)) {
            return false;
        }
        CustomModelTransformParameters other = (CustomModelTransformParameters) obj;
        return Objects.equals(sourceS3DirectoryPath(), other.sourceS3DirectoryPath())
                && Objects.equals(transformEntryPointScript(), other.transformEntryPointScript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomModelTransformParameters").add("SourceS3DirectoryPath", sourceS3DirectoryPath())
                .add("TransformEntryPointScript", transformEntryPointScript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceS3DirectoryPath":
            return Optional.ofNullable(clazz.cast(sourceS3DirectoryPath()));
        case "transformEntryPointScript":
            return Optional.ofNullable(clazz.cast(transformEntryPointScript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceS3DirectoryPath", SOURCE_S3_DIRECTORY_PATH_FIELD);
        map.put("transformEntryPointScript", TRANSFORM_ENTRY_POINT_SCRIPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomModelTransformParameters, T> g) {
        return obj -> g.apply((CustomModelTransformParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomModelTransformParameters> {
        /**
         * <p>
         * The path to the Amazon S3 location where the Python module implementing your model is located. This must
         * point to a valid existing Amazon S3 location that contains, at a minimum, a training script, a transform
         * script, and a <code>model-hpo-configuration.json</code> file.
         * </p>
         * 
         * @param sourceS3DirectoryPath
         *        The path to the Amazon S3 location where the Python module implementing your model is located. This
         *        must point to a valid existing Amazon S3 location that contains, at a minimum, a training script, a
         *        transform script, and a <code>model-hpo-configuration.json</code> file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3DirectoryPath(String sourceS3DirectoryPath);

        /**
         * <p>
         * The name of the entry point in your module of a script that should be run after the best model from the
         * hyperparameter search has been identified, to compute the model artifacts necessary for model deployment. It
         * should be able to run with no command-line arguments. The default is <code>transform.py</code>.
         * </p>
         * 
         * @param transformEntryPointScript
         *        The name of the entry point in your module of a script that should be run after the best model from
         *        the hyperparameter search has been identified, to compute the model artifacts necessary for model
         *        deployment. It should be able to run with no command-line arguments. The default is
         *        <code>transform.py</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformEntryPointScript(String transformEntryPointScript);
    }

    static final class BuilderImpl implements Builder {
        private String sourceS3DirectoryPath;

        private String transformEntryPointScript;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomModelTransformParameters model) {
            sourceS3DirectoryPath(model.sourceS3DirectoryPath);
            transformEntryPointScript(model.transformEntryPointScript);
        }

        public final String getSourceS3DirectoryPath() {
            return sourceS3DirectoryPath;
        }

        public final void setSourceS3DirectoryPath(String sourceS3DirectoryPath) {
            this.sourceS3DirectoryPath = sourceS3DirectoryPath;
        }

        @Override
        public final Builder sourceS3DirectoryPath(String sourceS3DirectoryPath) {
            this.sourceS3DirectoryPath = sourceS3DirectoryPath;
            return this;
        }

        public final String getTransformEntryPointScript() {
            return transformEntryPointScript;
        }

        public final void setTransformEntryPointScript(String transformEntryPointScript) {
            this.transformEntryPointScript = transformEntryPointScript;
        }

        @Override
        public final Builder transformEntryPointScript(String transformEntryPointScript) {
            this.transformEntryPointScript = transformEntryPointScript;
            return this;
        }

        @Override
        public CustomModelTransformParameters build() {
            return new CustomModelTransformParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
