/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.PropertygraphSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertygraphSummaryValueMap
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertygraphSummaryValueMap> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(PropertygraphSummaryValueMap.getter(PropertygraphSummaryValueMap::version)).setter(PropertygraphSummaryValueMap.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> LAST_STATISTICS_COMPUTATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatisticsComputationTime").getter(PropertygraphSummaryValueMap.getter(PropertygraphSummaryValueMap::lastStatisticsComputationTime)).setter(PropertygraphSummaryValueMap.setter(Builder::lastStatisticsComputationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatisticsComputationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<PropertygraphSummary> GRAPH_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("graphSummary").getter(PropertygraphSummaryValueMap.getter(PropertygraphSummaryValueMap::graphSummary)).setter(PropertygraphSummaryValueMap.setter(Builder::graphSummary)).constructor(PropertygraphSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, LAST_STATISTICS_COMPUTATION_TIME_FIELD, GRAPH_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PropertygraphSummaryValueMap.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String version;
    private final Instant lastStatisticsComputationTime;
    private final PropertygraphSummary graphSummary;

    private PropertygraphSummaryValueMap(BuilderImpl builder) {
        this.version = builder.version;
        this.lastStatisticsComputationTime = builder.lastStatisticsComputationTime;
        this.graphSummary = builder.graphSummary;
    }

    public final String version() {
        return this.version;
    }

    public final Instant lastStatisticsComputationTime() {
        return this.lastStatisticsComputationTime;
    }

    public final PropertygraphSummary graphSummary() {
        return this.graphSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatisticsComputationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.graphSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertygraphSummaryValueMap)) {
            return false;
        }
        PropertygraphSummaryValueMap other = (PropertygraphSummaryValueMap)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.lastStatisticsComputationTime(), other.lastStatisticsComputationTime()) && Objects.equals(this.graphSummary(), other.graphSummary());
    }

    public final String toString() {
        return ToString.builder((String)"PropertygraphSummaryValueMap").add("Version", (Object)this.version()).add("LastStatisticsComputationTime", (Object)this.lastStatisticsComputationTime()).add("GraphSummary", (Object)this.graphSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "lastStatisticsComputationTime": {
                return Optional.ofNullable(clazz.cast(this.lastStatisticsComputationTime()));
            }
            case "graphSummary": {
                return Optional.ofNullable(clazz.cast(this.graphSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", VERSION_FIELD);
        map.put("lastStatisticsComputationTime", LAST_STATISTICS_COMPUTATION_TIME_FIELD);
        map.put("graphSummary", GRAPH_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertygraphSummaryValueMap, T> g) {
        return obj -> g.apply((PropertygraphSummaryValueMap)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private Instant lastStatisticsComputationTime;
        private PropertygraphSummary graphSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertygraphSummaryValueMap model) {
            this.version(model.version);
            this.lastStatisticsComputationTime(model.lastStatisticsComputationTime);
            this.graphSummary(model.graphSummary);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getLastStatisticsComputationTime() {
            return this.lastStatisticsComputationTime;
        }

        public final void setLastStatisticsComputationTime(Instant lastStatisticsComputationTime) {
            this.lastStatisticsComputationTime = lastStatisticsComputationTime;
        }

        @Override
        public final Builder lastStatisticsComputationTime(Instant lastStatisticsComputationTime) {
            this.lastStatisticsComputationTime = lastStatisticsComputationTime;
            return this;
        }

        public final PropertygraphSummary.Builder getGraphSummary() {
            return this.graphSummary != null ? this.graphSummary.toBuilder() : null;
        }

        public final void setGraphSummary(PropertygraphSummary.BuilderImpl graphSummary) {
            this.graphSummary = graphSummary != null ? graphSummary.build() : null;
        }

        @Override
        public final Builder graphSummary(PropertygraphSummary graphSummary) {
            this.graphSummary = graphSummary;
            return this;
        }

        public PropertygraphSummaryValueMap build() {
            return new PropertygraphSummaryValueMap(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertygraphSummaryValueMap> {
        public Builder version(String var1);

        public Builder lastStatisticsComputationTime(Instant var1);

        public Builder graphSummary(PropertygraphSummary var1);

        default public Builder graphSummary(Consumer<PropertygraphSummary.Builder> graphSummary) {
            return this.graphSummary((PropertygraphSummary)((PropertygraphSummary.Builder)PropertygraphSummary.builder().applyMutation(graphSummary)).build());
        }
    }
}

