/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Encoding {
    GZIP("gzip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Encoding> VALUE_MAP;
    private final String value;

    private Encoding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Encoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Encoding> knownValues() {
        EnumSet<Encoding> knownValues = EnumSet.allOf(Encoding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Encoding.class, Encoding::toString);
    }
}

