/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoaderIdResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoaderIdResult> {
    private static final SdkField<List<String>> LOAD_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loadIds").getter(LoaderIdResult.getter(LoaderIdResult::loadIds)).setter(LoaderIdResult.setter(Builder::loadIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("loadIds", LOAD_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> loadIds;

    private LoaderIdResult(BuilderImpl builder) {
        this.loadIds = builder.loadIds;
    }

    public final boolean hasLoadIds() {
        return this.loadIds != null && !(this.loadIds instanceof SdkAutoConstructList);
    }

    public final List<String> loadIds() {
        return this.loadIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadIds() ? this.loadIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoaderIdResult)) {
            return false;
        }
        LoaderIdResult other = (LoaderIdResult)obj;
        return this.hasLoadIds() == other.hasLoadIds() && Objects.equals(this.loadIds(), other.loadIds());
    }

    public final String toString() {
        return ToString.builder((String)"LoaderIdResult").add("LoadIds", this.hasLoadIds() ? this.loadIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadIds": {
                return Optional.ofNullable(clazz.cast(this.loadIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LoaderIdResult, T> g) {
        return obj -> g.apply((LoaderIdResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> loadIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoaderIdResult model) {
            this.loadIds(model.loadIds);
        }

        public final Collection<String> getLoadIds() {
            if (this.loadIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadIds;
        }

        public final void setLoadIds(Collection<String> loadIds) {
            this.loadIds = StringListCopier.copy(loadIds);
        }

        @Override
        public final Builder loadIds(Collection<String> loadIds) {
            this.loadIds = StringListCopier.copy(loadIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadIds(String ... loadIds) {
            this.loadIds(Arrays.asList(loadIds));
            return this;
        }

        public LoaderIdResult build() {
            return new LoaderIdResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoaderIdResult> {
        public Builder loadIds(Collection<String> var1);

        public Builder loadIds(String ... var1);
    }
}

