/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.services.neptunedata.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMlDataProcessingJobRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, StartMlDataProcessingJobRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::id)).setter(StartMlDataProcessingJobRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> PREVIOUS_DATA_PROCESSING_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("previousDataProcessingJobId").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::previousDataProcessingJobId)).setter(StartMlDataProcessingJobRequest.setter(Builder::previousDataProcessingJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousDataProcessingJobId").build()}).build();
    private static final SdkField<String> INPUT_DATA_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputDataS3Location").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::inputDataS3Location)).setter(StartMlDataProcessingJobRequest.setter(Builder::inputDataS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataS3Location").build()}).build();
    private static final SdkField<String> PROCESSED_DATA_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("processedDataS3Location").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::processedDataS3Location)).setter(StartMlDataProcessingJobRequest.setter(Builder::processedDataS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processedDataS3Location").build()}).build();
    private static final SdkField<String> SAGEMAKER_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sagemakerIamRoleArn").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::sagemakerIamRoleArn)).setter(StartMlDataProcessingJobRequest.setter(Builder::sagemakerIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sagemakerIamRoleArn").build()}).build();
    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("neptuneIamRoleArn").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::neptuneIamRoleArn)).setter(StartMlDataProcessingJobRequest.setter(Builder::neptuneIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptuneIamRoleArn").build()}).build();
    private static final SdkField<String> PROCESSING_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("processingInstanceType").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::processingInstanceType)).setter(StartMlDataProcessingJobRequest.setter(Builder::processingInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingInstanceType").build()}).build();
    private static final SdkField<Integer> PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("processingInstanceVolumeSizeInGB").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::processingInstanceVolumeSizeInGB)).setter(StartMlDataProcessingJobRequest.setter(Builder::processingInstanceVolumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingInstanceVolumeSizeInGB").build()}).build();
    private static final SdkField<Integer> PROCESSING_TIME_OUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("processingTimeOutInSeconds").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::processingTimeOutInSeconds)).setter(StartMlDataProcessingJobRequest.setter(Builder::processingTimeOutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingTimeOutInSeconds").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelType").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::modelType)).setter(StartMlDataProcessingJobRequest.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<String> CONFIG_FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configFileName").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::configFileName)).setter(StartMlDataProcessingJobRequest.setter(Builder::configFileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configFileName").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnets").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::subnets)).setter(StartMlDataProcessingJobRequest.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::securityGroupIds)).setter(StartMlDataProcessingJobRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_ENCRYPTION_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeEncryptionKMSKey").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::volumeEncryptionKMSKey)).setter(StartMlDataProcessingJobRequest.setter(Builder::volumeEncryptionKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeEncryptionKMSKey").build()}).build();
    private static final SdkField<String> S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3OutputEncryptionKMSKey").getter(StartMlDataProcessingJobRequest.getter(StartMlDataProcessingJobRequest::s3OutputEncryptionKMSKey)).setter(StartMlDataProcessingJobRequest.setter(Builder::s3OutputEncryptionKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputEncryptionKMSKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PREVIOUS_DATA_PROCESSING_JOB_ID_FIELD, INPUT_DATA_S3_LOCATION_FIELD, PROCESSED_DATA_S3_LOCATION_FIELD, SAGEMAKER_IAM_ROLE_ARN_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD, PROCESSING_INSTANCE_TYPE_FIELD, PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD, PROCESSING_TIME_OUT_IN_SECONDS_FIELD, MODEL_TYPE_FIELD, CONFIG_FILE_NAME_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD, VOLUME_ENCRYPTION_KMS_KEY_FIELD, S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD));
    private final String id;
    private final String previousDataProcessingJobId;
    private final String inputDataS3Location;
    private final String processedDataS3Location;
    private final String sagemakerIamRoleArn;
    private final String neptuneIamRoleArn;
    private final String processingInstanceType;
    private final Integer processingInstanceVolumeSizeInGB;
    private final Integer processingTimeOutInSeconds;
    private final String modelType;
    private final String configFileName;
    private final List<String> subnets;
    private final List<String> securityGroupIds;
    private final String volumeEncryptionKMSKey;
    private final String s3OutputEncryptionKMSKey;

    private StartMlDataProcessingJobRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.previousDataProcessingJobId = builder.previousDataProcessingJobId;
        this.inputDataS3Location = builder.inputDataS3Location;
        this.processedDataS3Location = builder.processedDataS3Location;
        this.sagemakerIamRoleArn = builder.sagemakerIamRoleArn;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.processingInstanceType = builder.processingInstanceType;
        this.processingInstanceVolumeSizeInGB = builder.processingInstanceVolumeSizeInGB;
        this.processingTimeOutInSeconds = builder.processingTimeOutInSeconds;
        this.modelType = builder.modelType;
        this.configFileName = builder.configFileName;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.volumeEncryptionKMSKey = builder.volumeEncryptionKMSKey;
        this.s3OutputEncryptionKMSKey = builder.s3OutputEncryptionKMSKey;
    }

    public final String id() {
        return this.id;
    }

    public final String previousDataProcessingJobId() {
        return this.previousDataProcessingJobId;
    }

    public final String inputDataS3Location() {
        return this.inputDataS3Location;
    }

    public final String processedDataS3Location() {
        return this.processedDataS3Location;
    }

    public final String sagemakerIamRoleArn() {
        return this.sagemakerIamRoleArn;
    }

    public final String neptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    public final String processingInstanceType() {
        return this.processingInstanceType;
    }

    public final Integer processingInstanceVolumeSizeInGB() {
        return this.processingInstanceVolumeSizeInGB;
    }

    public final Integer processingTimeOutInSeconds() {
        return this.processingTimeOutInSeconds;
    }

    public final String modelType() {
        return this.modelType;
    }

    public final String configFileName() {
        return this.configFileName;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String volumeEncryptionKMSKey() {
        return this.volumeEncryptionKMSKey;
    }

    public final String s3OutputEncryptionKMSKey() {
        return this.s3OutputEncryptionKMSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousDataProcessingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.processedDataS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sagemakerIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingInstanceVolumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingTimeOutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelType());
        hashCode = 31 * hashCode + Objects.hashCode(this.configFileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeEncryptionKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputEncryptionKMSKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlDataProcessingJobRequest)) {
            return false;
        }
        StartMlDataProcessingJobRequest other = (StartMlDataProcessingJobRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.previousDataProcessingJobId(), other.previousDataProcessingJobId()) && Objects.equals(this.inputDataS3Location(), other.inputDataS3Location()) && Objects.equals(this.processedDataS3Location(), other.processedDataS3Location()) && Objects.equals(this.sagemakerIamRoleArn(), other.sagemakerIamRoleArn()) && Objects.equals(this.neptuneIamRoleArn(), other.neptuneIamRoleArn()) && Objects.equals(this.processingInstanceType(), other.processingInstanceType()) && Objects.equals(this.processingInstanceVolumeSizeInGB(), other.processingInstanceVolumeSizeInGB()) && Objects.equals(this.processingTimeOutInSeconds(), other.processingTimeOutInSeconds()) && Objects.equals(this.modelType(), other.modelType()) && Objects.equals(this.configFileName(), other.configFileName()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.volumeEncryptionKMSKey(), other.volumeEncryptionKMSKey()) && Objects.equals(this.s3OutputEncryptionKMSKey(), other.s3OutputEncryptionKMSKey());
    }

    public final String toString() {
        return ToString.builder((String)"StartMlDataProcessingJobRequest").add("Id", (Object)this.id()).add("PreviousDataProcessingJobId", (Object)this.previousDataProcessingJobId()).add("InputDataS3Location", (Object)this.inputDataS3Location()).add("ProcessedDataS3Location", (Object)this.processedDataS3Location()).add("SagemakerIamRoleArn", (Object)this.sagemakerIamRoleArn()).add("NeptuneIamRoleArn", (Object)this.neptuneIamRoleArn()).add("ProcessingInstanceType", (Object)this.processingInstanceType()).add("ProcessingInstanceVolumeSizeInGB", (Object)this.processingInstanceVolumeSizeInGB()).add("ProcessingTimeOutInSeconds", (Object)this.processingTimeOutInSeconds()).add("ModelType", (Object)this.modelType()).add("ConfigFileName", (Object)this.configFileName()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("VolumeEncryptionKMSKey", (Object)this.volumeEncryptionKMSKey()).add("S3OutputEncryptionKMSKey", (Object)this.s3OutputEncryptionKMSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "previousDataProcessingJobId": {
                return Optional.ofNullable(clazz.cast(this.previousDataProcessingJobId()));
            }
            case "inputDataS3Location": {
                return Optional.ofNullable(clazz.cast(this.inputDataS3Location()));
            }
            case "processedDataS3Location": {
                return Optional.ofNullable(clazz.cast(this.processedDataS3Location()));
            }
            case "sagemakerIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sagemakerIamRoleArn()));
            }
            case "neptuneIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.neptuneIamRoleArn()));
            }
            case "processingInstanceType": {
                return Optional.ofNullable(clazz.cast(this.processingInstanceType()));
            }
            case "processingInstanceVolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.processingInstanceVolumeSizeInGB()));
            }
            case "processingTimeOutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.processingTimeOutInSeconds()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelType()));
            }
            case "configFileName": {
                return Optional.ofNullable(clazz.cast(this.configFileName()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "volumeEncryptionKMSKey": {
                return Optional.ofNullable(clazz.cast(this.volumeEncryptionKMSKey()));
            }
            case "s3OutputEncryptionKMSKey": {
                return Optional.ofNullable(clazz.cast(this.s3OutputEncryptionKMSKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMlDataProcessingJobRequest, T> g) {
        return obj -> g.apply((StartMlDataProcessingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String id;
        private String previousDataProcessingJobId;
        private String inputDataS3Location;
        private String processedDataS3Location;
        private String sagemakerIamRoleArn;
        private String neptuneIamRoleArn;
        private String processingInstanceType;
        private Integer processingInstanceVolumeSizeInGB;
        private Integer processingTimeOutInSeconds;
        private String modelType;
        private String configFileName;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String volumeEncryptionKMSKey;
        private String s3OutputEncryptionKMSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlDataProcessingJobRequest model) {
            super(model);
            this.id(model.id);
            this.previousDataProcessingJobId(model.previousDataProcessingJobId);
            this.inputDataS3Location(model.inputDataS3Location);
            this.processedDataS3Location(model.processedDataS3Location);
            this.sagemakerIamRoleArn(model.sagemakerIamRoleArn);
            this.neptuneIamRoleArn(model.neptuneIamRoleArn);
            this.processingInstanceType(model.processingInstanceType);
            this.processingInstanceVolumeSizeInGB(model.processingInstanceVolumeSizeInGB);
            this.processingTimeOutInSeconds(model.processingTimeOutInSeconds);
            this.modelType(model.modelType);
            this.configFileName(model.configFileName);
            this.subnets(model.subnets);
            this.securityGroupIds(model.securityGroupIds);
            this.volumeEncryptionKMSKey(model.volumeEncryptionKMSKey);
            this.s3OutputEncryptionKMSKey(model.s3OutputEncryptionKMSKey);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPreviousDataProcessingJobId() {
            return this.previousDataProcessingJobId;
        }

        public final void setPreviousDataProcessingJobId(String previousDataProcessingJobId) {
            this.previousDataProcessingJobId = previousDataProcessingJobId;
        }

        @Override
        public final Builder previousDataProcessingJobId(String previousDataProcessingJobId) {
            this.previousDataProcessingJobId = previousDataProcessingJobId;
            return this;
        }

        public final String getInputDataS3Location() {
            return this.inputDataS3Location;
        }

        public final void setInputDataS3Location(String inputDataS3Location) {
            this.inputDataS3Location = inputDataS3Location;
        }

        @Override
        public final Builder inputDataS3Location(String inputDataS3Location) {
            this.inputDataS3Location = inputDataS3Location;
            return this;
        }

        public final String getProcessedDataS3Location() {
            return this.processedDataS3Location;
        }

        public final void setProcessedDataS3Location(String processedDataS3Location) {
            this.processedDataS3Location = processedDataS3Location;
        }

        @Override
        public final Builder processedDataS3Location(String processedDataS3Location) {
            this.processedDataS3Location = processedDataS3Location;
            return this;
        }

        public final String getSagemakerIamRoleArn() {
            return this.sagemakerIamRoleArn;
        }

        public final void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
        }

        @Override
        public final Builder sagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return this.neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final String getProcessingInstanceType() {
            return this.processingInstanceType;
        }

        public final void setProcessingInstanceType(String processingInstanceType) {
            this.processingInstanceType = processingInstanceType;
        }

        @Override
        public final Builder processingInstanceType(String processingInstanceType) {
            this.processingInstanceType = processingInstanceType;
            return this;
        }

        public final Integer getProcessingInstanceVolumeSizeInGB() {
            return this.processingInstanceVolumeSizeInGB;
        }

        public final void setProcessingInstanceVolumeSizeInGB(Integer processingInstanceVolumeSizeInGB) {
            this.processingInstanceVolumeSizeInGB = processingInstanceVolumeSizeInGB;
        }

        @Override
        public final Builder processingInstanceVolumeSizeInGB(Integer processingInstanceVolumeSizeInGB) {
            this.processingInstanceVolumeSizeInGB = processingInstanceVolumeSizeInGB;
            return this;
        }

        public final Integer getProcessingTimeOutInSeconds() {
            return this.processingTimeOutInSeconds;
        }

        public final void setProcessingTimeOutInSeconds(Integer processingTimeOutInSeconds) {
            this.processingTimeOutInSeconds = processingTimeOutInSeconds;
        }

        @Override
        public final Builder processingTimeOutInSeconds(Integer processingTimeOutInSeconds) {
            this.processingTimeOutInSeconds = processingTimeOutInSeconds;
            return this;
        }

        public final String getModelType() {
            return this.modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        public final String getConfigFileName() {
            return this.configFileName;
        }

        public final void setConfigFileName(String configFileName) {
            this.configFileName = configFileName;
        }

        @Override
        public final Builder configFileName(String configFileName) {
            this.configFileName = configFileName;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVolumeEncryptionKMSKey() {
            return this.volumeEncryptionKMSKey;
        }

        public final void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
        }

        @Override
        public final Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
            return this;
        }

        public final String getS3OutputEncryptionKMSKey() {
            return this.s3OutputEncryptionKMSKey;
        }

        public final void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
        }

        @Override
        public final Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlDataProcessingJobRequest build() {
            return new StartMlDataProcessingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMlDataProcessingJobRequest> {
        public Builder id(String var1);

        public Builder previousDataProcessingJobId(String var1);

        public Builder inputDataS3Location(String var1);

        public Builder processedDataS3Location(String var1);

        public Builder sagemakerIamRoleArn(String var1);

        public Builder neptuneIamRoleArn(String var1);

        public Builder processingInstanceType(String var1);

        public Builder processingInstanceVolumeSizeInGB(Integer var1);

        public Builder processingTimeOutInSeconds(Integer var1);

        public Builder modelType(String var1);

        public Builder configFileName(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder volumeEncryptionKMSKey(String var1);

        public Builder s3OutputEncryptionKMSKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

