/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptune.model.NeptuneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGlobalClusterRequest
extends NeptuneRequest
implements ToCopyableBuilder<Builder, CreateGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalClusterIdentifier").getter(CreateGlobalClusterRequest.getter(CreateGlobalClusterRequest::globalClusterIdentifier)).setter(CreateGlobalClusterRequest.setter(Builder::globalClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBClusterIdentifier").getter(CreateGlobalClusterRequest.getter(CreateGlobalClusterRequest::sourceDBClusterIdentifier)).setter(CreateGlobalClusterRequest.setter(Builder::sourceDBClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateGlobalClusterRequest.getter(CreateGlobalClusterRequest::engine)).setter(CreateGlobalClusterRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateGlobalClusterRequest.getter(CreateGlobalClusterRequest::engineVersion)).setter(CreateGlobalClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(CreateGlobalClusterRequest.getter(CreateGlobalClusterRequest::deletionProtection)).setter(CreateGlobalClusterRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(CreateGlobalClusterRequest.getter(CreateGlobalClusterRequest::storageEncrypted)).setter(CreateGlobalClusterRequest.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_CLUSTER_IDENTIFIER_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, DELETION_PROTECTION_FIELD, STORAGE_ENCRYPTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GlobalClusterIdentifier", GLOBAL_CLUSTER_IDENTIFIER_FIELD);
            this.put("SourceDBClusterIdentifier", SOURCE_DB_CLUSTER_IDENTIFIER_FIELD);
            this.put("Engine", ENGINE_FIELD);
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("DeletionProtection", DELETION_PROTECTION_FIELD);
            this.put("StorageEncrypted", STORAGE_ENCRYPTED_FIELD);
        }
    });
    private final String globalClusterIdentifier;
    private final String sourceDBClusterIdentifier;
    private final String engine;
    private final String engineVersion;
    private final Boolean deletionProtection;
    private final Boolean storageEncrypted;

    private CreateGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.deletionProtection = builder.deletionProtection;
        this.storageEncrypted = builder.storageEncrypted;
    }

    public final String globalClusterIdentifier() {
        return this.globalClusterIdentifier;
    }

    public final String sourceDBClusterIdentifier() {
        return this.sourceDBClusterIdentifier;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalClusterRequest)) {
            return false;
        }
        CreateGlobalClusterRequest other = (CreateGlobalClusterRequest)((Object)obj);
        return Objects.equals(this.globalClusterIdentifier(), other.globalClusterIdentifier()) && Objects.equals(this.sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGlobalClusterRequest").add("GlobalClusterIdentifier", (Object)this.globalClusterIdentifier()).add("SourceDBClusterIdentifier", (Object)this.sourceDBClusterIdentifier()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DeletionProtection", (Object)this.deletionProtection()).add("StorageEncrypted", (Object)this.storageEncrypted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.globalClusterIdentifier()));
            }
            case "SourceDBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBClusterIdentifier()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalClusterRequest, T> g) {
        return obj -> g.apply((CreateGlobalClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneRequest.BuilderImpl
    implements Builder {
        private String globalClusterIdentifier;
        private String sourceDBClusterIdentifier;
        private String engine;
        private String engineVersion;
        private Boolean deletionProtection;
        private Boolean storageEncrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalClusterRequest model) {
            super(model);
            this.globalClusterIdentifier(model.globalClusterIdentifier);
            this.sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.deletionProtection(model.deletionProtection);
            this.storageEncrypted(model.storageEncrypted);
        }

        public final String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getSourceDBClusterIdentifier() {
            return this.sourceDBClusterIdentifier;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlobalClusterRequest build() {
            return new CreateGlobalClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGlobalClusterRequest> {
        public Builder globalClusterIdentifier(String var1);

        public Builder sourceDBClusterIdentifier(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder deletionProtection(Boolean var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

