/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.NeptuneResponse;
import software.amazon.awssdk.services.neptune.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbClusterEndpointResponse
extends NeptuneResponse
implements ToCopyableBuilder<Builder, ModifyDbClusterEndpointResponse> {
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterEndpointIdentifier").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::dbClusterEndpointIdentifier)).setter(ModifyDbClusterEndpointResponse.setter(Builder::dbClusterEndpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::dbClusterIdentifier)).setter(ModifyDbClusterEndpointResponse.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterEndpointResourceIdentifier").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::dbClusterEndpointResourceIdentifier)).setter(ModifyDbClusterEndpointResponse.setter(Builder::dbClusterEndpointResourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointResourceIdentifier").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::endpoint)).setter(ModifyDbClusterEndpointResponse.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::status)).setter(ModifyDbClusterEndpointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::endpointType)).setter(ModifyDbClusterEndpointResponse.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> CUSTOM_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomEndpointType").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::customEndpointType)).setter(ModifyDbClusterEndpointResponse.setter(Builder::customEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpointType").build()}).build();
    private static final SdkField<List<String>> STATIC_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StaticMembers").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::staticMembers)).setter(ModifyDbClusterEndpointResponse.setter(Builder::staticMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedMembers").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::excludedMembers)).setter(ModifyDbClusterEndpointResponse.setter(Builder::excludedMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterEndpointArn").getter(ModifyDbClusterEndpointResponse.getter(ModifyDbClusterEndpointResponse::dbClusterEndpointArn)).setter(ModifyDbClusterEndpointResponse.setter(Builder::dbClusterEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_ENDPOINT_RESOURCE_IDENTIFIER_FIELD, ENDPOINT_FIELD, STATUS_FIELD, ENDPOINT_TYPE_FIELD, CUSTOM_ENDPOINT_TYPE_FIELD, STATIC_MEMBERS_FIELD, EXCLUDED_MEMBERS_FIELD, DB_CLUSTER_ENDPOINT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBClusterEndpointIdentifier", DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD);
            this.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
            this.put("DBClusterEndpointResourceIdentifier", DB_CLUSTER_ENDPOINT_RESOURCE_IDENTIFIER_FIELD);
            this.put("Endpoint", ENDPOINT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("EndpointType", ENDPOINT_TYPE_FIELD);
            this.put("CustomEndpointType", CUSTOM_ENDPOINT_TYPE_FIELD);
            this.put("StaticMembers", STATIC_MEMBERS_FIELD);
            this.put("ExcludedMembers", EXCLUDED_MEMBERS_FIELD);
            this.put("DBClusterEndpointArn", DB_CLUSTER_ENDPOINT_ARN_FIELD);
        }
    });
    private final String dbClusterEndpointIdentifier;
    private final String dbClusterIdentifier;
    private final String dbClusterEndpointResourceIdentifier;
    private final String endpoint;
    private final String status;
    private final String endpointType;
    private final String customEndpointType;
    private final List<String> staticMembers;
    private final List<String> excludedMembers;
    private final String dbClusterEndpointArn;

    private ModifyDbClusterEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterEndpointIdentifier = builder.dbClusterEndpointIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterEndpointResourceIdentifier = builder.dbClusterEndpointResourceIdentifier;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
        this.endpointType = builder.endpointType;
        this.customEndpointType = builder.customEndpointType;
        this.staticMembers = builder.staticMembers;
        this.excludedMembers = builder.excludedMembers;
        this.dbClusterEndpointArn = builder.dbClusterEndpointArn;
    }

    public final String dbClusterEndpointIdentifier() {
        return this.dbClusterEndpointIdentifier;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String dbClusterEndpointResourceIdentifier() {
        return this.dbClusterEndpointResourceIdentifier;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String status() {
        return this.status;
    }

    public final String endpointType() {
        return this.endpointType;
    }

    public final String customEndpointType() {
        return this.customEndpointType;
    }

    public final boolean hasStaticMembers() {
        return this.staticMembers != null && !(this.staticMembers instanceof SdkAutoConstructList);
    }

    public final List<String> staticMembers() {
        return this.staticMembers;
    }

    public final boolean hasExcludedMembers() {
        return this.excludedMembers != null && !(this.excludedMembers instanceof SdkAutoConstructList);
    }

    public final List<String> excludedMembers() {
        return this.excludedMembers;
    }

    public final String dbClusterEndpointArn() {
        return this.dbClusterEndpointArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterEndpointResourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEndpointType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticMembers() ? this.staticMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedMembers() ? this.excludedMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterEndpointArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterEndpointResponse)) {
            return false;
        }
        ModifyDbClusterEndpointResponse other = (ModifyDbClusterEndpointResponse)((Object)obj);
        return Objects.equals(this.dbClusterEndpointIdentifier(), other.dbClusterEndpointIdentifier()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterEndpointResourceIdentifier(), other.dbClusterEndpointResourceIdentifier()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.endpointType(), other.endpointType()) && Objects.equals(this.customEndpointType(), other.customEndpointType()) && this.hasStaticMembers() == other.hasStaticMembers() && Objects.equals(this.staticMembers(), other.staticMembers()) && this.hasExcludedMembers() == other.hasExcludedMembers() && Objects.equals(this.excludedMembers(), other.excludedMembers()) && Objects.equals(this.dbClusterEndpointArn(), other.dbClusterEndpointArn());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbClusterEndpointResponse").add("DBClusterEndpointIdentifier", (Object)this.dbClusterEndpointIdentifier()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterEndpointResourceIdentifier", (Object)this.dbClusterEndpointResourceIdentifier()).add("Endpoint", (Object)this.endpoint()).add("Status", (Object)this.status()).add("EndpointType", (Object)this.endpointType()).add("CustomEndpointType", (Object)this.customEndpointType()).add("StaticMembers", this.hasStaticMembers() ? this.staticMembers() : null).add("ExcludedMembers", this.hasExcludedMembers() ? this.excludedMembers() : null).add("DBClusterEndpointArn", (Object)this.dbClusterEndpointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterEndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpointIdentifier()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterEndpointResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpointResourceIdentifier()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointType()));
            }
            case "CustomEndpointType": {
                return Optional.ofNullable(clazz.cast(this.customEndpointType()));
            }
            case "StaticMembers": {
                return Optional.ofNullable(clazz.cast(this.staticMembers()));
            }
            case "ExcludedMembers": {
                return Optional.ofNullable(clazz.cast(this.excludedMembers()));
            }
            case "DBClusterEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpointArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterEndpointResponse, T> g) {
        return obj -> g.apply((ModifyDbClusterEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneResponse.BuilderImpl
    implements Builder {
        private String dbClusterEndpointIdentifier;
        private String dbClusterIdentifier;
        private String dbClusterEndpointResourceIdentifier;
        private String endpoint;
        private String status;
        private String endpointType;
        private String customEndpointType;
        private List<String> staticMembers = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedMembers = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterEndpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterEndpointResponse model) {
            super(model);
            this.dbClusterEndpointIdentifier(model.dbClusterEndpointIdentifier);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterEndpointResourceIdentifier(model.dbClusterEndpointResourceIdentifier);
            this.endpoint(model.endpoint);
            this.status(model.status);
            this.endpointType(model.endpointType);
            this.customEndpointType(model.customEndpointType);
            this.staticMembers(model.staticMembers);
            this.excludedMembers(model.excludedMembers);
            this.dbClusterEndpointArn(model.dbClusterEndpointArn);
        }

        public final String getDbClusterEndpointIdentifier() {
            return this.dbClusterEndpointIdentifier;
        }

        public final void setDbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterEndpointResourceIdentifier() {
            return this.dbClusterEndpointResourceIdentifier;
        }

        public final void setDbClusterEndpointResourceIdentifier(String dbClusterEndpointResourceIdentifier) {
            this.dbClusterEndpointResourceIdentifier = dbClusterEndpointResourceIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointResourceIdentifier(String dbClusterEndpointResourceIdentifier) {
            this.dbClusterEndpointResourceIdentifier = dbClusterEndpointResourceIdentifier;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final String getCustomEndpointType() {
            return this.customEndpointType;
        }

        public final void setCustomEndpointType(String customEndpointType) {
            this.customEndpointType = customEndpointType;
        }

        @Override
        public final Builder customEndpointType(String customEndpointType) {
            this.customEndpointType = customEndpointType;
            return this;
        }

        public final Collection<String> getStaticMembers() {
            if (this.staticMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.staticMembers;
        }

        public final void setStaticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
        }

        @Override
        public final Builder staticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticMembers(String ... staticMembers) {
            this.staticMembers(Arrays.asList(staticMembers));
            return this;
        }

        public final Collection<String> getExcludedMembers() {
            if (this.excludedMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedMembers;
        }

        public final void setExcludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
        }

        @Override
        public final Builder excludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedMembers(String ... excludedMembers) {
            this.excludedMembers(Arrays.asList(excludedMembers));
            return this;
        }

        public final String getDbClusterEndpointArn() {
            return this.dbClusterEndpointArn;
        }

        public final void setDbClusterEndpointArn(String dbClusterEndpointArn) {
            this.dbClusterEndpointArn = dbClusterEndpointArn;
        }

        @Override
        public final Builder dbClusterEndpointArn(String dbClusterEndpointArn) {
            this.dbClusterEndpointArn = dbClusterEndpointArn;
            return this;
        }

        @Override
        public ModifyDbClusterEndpointResponse build() {
            return new ModifyDbClusterEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbClusterEndpointResponse> {
        public Builder dbClusterEndpointIdentifier(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterEndpointResourceIdentifier(String var1);

        public Builder endpoint(String var1);

        public Builder status(String var1);

        public Builder endpointType(String var1);

        public Builder customEndpointType(String var1);

        public Builder staticMembers(Collection<String> var1);

        public Builder staticMembers(String ... var1);

        public Builder excludedMembers(Collection<String> var1);

        public Builder excludedMembers(String ... var1);

        public Builder dbClusterEndpointArn(String var1);
    }
}

