/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.neptune.model.ClusterPendingModifiedValues;
import software.amazon.awssdk.services.neptune.model.DBClusterMember;
import software.amazon.awssdk.services.neptune.model.DBClusterMemberListCopier;
import software.amazon.awssdk.services.neptune.model.DBClusterOptionGroupMembershipsCopier;
import software.amazon.awssdk.services.neptune.model.DBClusterOptionGroupStatus;
import software.amazon.awssdk.services.neptune.model.DBClusterRole;
import software.amazon.awssdk.services.neptune.model.DBClusterRolesCopier;
import software.amazon.awssdk.services.neptune.model.LogTypeListCopier;
import software.amazon.awssdk.services.neptune.model.ReadReplicaIdentifierListCopier;
import software.amazon.awssdk.services.neptune.model.ServerlessV2ScalingConfigurationInfo;
import software.amazon.awssdk.services.neptune.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.neptune.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBCluster> {
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(DBCluster.getter(DBCluster::allocatedStorage)).setter(DBCluster.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(DBCluster.getter(DBCluster::availabilityZones)).setter(DBCluster.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(DBCluster.getter(DBCluster::backupRetentionPeriod)).setter(DBCluster.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CharacterSetName").getter(DBCluster.getter(DBCluster::characterSetName)).setter(DBCluster.setter(Builder::characterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(DBCluster.getter(DBCluster::databaseName)).setter(DBCluster.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(DBCluster.getter(DBCluster::dbClusterIdentifier)).setter(DBCluster.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroup").getter(DBCluster.getter(DBCluster::dbClusterParameterGroup)).setter(DBCluster.setter(Builder::dbClusterParameterGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroup").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroup").getter(DBCluster.getter(DBCluster::dbSubnetGroup)).setter(DBCluster.setter(Builder::dbSubnetGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBCluster.getter(DBCluster::status)).setter(DBCluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PercentProgress").getter(DBCluster.getter(DBCluster::percentProgress)).setter(DBCluster.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()}).build();
    private static final SdkField<Instant> EARLIEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EarliestRestorableTime").getter(DBCluster.getter(DBCluster::earliestRestorableTime)).setter(DBCluster.setter(Builder::earliestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestRestorableTime").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(DBCluster.getter(DBCluster::endpoint)).setter(DBCluster.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> READER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReaderEndpoint").getter(DBCluster.getter(DBCluster::readerEndpoint)).setter(DBCluster.setter(Builder::readerEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(DBCluster.getter(DBCluster::multiAZ)).setter(DBCluster.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBCluster.getter(DBCluster::engine)).setter(DBCluster.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBCluster.getter(DBCluster::engineVersion)).setter(DBCluster.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestRestorableTime").getter(DBCluster.getter(DBCluster::latestRestorableTime)).setter(DBCluster.setter(Builder::latestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(DBCluster.getter(DBCluster::port)).setter(DBCluster.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(DBCluster.getter(DBCluster::masterUsername)).setter(DBCluster.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<List<DBClusterOptionGroupStatus>> DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterOptionGroupMemberships").getter(DBCluster.getter(DBCluster::dbClusterOptionGroupMemberships)).setter(DBCluster.setter(Builder::dbClusterOptionGroupMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterOptionGroupMemberships").build(), ListTrait.builder().memberLocationName("DBClusterOptionGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterOptionGroupStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterOptionGroup").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(DBCluster.getter(DBCluster::preferredBackupWindow)).setter(DBCluster.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(DBCluster.getter(DBCluster::preferredMaintenanceWindow)).setter(DBCluster.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> REPLICATION_SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSourceIdentifier").getter(DBCluster.getter(DBCluster::replicationSourceIdentifier)).setter(DBCluster.setter(Builder::replicationSourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSourceIdentifier").build()}).build();
    private static final SdkField<List<String>> READ_REPLICA_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadReplicaIdentifiers").getter(DBCluster.getter(DBCluster::readReplicaIdentifiers)).setter(DBCluster.setter(Builder::readReplicaIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaIdentifiers").build(), ListTrait.builder().memberLocationName("ReadReplicaIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaIdentifier").build()}).build()).build()}).build();
    private static final SdkField<List<DBClusterMember>> DB_CLUSTER_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterMembers").getter(DBCluster.getter(DBCluster::dbClusterMembers)).setter(DBCluster.setter(Builder::dbClusterMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterMembers").build(), ListTrait.builder().memberLocationName("DBClusterMember").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterMember").build()}).build()).build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(DBCluster.getter(DBCluster::vpcSecurityGroups)).setter(DBCluster.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupMembership").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupMembership").build()}).build()).build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(DBCluster.getter(DBCluster::hostedZoneId)).setter(DBCluster.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(DBCluster.getter(DBCluster::storageEncrypted)).setter(DBCluster.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DBCluster.getter(DBCluster::kmsKeyId)).setter(DBCluster.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> DB_CLUSTER_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterResourceId").getter(DBCluster.getter(DBCluster::dbClusterResourceId)).setter(DBCluster.setter(Builder::dbClusterResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterResourceId").build()}).build();
    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterArn").getter(DBCluster.getter(DBCluster::dbClusterArn)).setter(DBCluster.setter(Builder::dbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()}).build();
    private static final SdkField<List<DBClusterRole>> ASSOCIATED_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedRoles").getter(DBCluster.getter(DBCluster::associatedRoles)).setter(DBCluster.setter(Builder::associatedRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(), ListTrait.builder().memberLocationName("DBClusterRole").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterRole").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IAMDatabaseAuthenticationEnabled").getter(DBCluster.getter(DBCluster::iamDatabaseAuthenticationEnabled)).setter(DBCluster.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<String> CLONE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloneGroupId").getter(DBCluster.getter(DBCluster::cloneGroupId)).setter(DBCluster.setter(Builder::cloneGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloneGroupId").build()}).build();
    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ClusterCreateTime").getter(DBCluster.getter(DBCluster::clusterCreateTime)).setter(DBCluster.setter(Builder::clusterCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(DBCluster.getter(DBCluster::copyTagsToSnapshot)).setter(DBCluster.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<List<String>> ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledCloudwatchLogsExports").getter(DBCluster.getter(DBCluster::enabledCloudwatchLogsExports)).setter(DBCluster.setter(Builder::enabledCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ClusterPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingModifiedValues").getter(DBCluster.getter(DBCluster::pendingModifiedValues)).setter(DBCluster.setter(Builder::pendingModifiedValues)).constructor(ClusterPendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(DBCluster.getter(DBCluster::deletionProtection)).setter(DBCluster.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Boolean> CROSS_ACCOUNT_CLONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrossAccountClone").getter(DBCluster.getter(DBCluster::crossAccountClone)).setter(DBCluster.setter(Builder::crossAccountClone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountClone").build()}).build();
    private static final SdkField<Instant> AUTOMATIC_RESTART_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AutomaticRestartTime").getter(DBCluster.getter(DBCluster::automaticRestartTime)).setter(DBCluster.setter(Builder::automaticRestartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticRestartTime").build()}).build();
    private static final SdkField<ServerlessV2ScalingConfigurationInfo> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessV2ScalingConfiguration").getter(DBCluster.getter(DBCluster::serverlessV2ScalingConfiguration)).setter(DBCluster.setter(Builder::serverlessV2ScalingConfiguration)).constructor(ServerlessV2ScalingConfigurationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration").build()}).build();
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalClusterIdentifier").getter(DBCluster.getter(DBCluster::globalClusterIdentifier)).setter(DBCluster.setter(Builder::globalClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build()}).build();
    private static final SdkField<Instant> IO_OPTIMIZED_NEXT_ALLOWED_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IOOptimizedNextAllowedModificationTime").getter(DBCluster.getter(DBCluster::ioOptimizedNextAllowedModificationTime)).setter(DBCluster.setter(Builder::ioOptimizedNextAllowedModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IOOptimizedNextAllowedModificationTime").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(DBCluster.getter(DBCluster::storageType)).setter(DBCluster.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_STORAGE_FIELD, AVAILABILITY_ZONES_FIELD, BACKUP_RETENTION_PERIOD_FIELD, CHARACTER_SET_NAME_FIELD, DATABASE_NAME_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_PARAMETER_GROUP_FIELD, DB_SUBNET_GROUP_FIELD, STATUS_FIELD, PERCENT_PROGRESS_FIELD, EARLIEST_RESTORABLE_TIME_FIELD, ENDPOINT_FIELD, READER_ENDPOINT_FIELD, MULTI_AZ_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, LATEST_RESTORABLE_TIME_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD, DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, REPLICATION_SOURCE_IDENTIFIER_FIELD, READ_REPLICA_IDENTIFIERS_FIELD, DB_CLUSTER_MEMBERS_FIELD, VPC_SECURITY_GROUPS_FIELD, HOSTED_ZONE_ID_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DB_CLUSTER_RESOURCE_ID_FIELD, DB_CLUSTER_ARN_FIELD, ASSOCIATED_ROLES_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, CLONE_GROUP_ID_FIELD, CLUSTER_CREATE_TIME_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD, PENDING_MODIFIED_VALUES_FIELD, DELETION_PROTECTION_FIELD, CROSS_ACCOUNT_CLONE_FIELD, AUTOMATIC_RESTART_TIME_FIELD, SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, GLOBAL_CLUSTER_IDENTIFIER_FIELD, IO_OPTIMIZED_NEXT_ALLOWED_MODIFICATION_TIME_FIELD, STORAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer allocatedStorage;
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String characterSetName;
    private final String databaseName;
    private final String dbClusterIdentifier;
    private final String dbClusterParameterGroup;
    private final String dbSubnetGroup;
    private final String status;
    private final String percentProgress;
    private final Instant earliestRestorableTime;
    private final String endpoint;
    private final String readerEndpoint;
    private final Boolean multiAZ;
    private final String engine;
    private final String engineVersion;
    private final Instant latestRestorableTime;
    private final Integer port;
    private final String masterUsername;
    private final List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final String replicationSourceIdentifier;
    private final List<String> readReplicaIdentifiers;
    private final List<DBClusterMember> dbClusterMembers;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final String hostedZoneId;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbClusterResourceId;
    private final String dbClusterArn;
    private final List<DBClusterRole> associatedRoles;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final String cloneGroupId;
    private final Instant clusterCreateTime;
    private final Boolean copyTagsToSnapshot;
    private final List<String> enabledCloudwatchLogsExports;
    private final ClusterPendingModifiedValues pendingModifiedValues;
    private final Boolean deletionProtection;
    private final Boolean crossAccountClone;
    private final Instant automaticRestartTime;
    private final ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration;
    private final String globalClusterIdentifier;
    private final Instant ioOptimizedNextAllowedModificationTime;
    private final String storageType;

    private DBCluster(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.status = builder.status;
        this.percentProgress = builder.percentProgress;
        this.earliestRestorableTime = builder.earliestRestorableTime;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.multiAZ = builder.multiAZ;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.dbClusterOptionGroupMemberships = builder.dbClusterOptionGroupMemberships;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.readReplicaIdentifiers = builder.readReplicaIdentifiers;
        this.dbClusterMembers = builder.dbClusterMembers;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.hostedZoneId = builder.hostedZoneId;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.dbClusterArn = builder.dbClusterArn;
        this.associatedRoles = builder.associatedRoles;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.cloneGroupId = builder.cloneGroupId;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.enabledCloudwatchLogsExports = builder.enabledCloudwatchLogsExports;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.deletionProtection = builder.deletionProtection;
        this.crossAccountClone = builder.crossAccountClone;
        this.automaticRestartTime = builder.automaticRestartTime;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.ioOptimizedNextAllowedModificationTime = builder.ioOptimizedNextAllowedModificationTime;
        this.storageType = builder.storageType;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String characterSetName() {
        return this.characterSetName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String dbClusterParameterGroup() {
        return this.dbClusterParameterGroup;
    }

    public final String dbSubnetGroup() {
        return this.dbSubnetGroup;
    }

    public final String status() {
        return this.status;
    }

    public final String percentProgress() {
        return this.percentProgress;
    }

    public final Instant earliestRestorableTime() {
        return this.earliestRestorableTime;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String readerEndpoint() {
        return this.readerEndpoint;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Instant latestRestorableTime() {
        return this.latestRestorableTime;
    }

    public final Integer port() {
        return this.port;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final boolean hasDbClusterOptionGroupMemberships() {
        return this.dbClusterOptionGroupMemberships != null && !(this.dbClusterOptionGroupMemberships instanceof SdkAutoConstructList);
    }

    public final List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships() {
        return this.dbClusterOptionGroupMemberships;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String replicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public final boolean hasReadReplicaIdentifiers() {
        return this.readReplicaIdentifiers != null && !(this.readReplicaIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> readReplicaIdentifiers() {
        return this.readReplicaIdentifiers;
    }

    public final boolean hasDbClusterMembers() {
        return this.dbClusterMembers != null && !(this.dbClusterMembers instanceof SdkAutoConstructList);
    }

    public final List<DBClusterMember> dbClusterMembers() {
        return this.dbClusterMembers;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String dbClusterResourceId() {
        return this.dbClusterResourceId;
    }

    public final String dbClusterArn() {
        return this.dbClusterArn;
    }

    public final boolean hasAssociatedRoles() {
        return this.associatedRoles != null && !(this.associatedRoles instanceof SdkAutoConstructList);
    }

    public final List<DBClusterRole> associatedRoles() {
        return this.associatedRoles;
    }

    public final Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public final String cloneGroupId() {
        return this.cloneGroupId;
    }

    public final Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final boolean hasEnabledCloudwatchLogsExports() {
        return this.enabledCloudwatchLogsExports != null && !(this.enabledCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enabledCloudwatchLogsExports() {
        return this.enabledCloudwatchLogsExports;
    }

    public final ClusterPendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Boolean crossAccountClone() {
        return this.crossAccountClone;
    }

    public final Instant automaticRestartTime() {
        return this.automaticRestartTime;
    }

    public final ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration() {
        return this.serverlessV2ScalingConfiguration;
    }

    public final String globalClusterIdentifier() {
        return this.globalClusterIdentifier;
    }

    public final Instant ioOptimizedNextAllowedModificationTime() {
        return this.ioOptimizedNextAllowedModificationTime;
    }

    public final String storageType() {
        return this.storageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterOptionGroupMemberships() ? this.dbClusterOptionGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadReplicaIdentifiers() ? this.readReplicaIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterMembers() ? this.dbClusterMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedRoles() ? this.associatedRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloneGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledCloudwatchLogsExports() ? this.enabledCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountClone());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticRestartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ioOptimizedNextAllowedModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster)obj;
        return Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterParameterGroup(), other.dbClusterParameterGroup()) && Objects.equals(this.dbSubnetGroup(), other.dbSubnetGroup()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.earliestRestorableTime(), other.earliestRestorableTime()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.readerEndpoint(), other.readerEndpoint()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.latestRestorableTime(), other.latestRestorableTime()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.masterUsername(), other.masterUsername()) && this.hasDbClusterOptionGroupMemberships() == other.hasDbClusterOptionGroupMemberships() && Objects.equals(this.dbClusterOptionGroupMemberships(), other.dbClusterOptionGroupMemberships()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.replicationSourceIdentifier(), other.replicationSourceIdentifier()) && this.hasReadReplicaIdentifiers() == other.hasReadReplicaIdentifiers() && Objects.equals(this.readReplicaIdentifiers(), other.readReplicaIdentifiers()) && this.hasDbClusterMembers() == other.hasDbClusterMembers() && Objects.equals(this.dbClusterMembers(), other.dbClusterMembers()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbClusterResourceId(), other.dbClusterResourceId()) && Objects.equals(this.dbClusterArn(), other.dbClusterArn()) && this.hasAssociatedRoles() == other.hasAssociatedRoles() && Objects.equals(this.associatedRoles(), other.associatedRoles()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && Objects.equals(this.cloneGroupId(), other.cloneGroupId()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && this.hasEnabledCloudwatchLogsExports() == other.hasEnabledCloudwatchLogsExports() && Objects.equals(this.enabledCloudwatchLogsExports(), other.enabledCloudwatchLogsExports()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.crossAccountClone(), other.crossAccountClone()) && Objects.equals(this.automaticRestartTime(), other.automaticRestartTime()) && Objects.equals(this.serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration()) && Objects.equals(this.globalClusterIdentifier(), other.globalClusterIdentifier()) && Objects.equals(this.ioOptimizedNextAllowedModificationTime(), other.ioOptimizedNextAllowedModificationTime()) && Objects.equals(this.storageType(), other.storageType());
    }

    public final String toString() {
        return ToString.builder((String)"DBCluster").add("AllocatedStorage", (Object)this.allocatedStorage()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("CharacterSetName", (Object)this.characterSetName()).add("DatabaseName", (Object)this.databaseName()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterParameterGroup", (Object)this.dbClusterParameterGroup()).add("DBSubnetGroup", (Object)this.dbSubnetGroup()).add("Status", (Object)this.status()).add("PercentProgress", (Object)this.percentProgress()).add("EarliestRestorableTime", (Object)this.earliestRestorableTime()).add("Endpoint", (Object)this.endpoint()).add("ReaderEndpoint", (Object)this.readerEndpoint()).add("MultiAZ", (Object)this.multiAZ()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("LatestRestorableTime", (Object)this.latestRestorableTime()).add("Port", (Object)this.port()).add("MasterUsername", (Object)this.masterUsername()).add("DBClusterOptionGroupMemberships", this.hasDbClusterOptionGroupMemberships() ? this.dbClusterOptionGroupMemberships() : null).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ReplicationSourceIdentifier", (Object)this.replicationSourceIdentifier()).add("ReadReplicaIdentifiers", this.hasReadReplicaIdentifiers() ? this.readReplicaIdentifiers() : null).add("DBClusterMembers", this.hasDbClusterMembers() ? this.dbClusterMembers() : null).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).add("HostedZoneId", (Object)this.hostedZoneId()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DbClusterResourceId", (Object)this.dbClusterResourceId()).add("DBClusterArn", (Object)this.dbClusterArn()).add("AssociatedRoles", this.hasAssociatedRoles() ? this.associatedRoles() : null).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("CloneGroupId", (Object)this.cloneGroupId()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("EnabledCloudwatchLogsExports", this.hasEnabledCloudwatchLogsExports() ? this.enabledCloudwatchLogsExports() : null).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("DeletionProtection", (Object)this.deletionProtection()).add("CrossAccountClone", (Object)this.crossAccountClone()).add("AutomaticRestartTime", (Object)this.automaticRestartTime()).add("ServerlessV2ScalingConfiguration", (Object)this.serverlessV2ScalingConfiguration()).add("GlobalClusterIdentifier", (Object)this.globalClusterIdentifier()).add("IOOptimizedNextAllowedModificationTime", (Object)this.ioOptimizedNextAllowedModificationTime()).add("StorageType", (Object)this.storageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "CharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.characterSetName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterParameterGroup": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroup()));
            }
            case "DBSubnetGroup": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroup()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "PercentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "EarliestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.earliestRestorableTime()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "ReaderEndpoint": {
                return Optional.ofNullable(clazz.cast(this.readerEndpoint()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "LatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.latestRestorableTime()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "DBClusterOptionGroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.dbClusterOptionGroupMemberships()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ReplicationSourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationSourceIdentifier()));
            }
            case "ReadReplicaIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.readReplicaIdentifiers()));
            }
            case "DBClusterMembers": {
                return Optional.ofNullable(clazz.cast(this.dbClusterMembers()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DbClusterResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbClusterResourceId()));
            }
            case "DBClusterArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterArn()));
            }
            case "AssociatedRoles": {
                return Optional.ofNullable(clazz.cast(this.associatedRoles()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "CloneGroupId": {
                return Optional.ofNullable(clazz.cast(this.cloneGroupId()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "EnabledCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enabledCloudwatchLogsExports()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "CrossAccountClone": {
                return Optional.ofNullable(clazz.cast(this.crossAccountClone()));
            }
            case "AutomaticRestartTime": {
                return Optional.ofNullable(clazz.cast(this.automaticRestartTime()));
            }
            case "ServerlessV2ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverlessV2ScalingConfiguration()));
            }
            case "GlobalClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.globalClusterIdentifier()));
            }
            case "IOOptimizedNextAllowedModificationTime": {
                return Optional.ofNullable(clazz.cast(this.ioOptimizedNextAllowedModificationTime()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBCluster, T> g) {
        return obj -> g.apply((DBCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer allocatedStorage;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Integer backupRetentionPeriod;
        private String characterSetName;
        private String databaseName;
        private String dbClusterIdentifier;
        private String dbClusterParameterGroup;
        private String dbSubnetGroup;
        private String status;
        private String percentProgress;
        private Instant earliestRestorableTime;
        private String endpoint;
        private String readerEndpoint;
        private Boolean multiAZ;
        private String engine;
        private String engineVersion;
        private Instant latestRestorableTime;
        private Integer port;
        private String masterUsername;
        private List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships = DefaultSdkAutoConstructList.getInstance();
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private String replicationSourceIdentifier;
        private List<String> readReplicaIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<DBClusterMember> dbClusterMembers = DefaultSdkAutoConstructList.getInstance();
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String hostedZoneId;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbClusterResourceId;
        private String dbClusterArn;
        private List<DBClusterRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();
        private Boolean iamDatabaseAuthenticationEnabled;
        private String cloneGroupId;
        private Instant clusterCreateTime;
        private Boolean copyTagsToSnapshot;
        private List<String> enabledCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private ClusterPendingModifiedValues pendingModifiedValues;
        private Boolean deletionProtection;
        private Boolean crossAccountClone;
        private Instant automaticRestartTime;
        private ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration;
        private String globalClusterIdentifier;
        private Instant ioOptimizedNextAllowedModificationTime;
        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(DBCluster model) {
            this.allocatedStorage(model.allocatedStorage);
            this.availabilityZones(model.availabilityZones);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.characterSetName(model.characterSetName);
            this.databaseName(model.databaseName);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterParameterGroup(model.dbClusterParameterGroup);
            this.dbSubnetGroup(model.dbSubnetGroup);
            this.status(model.status);
            this.percentProgress(model.percentProgress);
            this.earliestRestorableTime(model.earliestRestorableTime);
            this.endpoint(model.endpoint);
            this.readerEndpoint(model.readerEndpoint);
            this.multiAZ(model.multiAZ);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.latestRestorableTime(model.latestRestorableTime);
            this.port(model.port);
            this.masterUsername(model.masterUsername);
            this.dbClusterOptionGroupMemberships(model.dbClusterOptionGroupMemberships);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.replicationSourceIdentifier(model.replicationSourceIdentifier);
            this.readReplicaIdentifiers(model.readReplicaIdentifiers);
            this.dbClusterMembers(model.dbClusterMembers);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.hostedZoneId(model.hostedZoneId);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbClusterResourceId(model.dbClusterResourceId);
            this.dbClusterArn(model.dbClusterArn);
            this.associatedRoles(model.associatedRoles);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.cloneGroupId(model.cloneGroupId);
            this.clusterCreateTime(model.clusterCreateTime);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.enabledCloudwatchLogsExports(model.enabledCloudwatchLogsExports);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.deletionProtection(model.deletionProtection);
            this.crossAccountClone(model.crossAccountClone);
            this.automaticRestartTime(model.automaticRestartTime);
            this.serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            this.globalClusterIdentifier(model.globalClusterIdentifier);
            this.ioOptimizedNextAllowedModificationTime(model.ioOptimizedNextAllowedModificationTime);
            this.storageType(model.storageType);
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterParameterGroup() {
            return this.dbClusterParameterGroup;
        }

        public final void setDbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
        }

        @Override
        public final Builder dbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        public final String getDbSubnetGroup() {
            return this.dbSubnetGroup;
        }

        public final void setDbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        @Override
        public final Builder dbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final Instant getEarliestRestorableTime() {
            return this.earliestRestorableTime;
        }

        public final void setEarliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
        }

        @Override
        public final Builder earliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getReaderEndpoint() {
            return this.readerEndpoint;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Instant getLatestRestorableTime() {
            return this.latestRestorableTime;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final List<DBClusterOptionGroupStatus.Builder> getDbClusterOptionGroupMemberships() {
            List<DBClusterOptionGroupStatus.Builder> result = DBClusterOptionGroupMembershipsCopier.copyToBuilder(this.dbClusterOptionGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus.BuilderImpl> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copyFromBuilder(dbClusterOptionGroupMemberships);
        }

        @Override
        public final Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copy(dbClusterOptionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Arrays.asList(dbClusterOptionGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(Consumer<DBClusterOptionGroupStatus.Builder> ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Stream.of(dbClusterOptionGroupMemberships).map(c -> (DBClusterOptionGroupStatus)((DBClusterOptionGroupStatus.Builder)DBClusterOptionGroupStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final Collection<String> getReadReplicaIdentifiers() {
            if (this.readReplicaIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readReplicaIdentifiers;
        }

        public final void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
        }

        @Override
        public final Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaIdentifiers(String ... readReplicaIdentifiers) {
            this.readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
            return this;
        }

        public final List<DBClusterMember.Builder> getDbClusterMembers() {
            List<DBClusterMember.Builder> result = DBClusterMemberListCopier.copyToBuilder(this.dbClusterMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterMembers(Collection<DBClusterMember.BuilderImpl> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copyFromBuilder(dbClusterMembers);
        }

        @Override
        public final Builder dbClusterMembers(Collection<DBClusterMember> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copy(dbClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(DBClusterMember ... dbClusterMembers) {
            this.dbClusterMembers(Arrays.asList(dbClusterMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(Consumer<DBClusterMember.Builder> ... dbClusterMembers) {
            this.dbClusterMembers(Stream.of(dbClusterMembers).map(c -> (DBClusterMember)((DBClusterMember.Builder)DBClusterMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier.copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbClusterResourceId() {
            return this.dbClusterResourceId;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final String getDbClusterArn() {
            return this.dbClusterArn;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final List<DBClusterRole.Builder> getAssociatedRoles() {
            List<DBClusterRole.Builder> result = DBClusterRolesCopier.copyToBuilder(this.associatedRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedRoles(Collection<DBClusterRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copyFromBuilder(associatedRoles);
        }

        @Override
        public final Builder associatedRoles(Collection<DBClusterRole> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(DBClusterRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<DBClusterRole.Builder> ... associatedRoles) {
            this.associatedRoles(Stream.of(associatedRoles).map(c -> (DBClusterRole)((DBClusterRole.Builder)DBClusterRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final String getCloneGroupId() {
            return this.cloneGroupId;
        }

        public final void setCloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
        }

        @Override
        public final Builder cloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
            return this;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Collection<String> getEnabledCloudwatchLogsExports() {
            if (this.enabledCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledCloudwatchLogsExports;
        }

        public final void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
        }

        @Override
        public final Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudwatchLogsExports(String ... enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports(Arrays.asList(enabledCloudwatchLogsExports));
            return this;
        }

        public final ClusterPendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(ClusterPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(ClusterPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getCrossAccountClone() {
            return this.crossAccountClone;
        }

        public final void setCrossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
        }

        @Override
        public final Builder crossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
            return this;
        }

        public final Instant getAutomaticRestartTime() {
            return this.automaticRestartTime;
        }

        public final void setAutomaticRestartTime(Instant automaticRestartTime) {
            this.automaticRestartTime = automaticRestartTime;
        }

        @Override
        public final Builder automaticRestartTime(Instant automaticRestartTime) {
            this.automaticRestartTime = automaticRestartTime;
            return this;
        }

        public final ServerlessV2ScalingConfigurationInfo.Builder getServerlessV2ScalingConfiguration() {
            return this.serverlessV2ScalingConfiguration != null ? this.serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfo.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfo serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final Instant getIoOptimizedNextAllowedModificationTime() {
            return this.ioOptimizedNextAllowedModificationTime;
        }

        public final void setIoOptimizedNextAllowedModificationTime(Instant ioOptimizedNextAllowedModificationTime) {
            this.ioOptimizedNextAllowedModificationTime = ioOptimizedNextAllowedModificationTime;
        }

        @Override
        public final Builder ioOptimizedNextAllowedModificationTime(Instant ioOptimizedNextAllowedModificationTime) {
            this.ioOptimizedNextAllowedModificationTime = ioOptimizedNextAllowedModificationTime;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public DBCluster build() {
            return new DBCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBCluster> {
        public Builder allocatedStorage(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder characterSetName(String var1);

        public Builder databaseName(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterParameterGroup(String var1);

        public Builder dbSubnetGroup(String var1);

        public Builder status(String var1);

        public Builder percentProgress(String var1);

        public Builder earliestRestorableTime(Instant var1);

        public Builder endpoint(String var1);

        public Builder readerEndpoint(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder latestRestorableTime(Instant var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> var1);

        public Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... var1);

        public Builder dbClusterOptionGroupMemberships(Consumer<DBClusterOptionGroupStatus.Builder> ... var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder replicationSourceIdentifier(String var1);

        public Builder readReplicaIdentifiers(Collection<String> var1);

        public Builder readReplicaIdentifiers(String ... var1);

        public Builder dbClusterMembers(Collection<DBClusterMember> var1);

        public Builder dbClusterMembers(DBClusterMember ... var1);

        public Builder dbClusterMembers(Consumer<DBClusterMember.Builder> ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder hostedZoneId(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbClusterResourceId(String var1);

        public Builder dbClusterArn(String var1);

        public Builder associatedRoles(Collection<DBClusterRole> var1);

        public Builder associatedRoles(DBClusterRole ... var1);

        public Builder associatedRoles(Consumer<DBClusterRole.Builder> ... var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder cloneGroupId(String var1);

        public Builder clusterCreateTime(Instant var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder enabledCloudwatchLogsExports(Collection<String> var1);

        public Builder enabledCloudwatchLogsExports(String ... var1);

        public Builder pendingModifiedValues(ClusterPendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<ClusterPendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((ClusterPendingModifiedValues)((ClusterPendingModifiedValues.Builder)ClusterPendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder deletionProtection(Boolean var1);

        public Builder crossAccountClone(Boolean var1);

        public Builder automaticRestartTime(Instant var1);

        public Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationInfo var1);

        default public Builder serverlessV2ScalingConfiguration(Consumer<ServerlessV2ScalingConfigurationInfo.Builder> serverlessV2ScalingConfiguration) {
            return this.serverlessV2ScalingConfiguration((ServerlessV2ScalingConfigurationInfo)((ServerlessV2ScalingConfigurationInfo.Builder)ServerlessV2ScalingConfigurationInfo.builder().applyMutation(serverlessV2ScalingConfiguration)).build());
        }

        public Builder globalClusterIdentifier(String var1);

        public Builder ioOptimizedNextAllowedModificationTime(Instant var1);

        public Builder storageType(String var1);
    }
}

