/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.neptune.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.neptune.model.CertificateNotFoundException;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterEndpointAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterEndpointNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterEndpointQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.neptune.model.DomainNotFoundException;
import software.amazon.awssdk.services.neptune.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.neptune.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.neptune.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterEndpointStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.neptune.model.InvalidEventSubscriptionStateException;
import software.amazon.awssdk.services.neptune.model.InvalidRestoreException;
import software.amazon.awssdk.services.neptune.model.InvalidSubnetException;
import software.amazon.awssdk.services.neptune.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.neptune.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.NeptuneException;
import software.amazon.awssdk.services.neptune.model.NeptuneRequest;
import software.amazon.awssdk.services.neptune.model.OptionGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ProvisionedIopsNotAvailableInAzException;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResourceNotFoundException;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.neptune.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.neptune.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.neptune.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.neptune.model.SourceNotFoundException;
import software.amazon.awssdk.services.neptune.model.StartDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StartDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StopDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StopDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.neptune.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.neptune.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.neptune.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.neptune.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterEndpointsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParameterGroupsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParametersIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterSnapshotsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClustersIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribePendingMaintenanceActionsIterable;
import software.amazon.awssdk.services.neptune.transform.AddRoleToDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.AddSourceIdentifierToSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterEndpointsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeValidDbInstanceModificationsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.PromoteReadReplicaDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveRoleFromDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveSourceIdentifierFromSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ResetDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.StopDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.waiters.NeptuneWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultNeptuneClient
implements NeptuneClient {
    private static final Logger log = Logger.loggerFor(DefaultNeptuneClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNeptuneClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "rds";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddRoleToDbClusterResponse addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest) throws DbClusterNotFoundException, DbClusterRoleAlreadyExistsException, InvalidDbClusterStateException, DbClusterRoleQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddRoleToDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, addRoleToDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddRoleToDBCluster");
            AddRoleToDbClusterResponse addRoleToDbClusterResponse = (AddRoleToDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddRoleToDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addRoleToDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddRoleToDbClusterRequestMarshaller(this.protocolFactory)));
            return addRoleToDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$addRoleToDBCluster$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddSourceIdentifierToSubscriptionResponse addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddSourceIdentifierToSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, addSourceIdentifierToSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddSourceIdentifierToSubscription");
            AddSourceIdentifierToSubscriptionResponse addSourceIdentifierToSubscriptionResponse = (AddSourceIdentifierToSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddSourceIdentifierToSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addSourceIdentifierToSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddSourceIdentifierToSubscriptionRequestMarshaller(this.protocolFactory)));
            return addSourceIdentifierToSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$addSourceIdentifierToSubscription$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsToResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            AddTagsToResourceResponse addTagsToResourceResponse = (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)));
            return addTagsToResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$addTagsToResource$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplyPendingMaintenanceAction");
            ApplyPendingMaintenanceActionResponse applyPendingMaintenanceActionResponse = (ApplyPendingMaintenanceActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyPendingMaintenanceAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applyPendingMaintenanceActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ApplyPendingMaintenanceActionRequestMarshaller(this.protocolFactory)));
            return applyPendingMaintenanceActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$applyPendingMaintenanceAction$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException, DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, copyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBClusterParameterGroup");
            CopyDbClusterParameterGroupResponse copyDbClusterParameterGroupResponse = (CopyDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return copyDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$copyDBClusterParameterGroup$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyDbClusterSnapshotResponse copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException, InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, copyDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBClusterSnapshot");
            CopyDbClusterSnapshotResponse copyDbClusterSnapshotResponse = (CopyDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
            return copyDbClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$copyDBClusterSnapshot$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyDbParameterGroupResponse copyDBParameterGroup(CopyDbParameterGroupRequest copyDbParameterGroupRequest) throws DbParameterGroupNotFoundException, DbParameterGroupAlreadyExistsException, DbParameterGroupQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, copyDbParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBParameterGroup");
            CopyDbParameterGroupResponse copyDbParameterGroupResponse = (CopyDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyDbParameterGroupRequestMarshaller(this.protocolFactory)));
            return copyDbParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$copyDBParameterGroup$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbClusterResponse createDBCluster(CreateDbClusterRequest createDbClusterRequest) throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException, InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException, DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBCluster");
            CreateDbClusterResponse createDbClusterResponse = (CreateDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbClusterRequestMarshaller(this.protocolFactory)));
            return createDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$createDBCluster$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbClusterEndpointResponse createDBClusterEndpoint(CreateDbClusterEndpointRequest createDbClusterEndpointRequest) throws DbClusterEndpointQuotaExceededException, DbClusterEndpointAlreadyExistsException, DbClusterNotFoundException, InvalidDbClusterStateException, DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterEndpointResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterEndpoint");
            CreateDbClusterEndpointResponse createDbClusterEndpointResponse = (CreateDbClusterEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbClusterEndpointRequestMarshaller(this.protocolFactory)));
            return createDbClusterEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$createDBClusterEndpoint$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterParameterGroup");
            CreateDbClusterParameterGroupResponse createDbClusterParameterGroupResponse = (CreateDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return createDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$createDBClusterParameterGroup$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbClusterSnapshotResponse createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException, SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterSnapshot");
            CreateDbClusterSnapshotResponse createDbClusterSnapshotResponse = (CreateDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
            return createDbClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$createDBClusterSnapshot$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbInstanceResponse createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException, DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException, InvalidSubnetException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException, DbClusterNotFoundException, StorageTypeNotSupportedException, AuthorizationNotFoundException, KmsKeyNotAccessibleException, DomainNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, createDbInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBInstance");
            CreateDbInstanceResponse createDbInstanceResponse = (CreateDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbInstanceRequestMarshaller(this.protocolFactory)));
            return createDbInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$createDBInstance$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbParameterGroupResponse createDBParameterGroup(CreateDbParameterGroupRequest createDbParameterGroupRequest) throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, createDbParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBParameterGroup");
            CreateDbParameterGroupResponse createDbParameterGroupResponse = (CreateDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbParameterGroupRequestMarshaller(this.protocolFactory)));
            return createDbParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$createDBParameterGroup$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbSubnetGroupResponse createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest) throws DbSubnetGroupAlreadyExistsException, DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, createDbSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBSubnetGroup");
            CreateDbSubnetGroupResponse createDbSubnetGroupResponse = (CreateDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbSubnetGroupRequestMarshaller(this.protocolFactory)));
            return createDbSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$createDBSubnetGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException, SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, createEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventSubscription");
            CreateEventSubscriptionResponse createEventSubscriptionResponse = (CreateEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventSubscriptionRequestMarshaller(this.protocolFactory)));
            return createEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$createEventSubscription$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbClusterResponse deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException, SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBCluster");
            DeleteDbClusterResponse deleteDbClusterResponse = (DeleteDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbClusterRequestMarshaller(this.protocolFactory)));
            return deleteDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$deleteDBCluster$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbClusterEndpointResponse deleteDBClusterEndpoint(DeleteDbClusterEndpointRequest deleteDbClusterEndpointRequest) throws InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterEndpointResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterEndpoint");
            DeleteDbClusterEndpointResponse deleteDbClusterEndpointResponse = (DeleteDbClusterEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbClusterEndpointRequestMarshaller(this.protocolFactory)));
            return deleteDbClusterEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$deleteDBClusterEndpoint$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbClusterParameterGroupResponse deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterParameterGroup");
            DeleteDbClusterParameterGroupResponse deleteDbClusterParameterGroupResponse = (DeleteDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return deleteDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$deleteDBClusterParameterGroup$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterSnapshot");
            DeleteDbClusterSnapshotResponse deleteDbClusterSnapshotResponse = (DeleteDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
            return deleteDbClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$deleteDBClusterSnapshot$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbInstanceResponse deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException, SnapshotQuotaExceededException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, deleteDbInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBInstance");
            DeleteDbInstanceResponse deleteDbInstanceResponse = (DeleteDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbInstanceRequestMarshaller(this.protocolFactory)));
            return deleteDbInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$deleteDBInstance$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbParameterGroupResponse deleteDBParameterGroup(DeleteDbParameterGroupRequest deleteDbParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, deleteDbParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBParameterGroup");
            DeleteDbParameterGroupResponse deleteDbParameterGroupResponse = (DeleteDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbParameterGroupRequestMarshaller(this.protocolFactory)));
            return deleteDbParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$deleteDBParameterGroup$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbSubnetGroupResponse deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) throws InvalidDbSubnetGroupStateException, InvalidDbSubnetStateException, DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, deleteDbSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBSubnetGroup");
            DeleteDbSubnetGroupResponse deleteDbSubnetGroupResponse = (DeleteDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbSubnetGroupRequestMarshaller(this.protocolFactory)));
            return deleteDbSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$deleteDBSubnetGroup$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) throws SubscriptionNotFoundException, InvalidEventSubscriptionStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, deleteEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventSubscription");
            DeleteEventSubscriptionResponse deleteEventSubscriptionResponse = (DeleteEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventSubscriptionRequestMarshaller(this.protocolFactory)));
            return deleteEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$deleteEventSubscription$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterEndpointsResponse describeDBClusterEndpoints(DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterEndpointsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterEndpoints");
            DescribeDbClusterEndpointsResponse describeDbClusterEndpointsResponse = (DescribeDbClusterEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterEndpointsRequestMarshaller(this.protocolFactory)));
            return describeDbClusterEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBClusterEndpoints$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClusterEndpointsIterable describeDBClusterEndpointsPaginator(DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBClusterEndpointsIterable(this, this.applyPaginatorUserAgent(describeDbClusterEndpointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterParameterGroups");
            DescribeDbClusterParameterGroupsResponse describeDbClusterParameterGroupsResponse = (DescribeDbClusterParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameterGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterParameterGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterParameterGroupsRequestMarshaller(this.protocolFactory)));
            return describeDbClusterParameterGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBClusterParameterGroups$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClusterParameterGroupsIterable describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBClusterParameterGroupsIterable(this, this.applyPaginatorUserAgent(describeDbClusterParameterGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterParametersResponse describeDBClusterParameters(DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterParameters");
            DescribeDbClusterParametersResponse describeDbClusterParametersResponse = (DescribeDbClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterParametersRequestMarshaller(this.protocolFactory)));
            return describeDbClusterParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBClusterParameters$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClusterParametersIterable describeDBClusterParametersPaginator(DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBClusterParametersIterable(this, this.applyPaginatorUserAgent(describeDbClusterParametersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterSnapshotAttributes");
            DescribeDbClusterSnapshotAttributesResponse describeDbClusterSnapshotAttributesResponse = (DescribeDbClusterSnapshotAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshotAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterSnapshotAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterSnapshotAttributesRequestMarshaller(this.protocolFactory)));
            return describeDbClusterSnapshotAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBClusterSnapshotAttributes$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterSnapshots");
            DescribeDbClusterSnapshotsResponse describeDbClusterSnapshotsResponse = (DescribeDbClusterSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterSnapshotsRequestMarshaller(this.protocolFactory)));
            return describeDbClusterSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBClusterSnapshots$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClusterSnapshotsIterable describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBClusterSnapshotsIterable(this, this.applyPaginatorUserAgent(describeDbClusterSnapshotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClustersResponse describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClustersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusters");
            DescribeDbClustersResponse describeDbClustersResponse = (DescribeDbClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClustersRequestMarshaller(this.protocolFactory)));
            return describeDbClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBClusters$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClustersIterable describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBClustersIterable(this, this.applyPaginatorUserAgent(describeDbClustersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbEngineVersionsResponse describeDBEngineVersions(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbEngineVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbEngineVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBEngineVersions");
            DescribeDbEngineVersionsResponse describeDbEngineVersionsResponse = (DescribeDbEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBEngineVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbEngineVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbEngineVersionsRequestMarshaller(this.protocolFactory)));
            return describeDbEngineVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBEngineVersions$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBEngineVersionsIterable(this, this.applyPaginatorUserAgent(describeDbEngineVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbInstancesResponse describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest) throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBInstances");
            DescribeDbInstancesResponse describeDbInstancesResponse = (DescribeDbInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbInstancesRequestMarshaller(this.protocolFactory)));
            return describeDbInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBInstances$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBInstancesIterable describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBInstancesIterable(this, this.applyPaginatorUserAgent(describeDbInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbParameterGroupsResponse describeDBParameterGroups(DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbParameterGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBParameterGroups");
            DescribeDbParameterGroupsResponse describeDbParameterGroupsResponse = (DescribeDbParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBParameterGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbParameterGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbParameterGroupsRequestMarshaller(this.protocolFactory)));
            return describeDbParameterGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBParameterGroups$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBParameterGroupsIterable describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBParameterGroupsIterable(this, this.applyPaginatorUserAgent(describeDbParameterGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbParametersResponse describeDBParameters(DescribeDbParametersRequest describeDbParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBParameters");
            DescribeDbParametersResponse describeDbParametersResponse = (DescribeDbParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbParametersRequestMarshaller(this.protocolFactory)));
            return describeDbParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBParameters$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBParametersIterable describeDBParametersPaginator(DescribeDbParametersRequest describeDbParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBParametersIterable(this, this.applyPaginatorUserAgent(describeDbParametersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbSubnetGroupsResponse describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbSubnetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeDbSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBSubnetGroups");
            DescribeDbSubnetGroupsResponse describeDbSubnetGroupsResponse = (DescribeDbSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBSubnetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbSubnetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbSubnetGroupsRequestMarshaller(this.protocolFactory)));
            return describeDbSubnetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeDBSubnetGroups$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBSubnetGroupsIterable(this, this.applyPaginatorUserAgent(describeDbSubnetGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineDefaultClusterParameters");
            DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParametersResponse = (DescribeEngineDefaultClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEngineDefaultClusterParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEngineDefaultClusterParametersRequestMarshaller(this.protocolFactory)));
            return describeEngineDefaultClusterParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeEngineDefaultClusterParameters$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEngineDefaultParametersResponse describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeEngineDefaultParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineDefaultParameters");
            DescribeEngineDefaultParametersResponse describeEngineDefaultParametersResponse = (DescribeEngineDefaultParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEngineDefaultParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEngineDefaultParametersRequestMarshaller(this.protocolFactory)));
            return describeEngineDefaultParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeEngineDefaultParameters$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEngineDefaultParametersIterable describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeEngineDefaultParametersIterable(this, this.applyPaginatorUserAgent(describeEngineDefaultParametersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeEventCategoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventCategories");
            DescribeEventCategoriesResponse describeEventCategoriesResponse = (DescribeEventCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventCategoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)));
            return describeEventCategoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeEventCategories$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventSubscriptionsResponse describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventSubscriptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeEventSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSubscriptions");
            DescribeEventSubscriptionsResponse describeEventSubscriptionsResponse = (DescribeEventSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventSubscriptionsRequestMarshaller(this.protocolFactory)));
            return describeEventSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeEventSubscriptions$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeEventSubscriptionsIterable(this, this.applyPaginatorUserAgent(describeEventSubscriptionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            DescribeEventsResponse describeEventsResponse = (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
            return describeEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeEvents$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrderableDBInstanceOptions");
            DescribeOrderableDbInstanceOptionsResponse describeOrderableDbInstanceOptionsResponse = (DescribeOrderableDbInstanceOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableDBInstanceOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrderableDbInstanceOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrderableDbInstanceOptionsRequestMarshaller(this.protocolFactory)));
            return describeOrderableDbInstanceOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeOrderableDBInstanceOptions$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeOrderableDBInstanceOptionsIterable describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeOrderableDBInstanceOptionsIterable(this, this.applyPaginatorUserAgent(describeOrderableDbInstanceOptionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePendingMaintenanceActions");
            DescribePendingMaintenanceActionsResponse describePendingMaintenanceActionsResponse = (DescribePendingMaintenanceActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingMaintenanceActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePendingMaintenanceActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePendingMaintenanceActionsRequestMarshaller(this.protocolFactory)));
            return describePendingMaintenanceActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describePendingMaintenanceActions$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribePendingMaintenanceActionsIterable(this, this.applyPaginatorUserAgent(describePendingMaintenanceActionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeValidDbInstanceModificationsResponse describeValidDBInstanceModifications(DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest) throws DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeValidDbInstanceModificationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, describeValidDbInstanceModificationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeValidDBInstanceModifications");
            DescribeValidDbInstanceModificationsResponse describeValidDbInstanceModificationsResponse = (DescribeValidDbInstanceModificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeValidDBInstanceModifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeValidDbInstanceModificationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeValidDbInstanceModificationsRequestMarshaller(this.protocolFactory)));
            return describeValidDbInstanceModificationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$describeValidDBInstanceModifications$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FailoverDbClusterResponse failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(FailoverDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, failoverDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FailoverDBCluster");
            FailoverDbClusterResponse failoverDbClusterResponse = (FailoverDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)failoverDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new FailoverDbClusterRequestMarshaller(this.protocolFactory)));
            return failoverDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$failoverDBCluster$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$listTagsForResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbClusterResponse modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException, InvalidDbInstanceStateException, DbClusterAlreadyExistsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBCluster");
            ModifyDbClusterResponse modifyDbClusterResponse = (ModifyDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbClusterRequestMarshaller(this.protocolFactory)));
            return modifyDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$modifyDBCluster$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbClusterEndpointResponse modifyDBClusterEndpoint(ModifyDbClusterEndpointRequest modifyDbClusterEndpointRequest) throws InvalidDbClusterStateException, InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException, DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterEndpointResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterEndpoint");
            ModifyDbClusterEndpointResponse modifyDbClusterEndpointResponse = (ModifyDbClusterEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbClusterEndpointRequestMarshaller(this.protocolFactory)));
            return modifyDbClusterEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$modifyDBClusterEndpoint$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterParameterGroup");
            ModifyDbClusterParameterGroupResponse modifyDbClusterParameterGroupResponse = (ModifyDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return modifyDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$modifyDBClusterParameterGroup$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException, SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterSnapshotAttribute");
            ModifyDbClusterSnapshotAttributeResponse modifyDbClusterSnapshotAttributeResponse = (ModifyDbClusterSnapshotAttributeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterSnapshotAttribute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterSnapshotAttributeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbClusterSnapshotAttributeRequestMarshaller(this.protocolFactory)));
            return modifyDbClusterSnapshotAttributeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$modifyDBClusterSnapshotAttribute$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbInstanceResponse modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException, DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException, InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException, DbUpgradeDependencyFailureException, StorageTypeNotSupportedException, AuthorizationNotFoundException, CertificateNotFoundException, DomainNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, modifyDbInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBInstance");
            ModifyDbInstanceResponse modifyDbInstanceResponse = (ModifyDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbInstanceRequestMarshaller(this.protocolFactory)));
            return modifyDbInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$modifyDBInstance$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbParameterGroupResponse modifyDBParameterGroup(ModifyDbParameterGroupRequest modifyDbParameterGroupRequest) throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, modifyDbParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBParameterGroup");
            ModifyDbParameterGroupResponse modifyDbParameterGroupResponse = (ModifyDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbParameterGroupRequestMarshaller(this.protocolFactory)));
            return modifyDbParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$modifyDBParameterGroup$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbSubnetGroupResponse modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) throws DbSubnetGroupNotFoundException, DbSubnetQuotaExceededException, SubnetAlreadyInUseException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, modifyDbSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBSubnetGroup");
            ModifyDbSubnetGroupResponse modifyDbSubnetGroupResponse = (ModifyDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbSubnetGroupRequestMarshaller(this.protocolFactory)));
            return modifyDbSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$modifyDBSubnetGroup$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) throws EventSubscriptionQuotaExceededException, SubscriptionNotFoundException, SnsInvalidTopicException, SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, modifyEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEventSubscription");
            ModifyEventSubscriptionResponse modifyEventSubscriptionResponse = (ModifyEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyEventSubscriptionRequestMarshaller(this.protocolFactory)));
            return modifyEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$modifyEventSubscription$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromoteReadReplicaDbClusterResponse promoteReadReplicaDBCluster(PromoteReadReplicaDbClusterRequest promoteReadReplicaDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PromoteReadReplicaDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, promoteReadReplicaDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PromoteReadReplicaDBCluster");
            PromoteReadReplicaDbClusterResponse promoteReadReplicaDbClusterResponse = (PromoteReadReplicaDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PromoteReadReplicaDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)promoteReadReplicaDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PromoteReadReplicaDbClusterRequestMarshaller(this.protocolFactory)));
            return promoteReadReplicaDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$promoteReadReplicaDBCluster$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootDbInstanceResponse rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, rebootDbInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootDBInstance");
            RebootDbInstanceResponse rebootDbInstanceResponse = (RebootDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootDbInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootDbInstanceRequestMarshaller(this.protocolFactory)));
            return rebootDbInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$rebootDBInstance$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveRoleFromDbClusterResponse removeRoleFromDBCluster(RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest) throws DbClusterNotFoundException, DbClusterRoleNotFoundException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveRoleFromDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, removeRoleFromDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveRoleFromDBCluster");
            RemoveRoleFromDbClusterResponse removeRoleFromDbClusterResponse = (RemoveRoleFromDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveRoleFromDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeRoleFromDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveRoleFromDbClusterRequestMarshaller(this.protocolFactory)));
            return removeRoleFromDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$removeRoleFromDBCluster$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveSourceIdentifierFromSubscriptionResponse removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest) throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveSourceIdentifierFromSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, removeSourceIdentifierFromSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveSourceIdentifierFromSubscription");
            RemoveSourceIdentifierFromSubscriptionResponse removeSourceIdentifierFromSubscriptionResponse = (RemoveSourceIdentifierFromSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveSourceIdentifierFromSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeSourceIdentifierFromSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveSourceIdentifierFromSubscriptionRequestMarshaller(this.protocolFactory)));
            return removeSourceIdentifierFromSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$removeSourceIdentifierFromSubscription$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsFromResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            RemoveTagsFromResourceResponse removeTagsFromResourceResponse = (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)));
            return removeTagsFromResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$removeTagsFromResource$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetDbClusterParameterGroupResponse resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, resetDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDBClusterParameterGroup");
            ResetDbClusterParameterGroupResponse resetDbClusterParameterGroupResponse = (ResetDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return resetDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$resetDBClusterParameterGroup$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetDbParameterGroupResponse resetDBParameterGroup(ResetDbParameterGroupRequest resetDbParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, resetDbParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDBParameterGroup");
            ResetDbParameterGroupResponse resetDbParameterGroupResponse = (ResetDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetDbParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetDbParameterGroupRequestMarshaller(this.protocolFactory)));
            return resetDbParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$resetDBParameterGroup$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreDbClusterFromSnapshotResponse restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) throws DbClusterAlreadyExistsException, DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbSnapshotStateException, InvalidDbClusterSnapshotStateException, InvalidVpcNetworkStateException, InvalidRestoreException, InvalidSubnetException, OptionGroupNotFoundException, KmsKeyNotAccessibleException, DbClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, restoreDbClusterFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDBClusterFromSnapshot");
            RestoreDbClusterFromSnapshotResponse restoreDbClusterFromSnapshotResponse = (RestoreDbClusterFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDbClusterFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreDbClusterFromSnapshotRequestMarshaller(this.protocolFactory)));
            return restoreDbClusterFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$restoreDBClusterFromSnapshot$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreDbClusterToPointInTimeResponse restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) throws DbClusterAlreadyExistsException, DbClusterNotFoundException, DbClusterQuotaExceededException, DbClusterSnapshotNotFoundException, DbSubnetGroupNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbClusterSnapshotStateException, InvalidDbClusterStateException, InvalidDbSnapshotStateException, InvalidRestoreException, InvalidSubnetException, InvalidVpcNetworkStateException, KmsKeyNotAccessibleException, OptionGroupNotFoundException, StorageQuotaExceededException, DbClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDBClusterToPointInTime");
            RestoreDbClusterToPointInTimeResponse restoreDbClusterToPointInTimeResponse = (RestoreDbClusterToPointInTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterToPointInTime").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDbClusterToPointInTimeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreDbClusterToPointInTimeRequestMarshaller(this.protocolFactory)));
            return restoreDbClusterToPointInTimeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$restoreDBClusterToPointInTime$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDbClusterResponse startDBCluster(StartDbClusterRequest startDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, startDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDBCluster");
            StartDbClusterResponse startDbClusterResponse = (StartDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDbClusterRequestMarshaller(this.protocolFactory)));
            return startDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$startDBCluster$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDbClusterResponse stopDBCluster(StopDbClusterRequest stopDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StopDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultNeptuneClient.resolveMetricPublishers(this.clientConfiguration, stopDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDBCluster");
            StopDbClusterResponse stopDbClusterResponse = (StopDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopDbClusterRequestMarshaller(this.protocolFactory)));
            return stopDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneClient.lambda$stopDBCluster$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound").exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault").exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleNotFound").exceptionBuilderSupplier(DbClusterRoleNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound").exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestoreFault").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault").exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceNotFound").exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs").exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded").exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleQuotaExceeded").exceptionBuilderSupplier(DbClusterRoleQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState").exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded").exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageTypeNotSupported").exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionNotFound").exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity").exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists").exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists").exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault").exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleAlreadyExists").exceptionBuilderSupplier(DbClusterRoleAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventSubscriptionState").exceptionBuilderSupplier(InvalidEventSubscriptionStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState").exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound").exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded").exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault").exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded").exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault").exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded").exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists").exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault").exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault").exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault").exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound").exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault").exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSInvalidTopic").exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault").exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure").exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedIopsNotAvailableInAZFault").exceptionBuilderSupplier(ProvisionedIopsNotAvailableInAzException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault").exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound").exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterEndpointAlreadyExistsFault").exceptionBuilderSupplier(DbClusterEndpointAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity").exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists").exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSNoAuthorization").exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterEndpointQuotaExceededFault").exceptionBuilderSupplier(DbClusterEndpointQuotaExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotNotFound").exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist").exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OptionGroupNotFoundFault").exceptionBuilderSupplier(OptionGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault").exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceNotFound").exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBInstanceState").exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainNotFoundFault").exceptionBuilderSupplier(DomainNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded").exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterEndpointNotFoundFault").exceptionBuilderSupplier(DbClusterEndpointNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageQuotaExceeded").exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterEndpointStateFault").exceptionBuilderSupplier(InvalidDbClusterEndpointStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState").exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NeptuneException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends NeptuneRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.6").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NeptuneRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public NeptuneWaiter waiter() {
        return NeptuneWaiter.builder().client(this).build();
    }

    private static /* synthetic */ void lambda$stopDBCluster$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDBCluster$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreDBClusterToPointInTime$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreDBClusterFromSnapshot$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetDBParameterGroup$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetDBClusterParameterGroup$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTagsFromResource$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeSourceIdentifierFromSubscription$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeRoleFromDBCluster$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootDBInstance$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$promoteReadReplicaDBCluster$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyEventSubscription$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBSubnetGroup$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBParameterGroup$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBInstance$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBClusterSnapshotAttribute$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBClusterParameterGroup$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBClusterEndpoint$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBCluster$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$failoverDBCluster$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeValidDBInstanceModifications$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePendingMaintenanceActions$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrderableDBInstanceOptions$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvents$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventSubscriptions$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventCategories$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEngineDefaultParameters$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEngineDefaultClusterParameters$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBSubnetGroups$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBParameters$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBParameterGroups$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBInstances$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBEngineVersions$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusters$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterSnapshots$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterSnapshotAttributes$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterParameters$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterParameterGroups$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterEndpoints$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventSubscription$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBSubnetGroup$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBParameterGroup$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBInstance$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBClusterSnapshot$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBClusterParameterGroup$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBClusterEndpoint$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBCluster$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEventSubscription$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBSubnetGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBParameterGroup$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBInstance$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBClusterSnapshot$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBClusterParameterGroup$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBClusterEndpoint$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBCluster$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyDBParameterGroup$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyDBClusterSnapshot$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyDBClusterParameterGroup$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$applyPendingMaintenanceAction$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTagsToResource$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addSourceIdentifierToSubscription$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addRoleToDBCluster$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

