/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.neptune.model.DBClusterParameterGroup;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse;

public class DescribeDBClusterParameterGroupsIterable
implements SdkIterable<DescribeDbClusterParameterGroupsResponse> {
    private final NeptuneClient client;
    private final DescribeDbClusterParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClusterParameterGroupsIterable(NeptuneClient client, DescribeDbClusterParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbClusterParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeDbClusterParameterGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBClusterParameterGroup> dbClusterParameterGroups() {
        Function<DescribeDbClusterParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterParameterGroups() != null) {
                return response.dbClusterParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbClusterParameterGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDbClusterParameterGroupsResponse> {
        private DescribeDbClusterParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClusterParameterGroupsResponse nextPage(DescribeDbClusterParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterParameterGroupsIterable.this.client.describeDBClusterParameterGroups(DescribeDBClusterParameterGroupsIterable.this.firstRequest);
            }
            return DescribeDBClusterParameterGroupsIterable.this.client.describeDBClusterParameterGroups((DescribeDbClusterParameterGroupsRequest)((Object)DescribeDBClusterParameterGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

