/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DoubleRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DoubleRange> {
    private static final SdkField<Double> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("From").getter(DoubleRange.getter(DoubleRange::from)).setter(DoubleRange.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()}).build();
    private static final SdkField<Double> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("To").getter(DoubleRange.getter(DoubleRange::to)).setter(DoubleRange.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, TO_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double from;
    private final Double to;

    private DoubleRange(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    public final Double from() {
        return this.from;
    }

    public final Double to() {
        return this.to;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleRange)) {
            return false;
        }
        DoubleRange other = (DoubleRange)obj;
        return Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to());
    }

    public final String toString() {
        return ToString.builder((String)"DoubleRange").add("From", (Object)this.from()).add("To", (Object)this.to()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "From": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "To": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DoubleRange, T> g) {
        return obj -> g.apply((DoubleRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double from;
        private Double to;

        private BuilderImpl() {
        }

        private BuilderImpl(DoubleRange model) {
            this.from(model.from);
            this.to(model.to);
        }

        public final Double getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(Double from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Double from) {
            this.from = from;
        }

        public final Double getTo() {
            return this.to;
        }

        @Override
        public final Builder to(Double to) {
            this.to = to;
            return this;
        }

        public final void setTo(Double to) {
            this.to = to;
        }

        public DoubleRange build() {
            return new DoubleRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DoubleRange> {
        public Builder from(Double var1);

        public Builder to(Double var1);
    }
}

