/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.DoubleRange;
import software.amazon.awssdk.services.neptune.model.DoubleRangeListCopier;
import software.amazon.awssdk.services.neptune.model.Range;
import software.amazon.awssdk.services.neptune.model.RangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidStorageOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidStorageOptions> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(ValidStorageOptions.getter(ValidStorageOptions::storageType)).setter(ValidStorageOptions.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<List<Range>> STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageSize").getter(ValidStorageOptions.getter(ValidStorageOptions::storageSize)).setter(ValidStorageOptions.setter(Builder::storageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSize").build(), ListTrait.builder().memberLocationName("Range").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()}).build()).build()}).build();
    private static final SdkField<List<Range>> PROVISIONED_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisionedIops").getter(ValidStorageOptions.getter(ValidStorageOptions::provisionedIops)).setter(ValidStorageOptions.setter(Builder::provisionedIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedIops").build(), ListTrait.builder().memberLocationName("Range").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()}).build()).build()}).build();
    private static final SdkField<List<DoubleRange>> IOPS_TO_STORAGE_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IopsToStorageRatio").getter(ValidStorageOptions.getter(ValidStorageOptions::iopsToStorageRatio)).setter(ValidStorageOptions.setter(Builder::iopsToStorageRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IopsToStorageRatio").build(), ListTrait.builder().memberLocationName("DoubleRange").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DoubleRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleRange").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, STORAGE_SIZE_FIELD, PROVISIONED_IOPS_FIELD, IOPS_TO_STORAGE_RATIO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String storageType;
    private final List<Range> storageSize;
    private final List<Range> provisionedIops;
    private final List<DoubleRange> iopsToStorageRatio;

    private ValidStorageOptions(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.storageSize = builder.storageSize;
        this.provisionedIops = builder.provisionedIops;
        this.iopsToStorageRatio = builder.iopsToStorageRatio;
    }

    public String storageType() {
        return this.storageType;
    }

    public boolean hasStorageSize() {
        return this.storageSize != null && !(this.storageSize instanceof SdkAutoConstructList);
    }

    public List<Range> storageSize() {
        return this.storageSize;
    }

    public boolean hasProvisionedIops() {
        return this.provisionedIops != null && !(this.provisionedIops instanceof SdkAutoConstructList);
    }

    public List<Range> provisionedIops() {
        return this.provisionedIops;
    }

    public boolean hasIopsToStorageRatio() {
        return this.iopsToStorageRatio != null && !(this.iopsToStorageRatio instanceof SdkAutoConstructList);
    }

    public List<DoubleRange> iopsToStorageRatio() {
        return this.iopsToStorageRatio;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageSize() ? this.storageSize() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedIops() ? this.provisionedIops() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIopsToStorageRatio() ? this.iopsToStorageRatio() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidStorageOptions)) {
            return false;
        }
        ValidStorageOptions other = (ValidStorageOptions)obj;
        return Objects.equals(this.storageType(), other.storageType()) && this.hasStorageSize() == other.hasStorageSize() && Objects.equals(this.storageSize(), other.storageSize()) && this.hasProvisionedIops() == other.hasProvisionedIops() && Objects.equals(this.provisionedIops(), other.provisionedIops()) && this.hasIopsToStorageRatio() == other.hasIopsToStorageRatio() && Objects.equals(this.iopsToStorageRatio(), other.iopsToStorageRatio());
    }

    public String toString() {
        return ToString.builder((String)"ValidStorageOptions").add("StorageType", (Object)this.storageType()).add("StorageSize", this.hasStorageSize() ? this.storageSize() : null).add("ProvisionedIops", this.hasProvisionedIops() ? this.provisionedIops() : null).add("IopsToStorageRatio", this.hasIopsToStorageRatio() ? this.iopsToStorageRatio() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "StorageSize": {
                return Optional.ofNullable(clazz.cast(this.storageSize()));
            }
            case "ProvisionedIops": {
                return Optional.ofNullable(clazz.cast(this.provisionedIops()));
            }
            case "IopsToStorageRatio": {
                return Optional.ofNullable(clazz.cast(this.iopsToStorageRatio()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidStorageOptions, T> g) {
        return obj -> g.apply((ValidStorageOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageType;
        private List<Range> storageSize = DefaultSdkAutoConstructList.getInstance();
        private List<Range> provisionedIops = DefaultSdkAutoConstructList.getInstance();
        private List<DoubleRange> iopsToStorageRatio = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidStorageOptions model) {
            this.storageType(model.storageType);
            this.storageSize(model.storageSize);
            this.provisionedIops(model.provisionedIops);
            this.iopsToStorageRatio(model.iopsToStorageRatio);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Collection<Range.Builder> getStorageSize() {
            if (this.storageSize instanceof SdkAutoConstructList) {
                return null;
            }
            return this.storageSize != null ? (Collection)this.storageSize.stream().map(Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageSize(Collection<Range> storageSize) {
            this.storageSize = RangeListCopier.copy(storageSize);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Range ... storageSize) {
            this.storageSize(Arrays.asList(storageSize));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Consumer<Range.Builder> ... storageSize) {
            this.storageSize(Stream.of(storageSize).map(c -> (Range)((Range.Builder)Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageSize(Collection<Range.BuilderImpl> storageSize) {
            this.storageSize = RangeListCopier.copyFromBuilder(storageSize);
        }

        public final Collection<Range.Builder> getProvisionedIops() {
            if (this.provisionedIops instanceof SdkAutoConstructList) {
                return null;
            }
            return this.provisionedIops != null ? (Collection)this.provisionedIops.stream().map(Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedIops(Collection<Range> provisionedIops) {
            this.provisionedIops = RangeListCopier.copy(provisionedIops);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Range ... provisionedIops) {
            this.provisionedIops(Arrays.asList(provisionedIops));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Consumer<Range.Builder> ... provisionedIops) {
            this.provisionedIops(Stream.of(provisionedIops).map(c -> (Range)((Range.Builder)Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedIops(Collection<Range.BuilderImpl> provisionedIops) {
            this.provisionedIops = RangeListCopier.copyFromBuilder(provisionedIops);
        }

        public final Collection<DoubleRange.Builder> getIopsToStorageRatio() {
            if (this.iopsToStorageRatio instanceof SdkAutoConstructList) {
                return null;
            }
            return this.iopsToStorageRatio != null ? (Collection)this.iopsToStorageRatio.stream().map(DoubleRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copy(iopsToStorageRatio);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(DoubleRange ... iopsToStorageRatio) {
            this.iopsToStorageRatio(Arrays.asList(iopsToStorageRatio));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(Consumer<DoubleRange.Builder> ... iopsToStorageRatio) {
            this.iopsToStorageRatio(Stream.of(iopsToStorageRatio).map(c -> (DoubleRange)((DoubleRange.Builder)DoubleRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIopsToStorageRatio(Collection<DoubleRange.BuilderImpl> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copyFromBuilder(iopsToStorageRatio);
        }

        public ValidStorageOptions build() {
            return new ValidStorageOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidStorageOptions> {
        public Builder storageType(String var1);

        public Builder storageSize(Collection<Range> var1);

        public Builder storageSize(Range ... var1);

        public Builder storageSize(Consumer<Range.Builder> ... var1);

        public Builder provisionedIops(Collection<Range> var1);

        public Builder provisionedIops(Range ... var1);

        public Builder provisionedIops(Consumer<Range.Builder> ... var1);

        public Builder iopsToStorageRatio(Collection<DoubleRange> var1);

        public Builder iopsToStorageRatio(DoubleRange ... var1);

        public Builder iopsToStorageRatio(Consumer<DoubleRange.Builder> ... var1);
    }
}

