/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.neptune.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.neptune.model.CertificateNotFoundException;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.neptune.model.DomainNotFoundException;
import software.amazon.awssdk.services.neptune.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.neptune.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.neptune.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.neptune.model.InvalidEventSubscriptionStateException;
import software.amazon.awssdk.services.neptune.model.InvalidRestoreException;
import software.amazon.awssdk.services.neptune.model.InvalidSubnetException;
import software.amazon.awssdk.services.neptune.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.neptune.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.NeptuneException;
import software.amazon.awssdk.services.neptune.model.NeptuneRequest;
import software.amazon.awssdk.services.neptune.model.OptionGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ProvisionedIopsNotAvailableInAzException;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResourceNotFoundException;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.neptune.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.neptune.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.neptune.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.neptune.model.SourceNotFoundException;
import software.amazon.awssdk.services.neptune.model.StartDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StartDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StopDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StopDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.neptune.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.neptune.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.neptune.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.neptune.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher;
import software.amazon.awssdk.services.neptune.transform.AddRoleToDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.AddSourceIdentifierToSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeValidDbInstanceModificationsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.PromoteReadReplicaDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveRoleFromDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveSourceIdentifierFromSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ResetDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.StopDbClusterRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultNeptuneAsyncClient
implements NeptuneAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultNeptuneAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNeptuneAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "rds";
    }

    @Override
    public CompletableFuture<AddRoleToDbClusterResponse> addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddRoleToDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddRoleToDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddRoleToDBCluster").withMarshaller((Marshaller)new AddRoleToDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)addRoleToDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addRoleToDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, addRoleToDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddSourceIdentifierToSubscriptionResponse> addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddSourceIdentifierToSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddSourceIdentifierToSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddSourceIdentifierToSubscription").withMarshaller((Marshaller)new AddSourceIdentifierToSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)addSourceIdentifierToSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addSourceIdentifierToSubscriptionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, addSourceIdentifierToSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsToResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)addTagsToResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addTagsToResourceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplyPendingMaintenanceAction");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyPendingMaintenanceAction").withMarshaller((Marshaller)new ApplyPendingMaintenanceActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)applyPendingMaintenanceActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterParameterGroup").withMarshaller((Marshaller)new CopyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)copyDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = copyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, copyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterSnapshot").withMarshaller((Marshaller)new CopyDbClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)copyDbClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = copyDbClusterSnapshotRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, copyDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyDbParameterGroupResponse> copyDBParameterGroup(CopyDbParameterGroupRequest copyDbParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBParameterGroup").withMarshaller((Marshaller)new CopyDbParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)copyDbParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = copyDbParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, copyDbParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbClusterResponse> createDBCluster(CreateDbClusterRequest createDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBCluster").withMarshaller((Marshaller)new CreateDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterParameterGroup").withMarshaller((Marshaller)new CreateDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterSnapshot").withMarshaller((Marshaller)new CreateDbClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbClusterSnapshotRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbInstanceResponse> createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbInstanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBInstance").withMarshaller((Marshaller)new CreateDbInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbInstanceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbParameterGroupResponse> createDBParameterGroup(CreateDbParameterGroupRequest createDbParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBParameterGroup").withMarshaller((Marshaller)new CreateDbParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBSubnetGroup").withMarshaller((Marshaller)new CreateDbSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createDbSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDbSubnetGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDbSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventSubscription").withMarshaller((Marshaller)new CreateEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createEventSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createEventSubscriptionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, createEventSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBCluster").withMarshaller((Marshaller)new DeleteDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbClusterParameterGroupResponse> deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterParameterGroup").withMarshaller((Marshaller)new DeleteDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterSnapshot").withMarshaller((Marshaller)new DeleteDbClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbClusterSnapshotRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbInstanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBInstance").withMarshaller((Marshaller)new DeleteDbInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbInstanceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbParameterGroupResponse> deleteDBParameterGroup(DeleteDbParameterGroupRequest deleteDbParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBParameterGroup").withMarshaller((Marshaller)new DeleteDbParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDbSubnetGroupResponse> deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBSubnetGroup").withMarshaller((Marshaller)new DeleteDbSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteDbSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDbSubnetGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDbSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventSubscription").withMarshaller((Marshaller)new DeleteEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteEventSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEventSubscriptionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteEventSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterParameterGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameterGroups").withMarshaller((Marshaller)new DescribeDbClusterParameterGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClusterParameterGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameters").withMarshaller((Marshaller)new DescribeDbClusterParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClusterParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClusterParametersRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterParametersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterSnapshotAttributes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshotAttributes").withMarshaller((Marshaller)new DescribeDbClusterSnapshotAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClusterSnapshotAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterSnapshots");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshots").withMarshaller((Marshaller)new DescribeDbClusterSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClusterSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClusterSnapshotsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterSnapshotsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbClustersResponse> describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClustersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusters").withMarshaller((Marshaller)new DescribeDbClustersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbClustersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbClustersRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbClustersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBEngineVersions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbEngineVersionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBEngineVersions").withMarshaller((Marshaller)new DescribeDbEngineVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbEngineVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbEngineVersionsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbEngineVersionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        return new DescribeDBEngineVersionsPublisher(this, this.applyPaginatorUserAgent(describeDbEngineVersionsRequest));
    }

    @Override
    public CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBInstances");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbInstancesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBInstances").withMarshaller((Marshaller)new DescribeDbInstancesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbInstancesRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbInstancesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBInstancesPublisher describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return new DescribeDBInstancesPublisher(this, this.applyPaginatorUserAgent(describeDbInstancesRequest));
    }

    @Override
    public CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups(DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBParameterGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbParameterGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBParameterGroups").withMarshaller((Marshaller)new DescribeDbParameterGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbParameterGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbParameterGroupsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbParameterGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        return new DescribeDBParameterGroupsPublisher(this, this.applyPaginatorUserAgent(describeDbParameterGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeDbParametersResponse> describeDBParameters(DescribeDbParametersRequest describeDbParametersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBParameters").withMarshaller((Marshaller)new DescribeDbParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbParametersRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbParametersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBParametersPublisher describeDBParametersPaginator(DescribeDbParametersRequest describeDbParametersRequest) {
        return new DescribeDBParametersPublisher(this, this.applyPaginatorUserAgent(describeDbParametersRequest));
    }

    @Override
    public CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBSubnetGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbSubnetGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBSubnetGroups").withMarshaller((Marshaller)new DescribeDbSubnetGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDbSubnetGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDbSubnetGroupsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDbSubnetGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        return new DescribeDBSubnetGroupsPublisher(this, this.applyPaginatorUserAgent(describeDbSubnetGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineDefaultClusterParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultClusterParameters").withMarshaller((Marshaller)new DescribeEngineDefaultClusterParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEngineDefaultClusterParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineDefaultParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultParameters").withMarshaller((Marshaller)new DescribeEngineDefaultParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEngineDefaultParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEngineDefaultParametersRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEngineDefaultParametersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        return new DescribeEngineDefaultParametersPublisher(this, this.applyPaginatorUserAgent(describeEngineDefaultParametersRequest));
    }

    @Override
    public CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventCategories");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventCategoriesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventCategoriesRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventCategoriesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSubscriptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventSubscriptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSubscriptions").withMarshaller((Marshaller)new DescribeEventSubscriptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventSubscriptionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventSubscriptionsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventSubscriptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        return new DescribeEventSubscriptionsPublisher(this, this.applyPaginatorUserAgent(describeEventSubscriptionsRequest));
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrderableDBInstanceOptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableDBInstanceOptions").withMarshaller((Marshaller)new DescribeOrderableDbInstanceOptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeOrderableDbInstanceOptionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        return new DescribeOrderableDBInstanceOptionsPublisher(this, this.applyPaginatorUserAgent(describeOrderableDbInstanceOptionsRequest));
    }

    @Override
    public CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePendingMaintenanceActions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingMaintenanceActions").withMarshaller((Marshaller)new DescribePendingMaintenanceActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describePendingMaintenanceActionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeValidDbInstanceModificationsResponse> describeValidDBInstanceModifications(DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeValidDBInstanceModifications");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeValidDbInstanceModificationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeValidDBInstanceModifications").withMarshaller((Marshaller)new DescribeValidDbInstanceModificationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeValidDbInstanceModificationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeValidDbInstanceModificationsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeValidDbInstanceModificationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<FailoverDbClusterResponse> failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FailoverDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(FailoverDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverDBCluster").withMarshaller((Marshaller)new FailoverDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)failoverDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = failoverDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, failoverDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbClusterResponse> modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBCluster").withMarshaller((Marshaller)new ModifyDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbClusterParameterGroupResponse> modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterParameterGroup").withMarshaller((Marshaller)new ModifyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterSnapshotAttribute");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterSnapshotAttribute").withMarshaller((Marshaller)new ModifyDbClusterSnapshotAttributeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbClusterSnapshotAttributeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbInstanceResponse> modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbInstanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBInstance").withMarshaller((Marshaller)new ModifyDbInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbInstanceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbParameterGroupResponse> modifyDBParameterGroup(ModifyDbParameterGroupRequest modifyDbParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBParameterGroup").withMarshaller((Marshaller)new ModifyDbParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyDbSubnetGroupResponse> modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBSubnetGroup").withMarshaller((Marshaller)new ModifyDbSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyDbSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyDbSubnetGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyDbSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEventSubscription").withMarshaller((Marshaller)new ModifyEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyEventSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyEventSubscriptionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyEventSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PromoteReadReplicaDbClusterResponse> promoteReadReplicaDBCluster(PromoteReadReplicaDbClusterRequest promoteReadReplicaDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PromoteReadReplicaDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PromoteReadReplicaDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PromoteReadReplicaDBCluster").withMarshaller((Marshaller)new PromoteReadReplicaDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)promoteReadReplicaDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = promoteReadReplicaDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, promoteReadReplicaDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootDbInstanceResponse> rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootDBInstance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootDbInstanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootDBInstance").withMarshaller((Marshaller)new RebootDbInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)rebootDbInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rebootDbInstanceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, rebootDbInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveRoleFromDbClusterResponse> removeRoleFromDBCluster(RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveRoleFromDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveRoleFromDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveRoleFromDBCluster").withMarshaller((Marshaller)new RemoveRoleFromDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)removeRoleFromDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeRoleFromDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeRoleFromDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveSourceIdentifierFromSubscriptionResponse> removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveSourceIdentifierFromSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveSourceIdentifierFromSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveSourceIdentifierFromSubscription").withMarshaller((Marshaller)new RemoveSourceIdentifierFromSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)removeSourceIdentifierFromSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeSourceIdentifierFromSubscriptionRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeSourceIdentifierFromSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsFromResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)removeTagsFromResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeTagsFromResourceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetDbClusterParameterGroupResponse> resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDBClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBClusterParameterGroup").withMarshaller((Marshaller)new ResetDbClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)resetDbClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetDbClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, resetDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetDbParameterGroupResponse> resetDBParameterGroup(ResetDbParameterGroupRequest resetDbParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDBParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBParameterGroup").withMarshaller((Marshaller)new ResetDbParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)resetDbParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetDbParameterGroupRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, resetDbParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreDbClusterFromSnapshotResponse> restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDBClusterFromSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterFromSnapshot").withMarshaller((Marshaller)new RestoreDbClusterFromSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)restoreDbClusterFromSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = restoreDbClusterFromSnapshotRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreDbClusterFromSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreDbClusterToPointInTimeResponse> restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDBClusterToPointInTime");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterToPointInTime").withMarshaller((Marshaller)new RestoreDbClusterToPointInTimeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)restoreDbClusterToPointInTimeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDbClusterResponse> startDBCluster(StartDbClusterRequest startDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDBCluster").withMarshaller((Marshaller)new StartDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)startDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, startDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopDbClusterResponse> stopDBCluster(StopDbClusterRequest stopDbClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDBCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StopDbClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDBCluster").withMarshaller((Marshaller)new StopDbClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)stopDbClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopDbClusterRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultNeptuneAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopDbClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound").exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault").exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleNotFound").exceptionBuilderSupplier(DbClusterRoleNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound").exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestoreFault").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault").exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceNotFound").exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs").exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded").exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleQuotaExceeded").exceptionBuilderSupplier(DbClusterRoleQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState").exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded").exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageTypeNotSupported").exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionNotFound").exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity").exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists").exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists").exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault").exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleAlreadyExists").exceptionBuilderSupplier(DbClusterRoleAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventSubscriptionState").exceptionBuilderSupplier(InvalidEventSubscriptionStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState").exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound").exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded").exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault").exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded").exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault").exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded").exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists").exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault").exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault").exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault").exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound").exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault").exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSInvalidTopic").exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault").exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure").exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedIopsNotAvailableInAZFault").exceptionBuilderSupplier(ProvisionedIopsNotAvailableInAzException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault").exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound").exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity").exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists").exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSNoAuthorization").exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotNotFound").exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist").exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OptionGroupNotFoundFault").exceptionBuilderSupplier(OptionGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault").exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceNotFound").exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBInstanceState").exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainNotFoundFault").exceptionBuilderSupplier(DomainNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded").exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageQuotaExceeded").exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState").exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NeptuneException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends NeptuneRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.52").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NeptuneRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

