/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mwaaserverless.MwaaServerlessAsyncClient;
import software.amazon.awssdk.services.mwaaserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsResponse;
import software.amazon.awssdk.services.mwaaserverless.model.WorkflowVersionSummary;

public class ListWorkflowVersionsPublisher
implements SdkPublisher<ListWorkflowVersionsResponse> {
    private final MwaaServerlessAsyncClient client;
    private final ListWorkflowVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowVersionsPublisher(MwaaServerlessAsyncClient client, ListWorkflowVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowVersionsPublisher(MwaaServerlessAsyncClient client, ListWorkflowVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowVersionSummary> workflowVersions() {
        Function<ListWorkflowVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowVersions() != null) {
                return response.workflowVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowVersionsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowVersionsResponse> {
        private ListWorkflowVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowVersionsResponse> nextPage(ListWorkflowVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowVersionsPublisher.this.client.listWorkflowVersions(ListWorkflowVersionsPublisher.this.firstRequest);
            }
            return ListWorkflowVersionsPublisher.this.client.listWorkflowVersions((ListWorkflowVersionsRequest)((Object)ListWorkflowVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

