/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mwaaserverless.MwaaServerlessAsyncClient;
import software.amazon.awssdk.services.mwaaserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesResponse;
import software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceSummary;

public class ListTaskInstancesPublisher
implements SdkPublisher<ListTaskInstancesResponse> {
    private final MwaaServerlessAsyncClient client;
    private final ListTaskInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTaskInstancesPublisher(MwaaServerlessAsyncClient client, ListTaskInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTaskInstancesPublisher(MwaaServerlessAsyncClient client, ListTaskInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTaskInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTaskInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TaskInstanceSummary> taskInstances() {
        Function<ListTaskInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskInstances() != null) {
                return response.taskInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTaskInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTaskInstancesResponseFetcher
    implements AsyncPageFetcher<ListTaskInstancesResponse> {
        private ListTaskInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTaskInstancesResponse> nextPage(ListTaskInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListTaskInstancesPublisher.this.client.listTaskInstances(ListTaskInstancesPublisher.this.firstRequest);
            }
            return ListTaskInstancesPublisher.this.client.listTaskInstances((ListTaskInstancesRequest)((Object)ListTaskInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

