/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mwaaserverless.MwaaServerlessClient;
import software.amazon.awssdk.services.mwaaserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesResponse;
import software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceSummary;

public class ListTaskInstancesIterable
implements SdkIterable<ListTaskInstancesResponse> {
    private final MwaaServerlessClient client;
    private final ListTaskInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTaskInstancesIterable(MwaaServerlessClient client, ListTaskInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTaskInstancesResponseFetcher();
    }

    public Iterator<ListTaskInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TaskInstanceSummary> taskInstances() {
        Function<ListTaskInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskInstances() != null) {
                return response.taskInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTaskInstancesResponseFetcher
    implements SyncPageFetcher<ListTaskInstancesResponse> {
        private ListTaskInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTaskInstancesResponse nextPage(ListTaskInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListTaskInstancesIterable.this.client.listTaskInstances(ListTaskInstancesIterable.this.firstRequest);
            }
            return ListTaskInstancesIterable.this.client.listTaskInstances((ListTaskInstancesRequest)((Object)ListTaskInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

