/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaaserverless.model.DefinitionS3Location;
import software.amazon.awssdk.services.mwaaserverless.model.ScheduleConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowVersionSummary> {
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowVersion").getter(WorkflowVersionSummary.getter(WorkflowVersionSummary::workflowVersion)).setter(WorkflowVersionSummary.setter(Builder::workflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()}).build();
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowArn").getter(WorkflowVersionSummary.getter(WorkflowVersionSummary::workflowArn)).setter(WorkflowVersionSummary.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()}).build();
    private static final SdkField<Boolean> IS_LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsLatestVersion").getter(WorkflowVersionSummary.getter(WorkflowVersionSummary::isLatestVersion)).setter(WorkflowVersionSummary.setter(Builder::isLatestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatestVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(WorkflowVersionSummary.getter(WorkflowVersionSummary::createdAt)).setter(WorkflowVersionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(WorkflowVersionSummary.getter(WorkflowVersionSummary::modifiedAt)).setter(WorkflowVersionSummary.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<DefinitionS3Location> DEFINITION_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefinitionS3Location").getter(WorkflowVersionSummary.getter(WorkflowVersionSummary::definitionS3Location)).setter(WorkflowVersionSummary.setter(Builder::definitionS3Location)).constructor(DefinitionS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionS3Location").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfiguration").getter(WorkflowVersionSummary.getter(WorkflowVersionSummary::scheduleConfiguration)).setter(WorkflowVersionSummary.setter(Builder::scheduleConfiguration)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build()}).build();
    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerMode").getter(WorkflowVersionSummary.getter(WorkflowVersionSummary::triggerMode)).setter(WorkflowVersionSummary.setter(Builder::triggerMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_VERSION_FIELD, WORKFLOW_ARN_FIELD, IS_LATEST_VERSION_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DEFINITION_S3_LOCATION_FIELD, SCHEDULE_CONFIGURATION_FIELD, TRIGGER_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowVersionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workflowVersion;
    private final String workflowArn;
    private final Boolean isLatestVersion;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final DefinitionS3Location definitionS3Location;
    private final ScheduleConfiguration scheduleConfiguration;
    private final String triggerMode;

    private WorkflowVersionSummary(BuilderImpl builder) {
        this.workflowVersion = builder.workflowVersion;
        this.workflowArn = builder.workflowArn;
        this.isLatestVersion = builder.isLatestVersion;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.definitionS3Location = builder.definitionS3Location;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.triggerMode = builder.triggerMode;
    }

    public final String workflowVersion() {
        return this.workflowVersion;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final Boolean isLatestVersion() {
        return this.isLatestVersion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final DefinitionS3Location definitionS3Location() {
        return this.definitionS3Location;
    }

    public final ScheduleConfiguration scheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    public final String triggerMode() {
        return this.triggerMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerMode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowVersionSummary)) {
            return false;
        }
        WorkflowVersionSummary other = (WorkflowVersionSummary)obj;
        return Objects.equals(this.workflowVersion(), other.workflowVersion()) && Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.isLatestVersion(), other.isLatestVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.definitionS3Location(), other.definitionS3Location()) && Objects.equals(this.scheduleConfiguration(), other.scheduleConfiguration()) && Objects.equals(this.triggerMode(), other.triggerMode());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowVersionSummary").add("WorkflowVersion", (Object)this.workflowVersion()).add("WorkflowArn", (Object)this.workflowArn()).add("IsLatestVersion", (Object)this.isLatestVersion()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("DefinitionS3Location", (Object)this.definitionS3Location()).add("ScheduleConfiguration", (Object)this.scheduleConfiguration()).add("TriggerMode", (Object)this.triggerMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowVersion()));
            }
            case "WorkflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "IsLatestVersion": {
                return Optional.ofNullable(clazz.cast(this.isLatestVersion()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "DefinitionS3Location": {
                return Optional.ofNullable(clazz.cast(this.definitionS3Location()));
            }
            case "ScheduleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfiguration()));
            }
            case "TriggerMode": {
                return Optional.ofNullable(clazz.cast(this.triggerMode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("IsLatestVersion", IS_LATEST_VERSION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("DefinitionS3Location", DEFINITION_S3_LOCATION_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("TriggerMode", TRIGGER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowVersionSummary, T> g) {
        return obj -> g.apply((WorkflowVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workflowVersion;
        private String workflowArn;
        private Boolean isLatestVersion;
        private Instant createdAt;
        private Instant modifiedAt;
        private DefinitionS3Location definitionS3Location;
        private ScheduleConfiguration scheduleConfiguration;
        private String triggerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowVersionSummary model) {
            this.workflowVersion(model.workflowVersion);
            this.workflowArn(model.workflowArn);
            this.isLatestVersion(model.isLatestVersion);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.definitionS3Location(model.definitionS3Location);
            this.scheduleConfiguration(model.scheduleConfiguration);
            this.triggerMode(model.triggerMode);
        }

        public final String getWorkflowVersion() {
            return this.workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final Boolean getIsLatestVersion() {
            return this.isLatestVersion;
        }

        public final void setIsLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
        }

        @Override
        public final Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final DefinitionS3Location.Builder getDefinitionS3Location() {
            return this.definitionS3Location != null ? this.definitionS3Location.toBuilder() : null;
        }

        public final void setDefinitionS3Location(DefinitionS3Location.BuilderImpl definitionS3Location) {
            this.definitionS3Location = definitionS3Location != null ? definitionS3Location.build() : null;
        }

        @Override
        public final Builder definitionS3Location(DefinitionS3Location definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return this.scheduleConfiguration != null ? this.scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final String getTriggerMode() {
            return this.triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        public WorkflowVersionSummary build() {
            return new WorkflowVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowVersionSummary> {
        public Builder workflowVersion(String var1);

        public Builder workflowArn(String var1);

        public Builder isLatestVersion(Boolean var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder definitionS3Location(DefinitionS3Location var1);

        default public Builder definitionS3Location(Consumer<DefinitionS3Location.Builder> definitionS3Location) {
            return this.definitionS3Location((DefinitionS3Location)((DefinitionS3Location.Builder)DefinitionS3Location.builder().applyMutation(definitionS3Location)).build());
        }

        public Builder scheduleConfiguration(ScheduleConfiguration var1);

        default public Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return this.scheduleConfiguration((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(scheduleConfiguration)).build());
        }

        public Builder triggerMode(String var1);
    }
}

