/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mwaaserverless.model.MwaaServerlessResponse;
import software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceSummariesCopier;
import software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTaskInstancesResponse
extends MwaaServerlessResponse
implements ToCopyableBuilder<Builder, ListTaskInstancesResponse> {
    private static final SdkField<List<TaskInstanceSummary>> TASK_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskInstances").getter(ListTaskInstancesResponse.getter(ListTaskInstancesResponse::taskInstances)).setter(ListTaskInstancesResponse.setter(Builder::taskInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskInstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTaskInstancesResponse.getter(ListTaskInstancesResponse::nextToken)).setter(ListTaskInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTaskInstancesResponse.memberNameToFieldInitializer();
    private final List<TaskInstanceSummary> taskInstances;
    private final String nextToken;

    private ListTaskInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.taskInstances = builder.taskInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTaskInstances() {
        return this.taskInstances != null && !(this.taskInstances instanceof SdkAutoConstructList);
    }

    public final List<TaskInstanceSummary> taskInstances() {
        return this.taskInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskInstances() ? this.taskInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskInstancesResponse)) {
            return false;
        }
        ListTaskInstancesResponse other = (ListTaskInstancesResponse)((Object)obj);
        return this.hasTaskInstances() == other.hasTaskInstances() && Objects.equals(this.taskInstances(), other.taskInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTaskInstancesResponse").add("TaskInstances", this.hasTaskInstances() ? this.taskInstances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskInstances": {
                return Optional.ofNullable(clazz.cast(this.taskInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskInstances", TASK_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTaskInstancesResponse, T> g) {
        return obj -> g.apply((ListTaskInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaServerlessResponse.BuilderImpl
    implements Builder {
        private List<TaskInstanceSummary> taskInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskInstancesResponse model) {
            super(model);
            this.taskInstances(model.taskInstances);
            this.nextToken(model.nextToken);
        }

        public final List<TaskInstanceSummary.Builder> getTaskInstances() {
            List<TaskInstanceSummary.Builder> result = TaskInstanceSummariesCopier.copyToBuilder(this.taskInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskInstances(Collection<TaskInstanceSummary.BuilderImpl> taskInstances) {
            this.taskInstances = TaskInstanceSummariesCopier.copyFromBuilder(taskInstances);
        }

        @Override
        public final Builder taskInstances(Collection<TaskInstanceSummary> taskInstances) {
            this.taskInstances = TaskInstanceSummariesCopier.copy(taskInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskInstances(TaskInstanceSummary ... taskInstances) {
            this.taskInstances(Arrays.asList(taskInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskInstances(Consumer<TaskInstanceSummary.Builder> ... taskInstances) {
            this.taskInstances(Stream.of(taskInstances).map(c -> (TaskInstanceSummary)((TaskInstanceSummary.Builder)TaskInstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTaskInstancesResponse build() {
            return new ListTaskInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTaskInstancesResponse> {
        public Builder taskInstances(Collection<TaskInstanceSummary> var1);

        public Builder taskInstances(TaskInstanceSummary ... var1);

        public Builder taskInstances(Consumer<TaskInstanceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

