/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class MwaaServerlessEndpointParams
implements ToCopyableBuilder<Builder, MwaaServerlessEndpointParams> {
    private final Boolean useFIPS;
    private final String endpoint;
    private final Region region;

    private MwaaServerlessEndpointParams(BuilderImpl builder) {
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.region = builder.region;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Region region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Boolean useFIPS = false;
        private String endpoint;
        private Region region;

        private BuilderImpl() {
        }

        private BuilderImpl(MwaaServerlessEndpointParams builder) {
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.region = builder.region;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public MwaaServerlessEndpointParams build() {
            return new MwaaServerlessEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MwaaServerlessEndpointParams> {
        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public Builder region(Region var1);

        public MwaaServerlessEndpointParams build();
    }
}

