/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkflowRunStatus {
    STARTING("STARTING"),
    QUEUED("QUEUED"),
    RUNNING("RUNNING"),
    SUCCESS("SUCCESS"),
    FAILED("FAILED"),
    TIMEOUT("TIMEOUT"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkflowRunStatus> VALUE_MAP;
    private final String value;

    private WorkflowRunStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowRunStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowRunStatus> knownValues() {
        EnumSet<WorkflowRunStatus> knownValues = EnumSet.allOf(WorkflowRunStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkflowRunStatus.class, WorkflowRunStatus::toString);
    }
}

