/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mwaaserverless.MwaaServerlessClient;
import software.amazon.awssdk.services.mwaaserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsResponse;
import software.amazon.awssdk.services.mwaaserverless.model.WorkflowRunSummary;

public class ListWorkflowRunsIterable
implements SdkIterable<ListWorkflowRunsResponse> {
    private final MwaaServerlessClient client;
    private final ListWorkflowRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowRunsIterable(MwaaServerlessClient client, ListWorkflowRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowRunsResponseFetcher();
    }

    public Iterator<ListWorkflowRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowRunSummary> workflowRuns() {
        Function<ListWorkflowRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowRuns() != null) {
                return response.workflowRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowRunsResponseFetcher
    implements SyncPageFetcher<ListWorkflowRunsResponse> {
        private ListWorkflowRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowRunsResponse nextPage(ListWorkflowRunsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowRunsIterable.this.client.listWorkflowRuns(ListWorkflowRunsIterable.this.firstRequest);
            }
            return ListWorkflowRunsIterable.this.client.listWorkflowRuns((ListWorkflowRunsRequest)((Object)ListWorkflowRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

