/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mwaaserverless.model.GenericMapCopier;
import software.amazon.awssdk.services.mwaaserverless.model.MwaaServerlessResponse;
import software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTaskInstanceResponse
extends MwaaServerlessResponse
implements ToCopyableBuilder<Builder, GetTaskInstanceResponse> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowArn").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::workflowArn)).setter(GetTaskInstanceResponse.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::runId)).setter(GetTaskInstanceResponse.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> TASK_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskInstanceId").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::taskInstanceId)).setter(GetTaskInstanceResponse.setter(Builder::taskInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInstanceId").build()}).build();
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowVersion").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::workflowVersion)).setter(GetTaskInstanceResponse.setter(Builder::workflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::statusAsString)).setter(GetTaskInstanceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationInSeconds").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::durationInSeconds)).setter(GetTaskInstanceResponse.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()}).build();
    private static final SdkField<String> OPERATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatorName").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::operatorName)).setter(GetTaskInstanceResponse.setter(Builder::operatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatorName").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::modifiedAt)).setter(GetTaskInstanceResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::endedAt)).setter(GetTaskInstanceResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::startedAt)).setter(GetTaskInstanceResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> ATTEMPT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AttemptNumber").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::attemptNumber)).setter(GetTaskInstanceResponse.setter(Builder::attemptNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttemptNumber").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::errorMessage)).setter(GetTaskInstanceResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::taskId)).setter(GetTaskInstanceResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogStream").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::logStream)).setter(GetTaskInstanceResponse.setter(Builder::logStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStream").build()}).build();
    private static final SdkField<Map<String, String>> XCOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Xcom").getter(GetTaskInstanceResponse.getter(GetTaskInstanceResponse::xcom)).setter(GetTaskInstanceResponse.setter(Builder::xcom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Xcom").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD, RUN_ID_FIELD, TASK_INSTANCE_ID_FIELD, WORKFLOW_VERSION_FIELD, STATUS_FIELD, DURATION_IN_SECONDS_FIELD, OPERATOR_NAME_FIELD, MODIFIED_AT_FIELD, ENDED_AT_FIELD, STARTED_AT_FIELD, ATTEMPT_NUMBER_FIELD, ERROR_MESSAGE_FIELD, TASK_ID_FIELD, LOG_STREAM_FIELD, XCOM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTaskInstanceResponse.memberNameToFieldInitializer();
    private final String workflowArn;
    private final String runId;
    private final String taskInstanceId;
    private final String workflowVersion;
    private final String status;
    private final Integer durationInSeconds;
    private final String operatorName;
    private final Instant modifiedAt;
    private final Instant endedAt;
    private final Instant startedAt;
    private final Integer attemptNumber;
    private final String errorMessage;
    private final String taskId;
    private final String logStream;
    private final Map<String, String> xcom;

    private GetTaskInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.runId = builder.runId;
        this.taskInstanceId = builder.taskInstanceId;
        this.workflowVersion = builder.workflowVersion;
        this.status = builder.status;
        this.durationInSeconds = builder.durationInSeconds;
        this.operatorName = builder.operatorName;
        this.modifiedAt = builder.modifiedAt;
        this.endedAt = builder.endedAt;
        this.startedAt = builder.startedAt;
        this.attemptNumber = builder.attemptNumber;
        this.errorMessage = builder.errorMessage;
        this.taskId = builder.taskId;
        this.logStream = builder.logStream;
        this.xcom = builder.xcom;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String runId() {
        return this.runId;
    }

    public final String taskInstanceId() {
        return this.taskInstanceId;
    }

    public final String workflowVersion() {
        return this.workflowVersion;
    }

    public final TaskInstanceStatus status() {
        return TaskInstanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public final String operatorName() {
        return this.operatorName;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Integer attemptNumber() {
        return this.attemptNumber;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String logStream() {
        return this.logStream;
    }

    public final boolean hasXcom() {
        return this.xcom != null && !(this.xcom instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> xcom() {
        return this.xcom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.attemptNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasXcom() ? this.xcom() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaskInstanceResponse)) {
            return false;
        }
        GetTaskInstanceResponse other = (GetTaskInstanceResponse)((Object)obj);
        return Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.taskInstanceId(), other.taskInstanceId()) && Objects.equals(this.workflowVersion(), other.workflowVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.operatorName(), other.operatorName()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.attemptNumber(), other.attemptNumber()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.logStream(), other.logStream()) && this.hasXcom() == other.hasXcom() && Objects.equals(this.xcom(), other.xcom());
    }

    public final String toString() {
        return ToString.builder((String)"GetTaskInstanceResponse").add("WorkflowArn", (Object)this.workflowArn()).add("RunId", (Object)this.runId()).add("TaskInstanceId", (Object)this.taskInstanceId()).add("WorkflowVersion", (Object)this.workflowVersion()).add("Status", (Object)this.statusAsString()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("OperatorName", (Object)this.operatorName()).add("ModifiedAt", (Object)this.modifiedAt()).add("EndedAt", (Object)this.endedAt()).add("StartedAt", (Object)this.startedAt()).add("AttemptNumber", (Object)this.attemptNumber()).add("ErrorMessage", (Object)this.errorMessage()).add("TaskId", (Object)this.taskId()).add("LogStream", (Object)this.logStream()).add("Xcom", this.hasXcom() ? this.xcom() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "TaskInstanceId": {
                return Optional.ofNullable(clazz.cast(this.taskInstanceId()));
            }
            case "WorkflowVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "OperatorName": {
                return Optional.ofNullable(clazz.cast(this.operatorName()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "AttemptNumber": {
                return Optional.ofNullable(clazz.cast(this.attemptNumber()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "LogStream": {
                return Optional.ofNullable(clazz.cast(this.logStream()));
            }
            case "Xcom": {
                return Optional.ofNullable(clazz.cast(this.xcom()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("TaskInstanceId", TASK_INSTANCE_ID_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("OperatorName", OPERATOR_NAME_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("AttemptNumber", ATTEMPT_NUMBER_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("TaskId", TASK_ID_FIELD);
        map.put("LogStream", LOG_STREAM_FIELD);
        map.put("Xcom", XCOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTaskInstanceResponse, T> g) {
        return obj -> g.apply((GetTaskInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaServerlessResponse.BuilderImpl
    implements Builder {
        private String workflowArn;
        private String runId;
        private String taskInstanceId;
        private String workflowVersion;
        private String status;
        private Integer durationInSeconds;
        private String operatorName;
        private Instant modifiedAt;
        private Instant endedAt;
        private Instant startedAt;
        private Integer attemptNumber;
        private String errorMessage;
        private String taskId;
        private String logStream;
        private Map<String, String> xcom = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaskInstanceResponse model) {
            super(model);
            this.workflowArn(model.workflowArn);
            this.runId(model.runId);
            this.taskInstanceId(model.taskInstanceId);
            this.workflowVersion(model.workflowVersion);
            this.status(model.status);
            this.durationInSeconds(model.durationInSeconds);
            this.operatorName(model.operatorName);
            this.modifiedAt(model.modifiedAt);
            this.endedAt(model.endedAt);
            this.startedAt(model.startedAt);
            this.attemptNumber(model.attemptNumber);
            this.errorMessage(model.errorMessage);
            this.taskId(model.taskId);
            this.logStream(model.logStream);
            this.xcom(model.xcom);
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getTaskInstanceId() {
            return this.taskInstanceId;
        }

        public final void setTaskInstanceId(String taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
        }

        @Override
        public final Builder taskInstanceId(String taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
            return this;
        }

        public final String getWorkflowVersion() {
            return this.workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final String getOperatorName() {
            return this.operatorName;
        }

        public final void setOperatorName(String operatorName) {
            this.operatorName = operatorName;
        }

        @Override
        public final Builder operatorName(String operatorName) {
            this.operatorName = operatorName;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Integer getAttemptNumber() {
            return this.attemptNumber;
        }

        public final void setAttemptNumber(Integer attemptNumber) {
            this.attemptNumber = attemptNumber;
        }

        @Override
        public final Builder attemptNumber(Integer attemptNumber) {
            this.attemptNumber = attemptNumber;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getLogStream() {
            return this.logStream;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final Map<String, String> getXcom() {
            if (this.xcom instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.xcom;
        }

        public final void setXcom(Map<String, String> xcom) {
            this.xcom = GenericMapCopier.copy(xcom);
        }

        @Override
        public final Builder xcom(Map<String, String> xcom) {
            this.xcom = GenericMapCopier.copy(xcom);
            return this;
        }

        @Override
        public GetTaskInstanceResponse build() {
            return new GetTaskInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTaskInstanceResponse> {
        public Builder workflowArn(String var1);

        public Builder runId(String var1);

        public Builder taskInstanceId(String var1);

        public Builder workflowVersion(String var1);

        public Builder status(String var1);

        public Builder status(TaskInstanceStatus var1);

        public Builder durationInSeconds(Integer var1);

        public Builder operatorName(String var1);

        public Builder modifiedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder attemptNumber(Integer var1);

        public Builder errorMessage(String var1);

        public Builder taskId(String var1);

        public Builder logStream(String var1);

        public Builder xcom(Map<String, String> var1);
    }
}

